/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AbstractCompatibilityTransformer;

public class ServicesResourceTransformer
extends AbstractCompatibilityTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private final Map<String, ArrayList<String>> serviceEntries = new HashMap<String, ArrayList<String>>();
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        resource = resource.substring(SERVICES_PATH.length() + 1);
        for (Relocator relocator : relocators) {
            if (!relocator.canRelocateClass(resource)) continue;
            resource = relocator.relocateClass(resource);
            break;
        }
        resource = "META-INF/services/" + resource;
        ArrayList out = this.serviceEntries.computeIfAbsent(resource, k -> new ArrayList());
        Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name());
        while (scanner.hasNextLine()) {
            String relContent = scanner.nextLine();
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(relContent)) continue;
                relContent = relocator.applyToSourceContent(relContent);
            }
            out.add(relContent);
        }
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.serviceEntries.isEmpty();
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ArrayList<String>> entry : this.serviceEntries.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> data = entry.getValue();
            JarEntry jarEntry = new JarEntry(key);
            jarEntry.setTime(this.time);
            jos.putNextEntry(jarEntry);
            IOUtils.writeLines(data, (String)"\n", (OutputStream)jos, (Charset)StandardCharsets.UTF_8);
            jos.flush();
            data.clear();
        }
    }
}

