/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.plugins.shade.resource.properties.SortedProperties;
import org.apache.maven.plugins.shade.resource.properties.io.NoCloseOutputStream;
import org.apache.maven.plugins.shade.resource.properties.io.SkipPropertiesDateLineWriter;

public class PropertiesTransformer
implements ResourceTransformer {
    private String resource;
    private String alreadyMergedKey;
    private String ordinalKey;
    private int defaultOrdinal;
    private boolean reverseOrder;
    private long time = Long.MIN_VALUE;
    private final List<Properties> properties = new ArrayList<Properties>();

    public PropertiesTransformer() {
    }

    protected PropertiesTransformer(String resource, String ordinalKey, int defaultOrdinal, boolean reversed) {
        this.resource = resource;
        this.ordinalKey = ordinalKey;
        this.defaultOrdinal = defaultOrdinal;
        this.reverseOrder = reversed;
    }

    @Override
    public boolean canTransformResource(String resource) {
        return Objects.equals(resource, this.resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        Properties p = new Properties();
        p.load(is);
        this.properties.add(p);
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.properties.isEmpty();
    }

    @Override
    public void modifyOutputStream(JarOutputStream os) throws IOException {
        if (this.properties.isEmpty()) {
            return;
        }
        Properties out = PropertiesTransformer.mergeProperties(this.sortProperties());
        if (this.ordinalKey != null) {
            out.remove(this.ordinalKey);
        }
        if (this.alreadyMergedKey != null) {
            out.remove(this.alreadyMergedKey);
        }
        JarEntry jarEntry = new JarEntry(this.resource);
        jarEntry.setTime(this.time);
        os.putNextEntry(jarEntry);
        SkipPropertiesDateLineWriter writer = new SkipPropertiesDateLineWriter(new OutputStreamWriter((OutputStream)new NoCloseOutputStream(os), StandardCharsets.ISO_8859_1));
        out.store(writer, " Merged by maven-shade-plugin (" + this.getClass().getName() + ")");
        writer.close();
        os.closeEntry();
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setOrdinalKey(String ordinalKey) {
        this.ordinalKey = ordinalKey;
    }

    public void setDefaultOrdinal(int defaultOrdinal) {
        this.defaultOrdinal = defaultOrdinal;
    }

    public void setAlreadyMergedKey(String alreadyMergedKey) {
        this.alreadyMergedKey = alreadyMergedKey;
    }

    private List<Properties> sortProperties() {
        ArrayList<Properties> sortedProperties = new ArrayList<Properties>();
        boolean foundMaster = false;
        for (Properties current : this.properties) {
            int i;
            String master;
            if (this.alreadyMergedKey != null && Boolean.parseBoolean(master = current.getProperty(this.alreadyMergedKey))) {
                if (foundMaster) {
                    throw new IllegalStateException("Ambiguous merged values: " + sortedProperties + ", " + current);
                }
                foundMaster = true;
                sortedProperties.clear();
                sortedProperties.add(current);
            }
            if (foundMaster) continue;
            int configOrder = this.getConfigurationOrdinal(current);
            for (i = 0; i < sortedProperties.size(); ++i) {
                int listConfigOrder = this.getConfigurationOrdinal((Properties)sortedProperties.get(i));
                if (!this.reverseOrder && listConfigOrder > configOrder || this.reverseOrder && listConfigOrder < configOrder) break;
            }
            sortedProperties.add(i, current);
        }
        return sortedProperties;
    }

    private int getConfigurationOrdinal(Properties p) {
        if (this.ordinalKey == null) {
            return this.defaultOrdinal;
        }
        String configOrderString = p.getProperty(this.ordinalKey);
        if (configOrderString != null && configOrderString.length() > 0) {
            return Integer.parseInt(configOrderString);
        }
        return this.defaultOrdinal;
    }

    private static Properties mergeProperties(List<Properties> sortedProperties) {
        SortedProperties mergedProperties = new SortedProperties();
        for (Properties p : sortedProperties) {
            mergedProperties.putAll((Map<?, ?>)p);
        }
        return mergedProperties;
    }
}

