/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlAppendingTransformer
implements ResourceTransformer {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    boolean ignoreDtd = true;
    String resource;
    Document doc;
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String r) {
        return this.resource != null && this.resource.equalsIgnoreCase(r);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        Document r;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            builder.setExpandEntities(false);
            if (this.ignoreDtd) {
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new StringReader(""));
                    }
                });
            }
            r = builder.build(is);
        }
        catch (JDOMException e) {
            throw new RuntimeException("Error processing resource " + resource + ": " + e.getMessage(), e);
        }
        if (this.doc == null) {
            this.doc = r;
        } else {
            Element root = r.getRootElement();
            Iterator itr = root.getAttributes().iterator();
            while (itr.hasNext()) {
                Attribute a = (Attribute)itr.next();
                itr.remove();
                Element mergedEl = this.doc.getRootElement();
                Attribute mergedAtt = mergedEl.getAttribute(a.getName(), a.getNamespace());
                if (mergedAtt != null) continue;
                mergedEl.setAttribute(a);
            }
            itr = root.getChildren().iterator();
            while (itr.hasNext()) {
                Content n = (Content)itr.next();
                itr.remove();
                this.doc.getRootElement().addContent(n);
            }
        }
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return this.doc != null;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        JarEntry jarEntry = new JarEntry(this.resource);
        jarEntry.setTime(this.time);
        jos.putNextEntry(jarEntry);
        new XMLOutputter(Format.getPrettyFormat()).output(this.doc, (OutputStream)jos);
        this.doc = null;
    }
}

