/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="checkin", aggregator=true)
public class CheckinMojo
extends AbstractScmMojo {
    @Parameter(property="message")
    private String message;
    @Parameter(property="connectionType", defaultValue="developerConnection")
    private String connectionType;
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    @Parameter(property="signOption")
    private CommandParameters.SignOption signOption;

    @Inject
    public CheckinMojo(ScmManager manager, SettingsDecrypter settingsDecrypter) {
        super(manager, settingsDecrypter);
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        this.setConnectionType(this.connectionType);
        try {
            ScmRepository repository = this.getScmRepository();
            CommandParameters parameters = new CommandParameters();
            ScmVersion version = this.getScmVersion(this.scmVersionType, this.scmVersion);
            if (version != null) {
                parameters.setScmVersion(CommandParameter.SCM_VERSION, version);
            }
            if (this.message != null) {
                parameters.setString(CommandParameter.MESSAGE, this.message);
            }
            if (this.signOption != null) {
                parameters.setSignOption(CommandParameter.SIGN_OPTION, this.signOption);
            }
            CheckInScmResult result = this.getScmManager().checkIn(repository, this.getFileSet(), parameters);
            this.checkResult((ScmResult)result);
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run checkin command : ", (Exception)e);
        }
    }
}

