/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmBranchParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="branch", aggregator=true)
public class BranchMojo
extends AbstractScmMojo {
    @Parameter(property="branch", required=true)
    private String branch;
    @Parameter(property="message")
    private String message;
    @Parameter(property="remoteBranching", defaultValue="true")
    private boolean remoteBranching;
    @Parameter(property="pinExternals", defaultValue="false")
    private boolean pinExternals;

    @Inject
    public BranchMojo(ScmManager manager, SettingsDecrypter settingsDecrypter) {
        super(manager, settingsDecrypter);
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            String finalBranch = provider.sanitizeTagName(this.branch);
            this.getLog().debug((CharSequence)("Final Branch Name: '" + finalBranch + "'"));
            ScmBranchParameters scmBranchParameters = new ScmBranchParameters(this.message);
            scmBranchParameters.setRemoteBranching(this.remoteBranching);
            scmBranchParameters.setPinExternals(this.pinExternals);
            BranchScmResult result = provider.branch(repository, this.getFileSet(), finalBranch, scmBranchParameters);
            this.checkResult((ScmResult)result);
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run branch command", (Exception)e);
        }
    }
}

