/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-release-plugin:2.3.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Release Plugin", 0);
        this.append(sb, "This plugin is used to release a project with Maven, saving a lot of repetitive, manual work.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 9 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "branch".equals(this.goal)) {
            this.append(sb, "release:branch", 0);
            this.append(sb, "Branch a project in SCM, using the same steps as the release:prepare goal, creating a branch instead of a tag. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/branch.html.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addSchema (Default: true)", 2);
                this.append(sb, "Whether to add a schema to the POM if it was previously missing on release.", 3);
                this.append(sb, "Expression: ${addSchema}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoVersionSubmodules (Default: false)", 2);
                this.append(sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3);
                this.append(sb, "Expression: ${autoVersionSubmodules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "branchBase", 2);
                this.append(sb, "The branch base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/branches. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${branchBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "branchName", 2);
                this.append(sb, "The branch name to use.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${branchName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkModificationExcludeList", 2);
                this.append(sb, "Command-line version of checkModificationExcludes.", 3);
                this.append(sb, "Expression: ${checkModificationExcludeList}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkModificationExcludes", 2);
                this.append(sb, "A list of additional exclude filters that will be skipped when checking for modifications on the working copy. Is ignored, when checkModificationExcludes is set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "developmentVersion", 2);
                this.append(sb, "Default version to use for new local working copy.", 3);
                this.append(sb, "Expression: ${developmentVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "Dry run: don't checkin or tag anything in the scm repository, or modify the checkout. Running mvn -DdryRun=true release:prepare is useful in order to check that modifications to poms and scm operations (only listed on the console) are working as expected. Modified POMs are written alongside the originals without modifying them.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "releaseVersion", 2);
                this.append(sb, "Default version to use when preparing a release or a branch.", 3);
                this.append(sb, "Expression: ${releaseVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteTagging (Default: true)", 2);
                this.append(sb, "currently only implemented with svn scm. Enable a workaround to prevent issue due to svn client > 1.5.0 (http://jira.codehaus.org/browse/SCM-406)", 3);
                this.append(sb, "Expression: ${remoteTagging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressCommitBeforeBranch (Default: false)", 2);
                this.append(sb, "Whether to suppress a commit of changes to the working copy before the tag is created.\n\nThis requires remoteTagging to be set to false.\n\nsuppressCommitBeforeBranch is useful when you want to avoid poms with released versions in all revisions of your trunk or development branch.", 3);
                this.append(sb, "Expression: ${suppressCommitBeforeBranch}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateBranchVersions (Default: false)", 2);
                this.append(sb, "Whether to update versions in the branch.", 3);
                this.append(sb, "Expression: ${updateBranchVersions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateDependencies (Default: true)", 2);
                this.append(sb, "Whether to update dependencies version to the next development version.", 3);
                this.append(sb, "Expression: ${updateDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateVersionsToSnapshot (Default: true)", 2);
                this.append(sb, "Whether to update versions to SNAPSHOT in the branch.", 3);
                this.append(sb, "Expression: ${updateVersionsToSnapshot}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateWorkingCopyVersions (Default: true)", 2);
                this.append(sb, "Whether to update versions in the working copy.", 3);
                this.append(sb, "Expression: ${updateWorkingCopyVersions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useEditMode (Default: false)", 2);
                this.append(sb, "Whether to use 'edit' mode on the SCM, to lock the file for editing during SCM operations.", 3);
                this.append(sb, "Expression: ${useEditMode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "release:clean", 0);
            this.append(sb, "Clean up after a release preparation. This is done automatically after a successful release:perform, so is best served for cleaning up a failed or abandoned release, or a dry run. Note that only the working copy is cleaned up, no previous steps are rolled back. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/clean-release.html.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "release:help", 0);
            this.append(sb, "Display help information on maven-release-plugin.\nCall\n\u00a0\u00a0mvn\u00a0release:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "perform".equals(this.goal)) {
            this.append(sb, "release:perform", 0);
            this.append(sb, "Perform a release from SCM, either from a specified tag, or the tag representing the previous release in the working copy created by release:prepare. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/perform-release.html.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl", 2);
                this.append(sb, "The SCM URL to checkout from. If omitted, the one from the release.properties file is used, followed by the URL from the current POM.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "Dry run: don't checkout anything from the scm repository, or modify the checkout. The goals (by default at least deploy) will be executed against the current project.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "A space separated list of goals to execute on deployment. Default value is either deploy or deploy site-deploy, if the project has a <distributionManagement>/<site> element.", 3);
                this.append(sb, "Expression: ${goals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "releaseProfiles", 2);
                this.append(sb, "Comma separated profiles to enable on deployment, in addition to active profiles for project execution.", 3);
                this.append(sb, "Expression: ${releaseProfiles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useReleaseProfile (Default: true)", 2);
                this.append(sb, "Whether to use the release profile that adds sources and javadocs to the released artifact, if appropriate. If set to true, the release plugin sets the property 'performRelease' to true, which activates the profile 'release-profile', which is inherited from the super pom.", 3);
                this.append(sb, "Expression: ${useReleaseProfile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${project.build.directory}/checkout)", 2);
                this.append(sb, "The checkout directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "prepare".equals(this.goal)) {
            this.append(sb, "release:prepare", 0);
            this.append(sb, "Prepare for a release in SCM. Steps through several phases to ensure the POM is ready to be released and then prepares SCM to eventually contain a tagged version of the release and a record in the local copy of the parameters used. This can be followed by a call to release:perform. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/prepare-release.html.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addSchema (Default: true)", 2);
                this.append(sb, "Whether to add a schema to the POM if it was previously missing on release.", 3);
                this.append(sb, "Expression: ${addSchema}", 3);
                this.append(sb, "", 0);
                this.append(sb, "allowTimestampedSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow timestamped SNAPSHOT dependencies. Default is to fail when finding any SNAPSHOT.", 3);
                this.append(sb, "Expression: ${ignoreSnapshots}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoVersionSubmodules (Default: false)", 2);
                this.append(sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3);
                this.append(sb, "Expression: ${autoVersionSubmodules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkModificationExcludeList", 2);
                this.append(sb, "Command-line version of checkModificationExcludes.", 3);
                this.append(sb, "Expression: ${checkModificationExcludeList}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkModificationExcludes", 2);
                this.append(sb, "A list of additional exclude filters that will be skipped when checking for modifications on the working copy. Is ignored, when checkModificationExcludes is set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "commitByProject (Default: false)", 2);
                this.append(sb, "Commits to do are atomic or by project.", 3);
                this.append(sb, "Expression: ${commitByProject}", 3);
                this.append(sb, "", 0);
                this.append(sb, "completionGoals", 2);
                this.append(sb, "Goals to run on completion of the preparation step, after transformation back to the next development version but before committing. Space delimited.", 3);
                this.append(sb, "Expression: ${completionGoals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developmentVersion", 2);
                this.append(sb, "Default version to use for new local working copy.", 3);
                this.append(sb, "Expression: ${developmentVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "Dry run: don't checkin or tag anything in the scm repository, or modify the checkout. Running mvn -DdryRun=true release:prepare is useful in order to check that modifications to poms and scm operations (only listed on the console) are working as expected. Modified POMs are written alongside the originals without modifying them.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateReleasePoms (Default: false)", 2);
                this.append(sb, "Deprecated. Please use release:prepare-with-pom instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${generateReleasePoms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "preparationGoals (Default: clean verify)", 2);
                this.append(sb, "Goals to run as part of the preparation step, after transformation but before committing. Space delimited.", 3);
                this.append(sb, "Expression: ${preparationGoals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "releaseVersion", 2);
                this.append(sb, "Default version to use when preparing a release or a branch.", 3);
                this.append(sb, "Expression: ${releaseVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteTagging (Default: true)", 2);
                this.append(sb, "Currently only implemented with svn scm.\n-\tEnables a workaround to prevent issue due to svn client > 1.5.0 (fixed in 1.6.5) (http://jira.codehaus.org/browse/SCM-406)\n-\tYou may not want to use this in conjunction with suppressCommitBeforeTag, such that no poms with released versions are committed to the working copy ever.\n", 3);
                this.append(sb, "Expression: ${remoteTagging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resume (Default: true)", 2);
                this.append(sb, "Resume a previous release attempt from the point where it was stopped.", 3);
                this.append(sb, "Expression: ${resume}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressCommitBeforeTag (Default: false)", 2);
                this.append(sb, "Whether to suppress a commit of changes to the working copy before the tag is created.\n\nThis requires remoteTagging to be set to false.\n\nsuppressCommitBeforeTag is useful when you want to avoid poms with released versions in all revisions of your trunk or development branch.", 3);
                this.append(sb, "Expression: ${suppressCommitBeforeTag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateDependencies (Default: true)", 2);
                this.append(sb, "Whether to update dependencies version to the next development version.", 3);
                this.append(sb, "Expression: ${updateDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateWorkingCopyVersions (Default: true)", 2);
                this.append(sb, "Whether to bump the working copy versions to developmentVersion.", 3);
                this.append(sb, "Expression: ${updateWorkingCopyVersions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useEditMode (Default: false)", 2);
                this.append(sb, "Whether to use 'edit' mode on the SCM, to lock the file for editing during SCM operations.", 3);
                this.append(sb, "Expression: ${useEditMode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "waitBeforeTagging (Default: 0)", 2);
                this.append(sb, "Wait the specified number of second before creating the tag.\nwaitBeforeTagging is useful when your source repository is synced between several instances and access to it is determined by geographical location, like the SVN repository at the Apache Software Foundation.", 3);
                this.append(sb, "Expression: ${waitBeforeTagging}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "prepare-with-pom".equals(this.goal)) {
            this.append(sb, "release:prepare-with-pom", 0);
            this.append(sb, "Prepare for a release in SCM, fully resolving dependencies for the purpose of producing a 'release POM'.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addSchema (Default: true)", 2);
                this.append(sb, "Whether to add a schema to the POM if it was previously missing on release.", 3);
                this.append(sb, "Expression: ${addSchema}", 3);
                this.append(sb, "", 0);
                this.append(sb, "allowTimestampedSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow timestamped SNAPSHOT dependencies. Default is to fail when finding any SNAPSHOT.", 3);
                this.append(sb, "Expression: ${ignoreSnapshots}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoVersionSubmodules (Default: false)", 2);
                this.append(sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3);
                this.append(sb, "Expression: ${autoVersionSubmodules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkModificationExcludeList", 2);
                this.append(sb, "Command-line version of checkModificationExcludes.", 3);
                this.append(sb, "Expression: ${checkModificationExcludeList}", 3);
                this.append(sb, "", 0);
                this.append(sb, "checkModificationExcludes", 2);
                this.append(sb, "A list of additional exclude filters that will be skipped when checking for modifications on the working copy. Is ignored, when checkModificationExcludes is set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "commitByProject (Default: false)", 2);
                this.append(sb, "Commits to do are atomic or by project.", 3);
                this.append(sb, "Expression: ${commitByProject}", 3);
                this.append(sb, "", 0);
                this.append(sb, "completionGoals", 2);
                this.append(sb, "Goals to run on completion of the preparation step, after transformation back to the next development version but before committing. Space delimited.", 3);
                this.append(sb, "Expression: ${completionGoals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developmentVersion", 2);
                this.append(sb, "Default version to use for new local working copy.", 3);
                this.append(sb, "Expression: ${developmentVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "Dry run: don't checkin or tag anything in the scm repository, or modify the checkout. Running mvn -DdryRun=true release:prepare is useful in order to check that modifications to poms and scm operations (only listed on the console) are working as expected. Modified POMs are written alongside the originals without modifying them.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateReleasePoms (Default: true)", 2);
                this.append(sb, "Whether to generate release-pom.xml files that contain resolved information about the project.", 3);
                this.append(sb, "Expression: ${generateReleasePoms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "preparationGoals (Default: clean verify)", 2);
                this.append(sb, "Goals to run as part of the preparation step, after transformation but before committing. Space delimited.", 3);
                this.append(sb, "Expression: ${preparationGoals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "releaseVersion", 2);
                this.append(sb, "Default version to use when preparing a release or a branch.", 3);
                this.append(sb, "Expression: ${releaseVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteTagging (Default: true)", 2);
                this.append(sb, "Currently only implemented with svn scm.\n-\tEnables a workaround to prevent issue due to svn client > 1.5.0 (fixed in 1.6.5) (http://jira.codehaus.org/browse/SCM-406)\n-\tYou may not want to use this in conjunction with suppressCommitBeforeTag, such that no poms with released versions are committed to the working copy ever.\n", 3);
                this.append(sb, "Expression: ${remoteTagging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resume (Default: true)", 2);
                this.append(sb, "Resume a previous release attempt from the point where it was stopped.", 3);
                this.append(sb, "Expression: ${resume}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressCommitBeforeTag (Default: false)", 2);
                this.append(sb, "Whether to suppress a commit of changes to the working copy before the tag is created.\n\nThis requires remoteTagging to be set to false.\n\nsuppressCommitBeforeTag is useful when you want to avoid poms with released versions in all revisions of your trunk or development branch.", 3);
                this.append(sb, "Expression: ${suppressCommitBeforeTag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateDependencies (Default: true)", 2);
                this.append(sb, "Whether to update dependencies version to the next development version.", 3);
                this.append(sb, "Expression: ${updateDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateWorkingCopyVersions (Default: true)", 2);
                this.append(sb, "Whether to bump the working copy versions to developmentVersion.", 3);
                this.append(sb, "Expression: ${updateWorkingCopyVersions}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useEditMode (Default: false)", 2);
                this.append(sb, "Whether to use 'edit' mode on the SCM, to lock the file for editing during SCM operations.", 3);
                this.append(sb, "Expression: ${useEditMode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "waitBeforeTagging (Default: 0)", 2);
                this.append(sb, "Wait the specified number of second before creating the tag.\nwaitBeforeTagging is useful when your source repository is synced between several instances and access to it is determined by geographical location, like the SVN repository at the Apache Software Foundation.", 3);
                this.append(sb, "Expression: ${waitBeforeTagging}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rollback".equals(this.goal)) {
            this.append(sb, "release:rollback", 0);
            this.append(sb, "Rollback changes made by a previous release. This requires that the previous release descriptor release.properties is still available in the local working copy. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/rollback-release.html.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stage".equals(this.goal)) {
            this.append(sb, "release:stage", 0);
            this.append(sb, "Perform a release from SCM to a staging repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectionUrl", 2);
                this.append(sb, "The SCM URL to checkout from. If omitted, the one from the release.properties file is used, followed by the URL from the current POM.", 3);
                this.append(sb, "Expression: ${connectionUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "A comma or space separated list of goals to execute on deployment. Default value is either deploy or deploy site-deploy, if the project has a <distributionManagement>/<site> element.", 3);
                this.append(sb, "Expression: ${goals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "releaseProfiles", 2);
                this.append(sb, "Comma separated profiles to enable on deployment, in addition to active profiles for project execution.", 3);
                this.append(sb, "Expression: ${releaseProfiles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingRepository", 2);
                this.append(sb, "URL of the staging repository to use.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${stagingRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useReleaseProfile (Default: true)", 2);
                this.append(sb, "Whether to use the release profile that adds sources and javadocs to the released artifact, if appropriate.", 3);
                this.append(sb, "Expression: ${useReleaseProfile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${project.build.directory}/checkout)", 2);
                this.append(sb, "The checkout directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${workingDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-versions".equals(this.goal)) {
            this.append(sb, "release:update-versions", 0);
            this.append(sb, "Update the POM versions for a project. This performs the normal version updates of the release:prepare goal without making other modifications to the SCM such as tagging. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/update-versions.html.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addSchema (Default: true)", 2);
                this.append(sb, "Whether to add a schema to the POM if it was previously missing on release.", 3);
                this.append(sb, "Expression: ${addSchema}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "Additional arguments to pass to the Maven executions, separated by spaces.", 3);
                this.append(sb, "Expression: ${arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoVersionSubmodules (Default: false)", 2);
                this.append(sb, "Whether to automatically assign submodules the parent version. If set to false, the user will be prompted for the version of each submodules.", 3);
                this.append(sb, "Expression: ${autoVersionSubmodules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "developmentVersion", 2);
                this.append(sb, "Default version to use for new local working copy.", 3);
                this.append(sb, "Expression: ${developmentVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome (Default: ${java.home})", 2);
                this.append(sb, "The JAVA_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localCheckout (Default: false)", 2);
                this.append(sb, "Use a local checkout instead of doing a checkout from the upstream repository. ATTENTION: This will only work with distributed SCMs which support the file:// protocol like e.g. git, jgit or hg! TODO: we should think about having the defaults for the various SCM providers provided via modello!", 3);
                this.append(sb, "Expression: ${localCheckout}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepoDirectory (Default: ${maven.repo.local})", 2);
                this.append(sb, "The command-line local repository directory in use for this build (if specified).", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenExecutorId (Default: invoker)", 2);
                this.append(sb, "Role hint of the MavenExecutor implementation to use.", 3);
                this.append(sb, "Expression: ${mavenExecutorId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome (Default: ${maven.home})", 2);
                this.append(sb, "The M2_HOME parameter to use for forked Maven invocations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The SCM password to use.", 3);
                this.append(sb, "Expression: ${password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomFileName", 2);
                this.append(sb, "The file name of the POM to execute any goals against.", 3);
                this.append(sb, "Expression: ${pomFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "providerImplementations", 2);
                this.append(sb, "Add a new or overwrite the default implementation per provider. The key is the scm prefix and the value is the role hint of the ScmProvider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pushChanges (Default: true)", 2);
                this.append(sb, "Implemented with git will or not push changes to the upstream repository. true by default to preserve backward compatibility.", 3);
                this.append(sb, "Expression: ${pushChanges}", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmCommentPrefix (Default: [maven-release-plugin] )", 2);
                this.append(sb, "The message prefix to use for all SCM changes.", 3);
                this.append(sb, "Expression: ${scmCommentPrefix}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The SCM tag to use.", 3);
                this.append(sb, "Expression: ${tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in SVN, you must define it if you don't use the standard svn layout (trunk/tags/branches). For example, http://svn.apache.org/repos/asf/maven/plugins/tags. The URL is an SVN URL and does not include the SCM provider and protocol.", 3);
                this.append(sb, "Expression: ${tagBase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagNameFormat (Default: @{project.artifactId}-@{project.version})", 2);
                this.append(sb, "Format to use when generating the tag name if none is specified. Property interpolation is performed on the tag, but in order to ensure that the interpolation occurs during release, you must use @{...} to reference the properties rather than ${...}. The following properties are available:\n-\tgroupId or project.groupId - The groupId of the root project.\n-\tartifactId or project.artifactId - The artifactId of the root project.\n-\tversion or project.version - The release version of the root project.\n", 3);
                this.append(sb, "Expression: ${tagNameFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The SCM username to use.", 3);
                this.append(sb, "Expression: ${username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

