/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.exec.MavenExecutor;
import org.apache.maven.plugins.release.exec.MavenExecutorException;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.codehaus.plexus.util.StringUtils;

public class RunGoalsPhase
extends AbstractReleasePhase {
    private MavenExecutor mavenExecutor;

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException {
        try {
            String goals = releaseConfiguration.getPreparationGoals();
            if (!StringUtils.isEmpty((String)goals)) {
                this.getLogger().info("Executing preparation goals '" + goals + "'...");
                this.mavenExecutor.executeGoals(releaseConfiguration.getWorkingDirectory(), goals, releaseConfiguration.isInteractive(), releaseConfiguration.getAdditionalArguments());
            }
        }
        catch (MavenExecutorException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException {
        this.getLogger().info("Executing preparation goals - since this is simulation mode it is running against the original project, not the rewritten ones");
        this.execute(releaseConfiguration);
    }

    public void setMavenExecutor(MavenExecutor mavenExecutor) {
        this.mavenExecutor = mavenExecutor;
    }
}

