/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.plugins.release.scm.ScmTranslator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForReleasePhase
extends AbstractRewritePomsPhase {
    private Map scmTranslators;

    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseConfiguration releaseConfiguration, String projectId, ScmRepository scmRepository) {
        if (project.getScm() != null) {
            Element scmRoot = rootElement.getChild("scm", namespace);
            if (scmRoot != null) {
                releaseConfiguration.mapOriginalScmInfo(projectId, project.getScm());
                this.translateScm(project, releaseConfiguration, scmRoot, namespace, scmRepository);
            } else {
                releaseConfiguration.mapOriginalScmInfo(projectId, null);
                MavenProject parent = project.getParent();
                if (parent != null) {
                    String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
                    if (!releaseConfiguration.getOriginalScmInfo().containsKey(parentId)) {
                        scmRoot = new Element("scm");
                        scmRoot.addContent("\n  ");
                        if (this.translateScm(project, releaseConfiguration, scmRoot, namespace, scmRepository)) {
                            rootElement.addContent("\n  ").addContent((Content)scmRoot).addContent("\n");
                        }
                    }
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseConfiguration releaseConfiguration, Element scmRoot, Namespace namespace, ScmRepository scmRepository) {
        ScmTranslator translator = (ScmTranslator)this.scmTranslators.get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            Scm scm = project.getScm();
            String tag = releaseConfiguration.getReleaseLabel();
            String tagBase = releaseConfiguration.getTagBase();
            if (tagBase != null) {
                tagBase = "scm:svn:" + tagBase;
            }
            if (scm.getConnection() != null && !(value = translator.translateTagUrl(scm.getConnection(), tag, tagBase)).equals(scm.getConnection())) {
                this.rewriteElement("connection", value, scmRoot, namespace);
                result = true;
            }
            if (scm.getDeveloperConnection() != null && !(value = translator.translateTagUrl(scm.getDeveloperConnection(), tag, tagBase)).equals(scm.getDeveloperConnection())) {
                this.rewriteElement("developerConnection", value, scmRoot, namespace);
                result = true;
            }
            if (scm.getUrl() != null && !(value = translator.translateTagUrl(scm.getUrl(), tag, releaseConfiguration.getTagBase())).equals(scm.getUrl())) {
                this.rewriteElement("url", value, scmRoot, namespace);
                result = true;
            }
            if (tag != null && (value = translator.resolveTag(tag)) != null && !value.equals(scm.getTag())) {
                this.rewriteElement("tag", value, scmRoot, namespace);
                result = true;
            }
        } else {
            this.getLogger().debug("No SCM translator found - skipping rewrite");
        }
        return result;
    }

    protected Map getOriginalVersionMap(ReleaseConfiguration releaseConfiguration) {
        return releaseConfiguration.getOriginalVersions();
    }

    protected Map getNextVersionMap(ReleaseConfiguration releaseConfiguration) {
        return releaseConfiguration.getReleaseVersions();
    }
}

