/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.util.Map;
import org.apache.maven.model.Scm;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.plugins.release.scm.ScmTranslator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForDevelopmentPhase
extends AbstractRewritePomsPhase {
    private Map scmTranslators;

    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseConfiguration releaseConfiguration, String projectId, ScmRepository scmRepository) throws ReleaseExecutionException {
        Element scmRoot;
        if (project.getScm() != null && (scmRoot = rootElement.getChild("scm", namespace)) != null) {
            Map originalScmInfo = releaseConfiguration.getOriginalScmInfo();
            if (!originalScmInfo.containsKey(projectId)) {
                throw new ReleaseExecutionException("Unable to find original SCM info for '" + project.getName() + "'");
            }
            ScmTranslator translator = (ScmTranslator)this.scmTranslators.get(scmRepository.getProvider());
            if (translator != null) {
                Scm scm = (Scm)originalScmInfo.get(projectId);
                if (scm != null) {
                    this.rewriteElement("connection", scm.getConnection(), scmRoot, namespace);
                    this.rewriteElement("developerConnection", scm.getDeveloperConnection(), scmRoot, namespace);
                    this.rewriteElement("url", scm.getUrl(), scmRoot, namespace);
                    this.rewriteElement("tag", translator.resolveTag(scm.getTag()), scmRoot, namespace);
                } else {
                    this.rewriteElement("scm", null, rootElement, namespace);
                }
            } else {
                this.getLogger().debug("No SCM translator found - skipping rewrite");
            }
        }
    }

    protected Map getOriginalVersionMap(ReleaseConfiguration releaseConfiguration) {
        return releaseConfiguration.getReleaseVersions();
    }

    protected Map getNextVersionMap(ReleaseConfiguration releaseConfiguration) {
        return releaseConfiguration.getDevelopmentVersions();
    }
}

