/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.util.Iterator;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.plugins.release.versions.DefaultVersionInfo;
import org.apache.maven.plugins.release.versions.VersionParseException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class MapVersionsPhase
extends AbstractReleasePhase {
    private boolean convertToSnapshot;
    private Prompter prompter;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException {
        Iterator i = releaseConfiguration.getReactorProjects().iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            DefaultVersionInfo version = null;
            try {
                version = new DefaultVersionInfo(project.getVersion());
            }
            catch (VersionParseException e) {
                String msg = "Error parsing version, cannot determine next version: " + e.getMessage();
                if (releaseConfiguration.isInteractive()) {
                    this.getLogger().warn(msg);
                    this.getLogger().debug(e.getMessage(), (Throwable)e);
                }
                throw new ReleaseExecutionException(msg, e);
            }
            try {
                String nextVersion;
                if (this.convertToSnapshot) {
                    nextVersion = null;
                    if (version != null) {
                        nextVersion = version.getNextVersion().getSnapshotVersionString();
                    }
                    if (releaseConfiguration.isInteractive()) {
                        nextVersion = this.prompter.prompt("What is the new development version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                    }
                    releaseConfiguration.mapDevelopmentVersion(projectId, nextVersion);
                    continue;
                }
                nextVersion = null;
                if (version != null) {
                    nextVersion = version.getReleaseVersionString();
                }
                if (releaseConfiguration.isInteractive()) {
                    nextVersion = this.prompter.prompt("What is the release version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                }
                releaseConfiguration.mapReleaseVersion(projectId, nextVersion);
            }
            catch (PrompterException e) {
                throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
            }
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException {
        this.execute(releaseConfiguration);
    }
}

