/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class InputVariablesPhase
extends AbstractReleasePhase {
    private Prompter prompter;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException {
        MavenProject project = (MavenProject)releaseConfiguration.getReactorProjects().get(0);
        String tag = releaseConfiguration.getReleaseLabel();
        if (tag == null) {
            String key = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String releaseVersion = (String)releaseConfiguration.getReleaseVersions().get(key);
            if (releaseVersion == null) {
                throw new ReleaseExecutionException("Project tag cannot be selected if version is not yet mapped");
            }
            String defaultTag = project.getArtifactId() + "-" + releaseVersion;
            if (releaseConfiguration.isInteractive()) {
                try {
                    tag = this.prompter.prompt("What is SCM release tag or label for \"" + project.getName() + "\"? (" + project.getGroupId() + ":" + project.getArtifactId() + ")", defaultTag);
                }
                catch (PrompterException e) {
                    throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
                }
            } else {
                tag = defaultTag;
            }
            releaseConfiguration.setReleaseLabel(tag);
        }
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException {
        this.execute(releaseConfiguration);
    }
}

