/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class CheckDependencySnapshotsPhase
extends AbstractReleasePhase {
    private Prompter prompter;

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.getLogger().info("Checking dependencies and plugins for snapshots ...");
        List reactorProjects = releaseConfiguration.getReactorProjects();
        Map originalVersions = releaseConfiguration.getOriginalVersions();
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject project = (MavenProject)i.next();
            this.checkProject(project, originalVersions, releaseConfiguration);
        }
    }

    private void checkProject(MavenProject project, Map originalVersions, ReleaseConfiguration releaseConfiguration) throws ReleaseFailureException, ReleaseExecutionException {
        Artifact artifact;
        HashSet<Artifact> snapshotDependencies = new HashSet<Artifact>();
        if (project.getParentArtifact() != null && CheckDependencySnapshotsPhase.checkArtifact(project.getParentArtifact(), originalVersions)) {
            snapshotDependencies.add(project.getParentArtifact());
        }
        Iterator i = project.getArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions)) continue;
            snapshotDependencies.add(artifact);
        }
        i = project.getPluginArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions)) continue;
            boolean addToFailures = true;
            if ("org.apache.maven.plugins".equals(artifact.getGroupId()) && "maven-release-plugin".equals(artifact.getArtifactId()) && releaseConfiguration.isInteractive()) {
                try {
                    this.prompter.showMessage("This project relies on a SNAPSHOT of the release plugin. This may be necessary during testing.");
                    String result = this.prompter.prompt("Do you want to continue with the release?", Arrays.asList("yes", "no"), "no");
                    if (result.toLowerCase().startsWith("y")) {
                        addToFailures = false;
                    }
                }
                catch (PrompterException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            if (!addToFailures) continue;
            snapshotDependencies.add(artifact);
        }
        i = project.getReportArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions)) continue;
            snapshotDependencies.add(artifact);
        }
        i = project.getExtensionArtifacts().iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, originalVersions)) continue;
            snapshotDependencies.add(artifact);
        }
        if (!snapshotDependencies.isEmpty()) {
            ArrayList snapshotsList = new ArrayList(snapshotDependencies);
            Collections.sort(snapshotsList);
            StringBuffer message = new StringBuffer();
            Iterator i2 = snapshotsList.iterator();
            while (i2.hasNext()) {
                Artifact artifact2 = (Artifact)i2.next();
                message.append("    ");
                message.append(artifact2);
                message.append("\n");
            }
            message.append("in project '" + project.getName() + "' (" + project.getId() + ")");
            throw new ReleaseFailureException("Can't release project due to non released dependencies :\n" + message);
        }
    }

    private static boolean checkArtifact(Artifact artifact, Map originalVersions) {
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        return artifact.isSnapshot() && !artifact.getBaseVersion().equals(originalVersions.get(versionlessArtifactKey));
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.execute(releaseConfiguration);
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }
}

