/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.phase;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.phase.AbstractReleasePhase;
import org.apache.maven.plugins.release.scm.ReleaseScmCommandException;
import org.apache.maven.plugins.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.plugins.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public abstract class AbstractRewritePomsPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private static final String LS = System.getProperty("line.separator");
    private String pomSuffix;

    public void execute(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.transform(releaseConfiguration, false);
    }

    private void transform(ReleaseConfiguration releaseConfiguration, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        Iterator it = releaseConfiguration.getReactorProjects().iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            this.getLogger().info("Transforming '" + project.getName() + "'...");
            this.transformProject(project, releaseConfiguration, simulate);
        }
    }

    private void transformProject(MavenProject project, ReleaseConfiguration releaseConfiguration, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        ScmProvider provider;
        ScmRepository scmRepository;
        Document document;
        String intro = null;
        String outtro = null;
        try {
            String content = FileUtils.fileRead((File)project.getFile());
            content = content.replaceAll("<([^!][^>]*?)\\s{2,}([^>]*?)>", "<$1 $2>");
            content = content.replaceAll("(\\s{2,}|[^\\s])/>", "$1 />");
            SAXBuilder builder = new SAXBuilder();
            document = builder.build((Reader)new StringReader(content));
            this.normaliseLineEndings(document);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            format.setLineSeparator(LS);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            int index = content.indexOf(w.toString());
            if (index >= 0) {
                intro = content.substring(0, index);
                outtro = content.substring(index + w.toString().length());
            }
        }
        catch (JDOMException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
        try {
            scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseConfiguration);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        this.transformDocument(project, document.getRootElement(), releaseConfiguration, scmRepository);
        if (simulate) {
            File outputFile = new File(project.getFile().getParentFile(), project.getFile().getName() + "." + this.pomSuffix);
            this.writePom(outputFile, document, releaseConfiguration, project.getModelVersion(), intro, outtro);
        } else {
            this.writePom(project.getFile(), document, releaseConfiguration, project.getModelVersion(), intro, outtro, scmRepository, provider);
        }
    }

    private void normaliseLineEndings(Document document) {
        Iterator i = document.getDescendants((Filter)new ContentFilter(8));
        while (i.hasNext()) {
            Comment c = (Comment)i.next();
            c.setText(c.getText().replaceAll("\n", LS));
        }
    }

    private void transformDocument(MavenProject project, Element rootElement, ReleaseConfiguration releaseConfiguration, ScmRepository scmRepository) throws ReleaseExecutionException, ReleaseFailureException {
        Element pluginsRoot;
        Element buildRoot;
        Element dependencyRoot;
        Namespace namespace = rootElement.getNamespace();
        Map mappedVersions = this.getNextVersionMap(releaseConfiguration);
        Map originalVersions = this.getOriginalVersionMap(releaseConfiguration);
        String parentVersion = this.rewriteParent(project, rootElement, namespace, mappedVersions, originalVersions);
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        this.rewriteVersion(rootElement, namespace, mappedVersions, projectId, project, parentVersion);
        this.rewriteDependencies(project.getDependencies(), rootElement, mappedVersions, originalVersions, projectId);
        if (project.getDependencyManagement() != null && (dependencyRoot = rootElement.getChild("dependencyManagement", namespace)) != null) {
            this.rewriteDependencies(project.getDependencyManagement().getDependencies(), dependencyRoot, mappedVersions, originalVersions, projectId);
        }
        if (project.getBuild() != null && (buildRoot = rootElement.getChild("build", namespace)) != null) {
            Element pluginsRoot2;
            this.rewritePlugins(project.getBuildPlugins(), buildRoot, mappedVersions, originalVersions, projectId);
            if (project.getPluginManagement() != null && (pluginsRoot2 = buildRoot.getChild("pluginManagement", namespace)) != null) {
                this.rewritePlugins(project.getPluginManagement().getPlugins(), pluginsRoot2, mappedVersions, originalVersions, projectId);
            }
            this.rewriteExtensions(project.getBuildExtensions(), buildRoot, mappedVersions, originalVersions, projectId);
        }
        if (project.getReporting() != null && (pluginsRoot = rootElement.getChild("reporting", namespace)) != null) {
            this.rewriteReportPlugins(project.getReportPlugins(), pluginsRoot, mappedVersions, originalVersions, projectId);
        }
        this.transformScm(project, rootElement, namespace, releaseConfiguration, projectId, scmRepository);
    }

    private void rewriteVersion(Element rootElement, Namespace namespace, Map mappedVersions, String projectId, MavenProject project, String parentVersion) throws ReleaseFailureException {
        Element versionElement = rootElement.getChild("version", namespace);
        String version = (String)mappedVersions.get(projectId);
        if (version == null) {
            throw new ReleaseFailureException("Version for '" + project.getName() + "' was not mapped");
        }
        if (versionElement == null) {
            if (!version.equals(parentVersion)) {
                Element artifactIdElement = rootElement.getChild("artifactId", namespace);
                int index = rootElement.indexOf((Content)artifactIdElement);
                versionElement = new Element("version", namespace);
                versionElement.setText(version);
                rootElement.addContent(index + 1, (Content)new Text("\n  "));
                rootElement.addContent(index + 2, (Content)versionElement);
            }
        } else {
            versionElement.setText(version);
        }
    }

    private String rewriteParent(MavenProject project, Element rootElement, Namespace namespace, Map mappedVersions, Map originalVersions) throws ReleaseFailureException {
        String parentVersion = null;
        if (project.hasParent()) {
            Element parentElement = rootElement.getChild("parent", namespace);
            Element versionElement = parentElement.getChild("version", namespace);
            MavenProject parent = project.getParent();
            String key = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
            parentVersion = (String)mappedVersions.get(key);
            if (parentVersion == null) {
                if (parent.getVersion().equals(originalVersions.get(key))) {
                    throw new ReleaseFailureException("Version for parent '" + parent.getName() + "' was not mapped");
                }
            } else {
                versionElement.setText(parentVersion);
            }
        }
        return parentVersion;
    }

    private void rewriteDependencies(List dependencies, Element dependencyRoot, Map mappedVersions, Map originalVersions, String projectId) throws ReleaseExecutionException, ReleaseFailureException {
        if (dependencies != null) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                Dependency dep = (Dependency)i.next();
                this.updateDomVersion(dep.getGroupId(), dep.getArtifactId(), mappedVersions, dep.getVersion(), originalVersions, "dependencies", "dependency", dependencyRoot, projectId);
            }
        }
    }

    private void rewritePlugins(List plugins, Element pluginRoot, Map mappedVersions, Map originalVersions, String projectId) throws ReleaseExecutionException, ReleaseFailureException {
        if (plugins != null) {
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                if (plugin.getVersion() == null) continue;
                this.updateDomVersion(plugin.getGroupId(), plugin.getArtifactId(), mappedVersions, plugin.getVersion(), originalVersions, "plugins", "plugin", pluginRoot, projectId);
            }
        }
    }

    private void rewriteExtensions(List extensions, Element extensionRoot, Map mappedVersions, Map originalVersions, String projectId) throws ReleaseExecutionException, ReleaseFailureException {
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext()) {
                Extension extension = (Extension)i.next();
                this.updateDomVersion(extension.getGroupId(), extension.getArtifactId(), mappedVersions, extension.getVersion(), originalVersions, "extensions", "extension", extensionRoot, projectId);
            }
        }
    }

    private void rewriteReportPlugins(List plugins, Element pluginRoot, Map mappedVersions, Map originalVersions, String projectId) throws ReleaseExecutionException, ReleaseFailureException {
        if (plugins != null) {
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                ReportPlugin plugin = (ReportPlugin)i.next();
                if (plugin.getVersion() == null) continue;
                this.updateDomVersion(plugin.getGroupId(), plugin.getArtifactId(), mappedVersions, plugin.getVersion(), originalVersions, "plugins", "plugin", pluginRoot, projectId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDomVersion(String groupId, String artifactId, Map mappedVersions, String version, Map originalVersions, String groupTagName, String tagName, Element dependencyRoot, String projectId) throws ReleaseExecutionException, ReleaseFailureException {
        String key = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        String mappedVersion = (String)mappedVersions.get(key);
        Object originalVersion = originalVersions.get(key);
        if (!version.equals(originalVersion)) return;
        if (mappedVersion == null) throw new ReleaseFailureException("Version '" + version + "' for " + tagName + " '" + key + "' was not mapped");
        this.getLogger().debug("Updating " + artifactId + " to " + mappedVersion);
        try {
            Element versionElement;
            XPath xpath;
            if (!StringUtils.isEmpty((String)dependencyRoot.getNamespaceURI())) {
                xpath = XPath.newInstance((String)("./pom:" + groupTagName + "/pom:" + tagName + "[pom:groupId='" + groupId + "' and pom:artifactId='" + artifactId + "']"));
                xpath.addNamespace("pom", dependencyRoot.getNamespaceURI());
            } else {
                xpath = XPath.newInstance((String)("./" + groupTagName + "/" + tagName + "[groupId='" + groupId + "' and artifactId='" + artifactId + "']"));
            }
            Element dependency = (Element)xpath.selectSingleNode((Object)dependencyRoot);
            if (dependency == null || (versionElement = dependency.getChild("version", dependencyRoot.getNamespace())) == null || !originalVersion.equals(versionElement.getTextTrim()) && mappedVersion.equals(mappedVersions.get(projectId))) return;
            versionElement.setText(mappedVersion);
            return;
        }
        catch (JDOMException e) {
            throw new ReleaseExecutionException("Unable to locate " + tagName + " to process in document", e);
        }
    }

    private void writePom(File pomFile, Document document, ReleaseConfiguration releaseConfiguration, String modelVersion, String intro, String outtro, ScmRepository repository, ScmProvider provider) throws ReleaseExecutionException, ReleaseScmCommandException {
        try {
            EditScmResult result;
            if ((releaseConfiguration.isUseEditMode() || provider.requiresEditMode()) && !(result = provider.edit(repository, new ScmFileSet(releaseConfiguration.getWorkingDirectory(), pomFile))).isSuccess()) {
                throw new ReleaseScmCommandException("Unable to enable editing on the POM", (ScmResult)result);
            }
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred enabling edit mode: " + e.getMessage(), e);
        }
        this.writePom(pomFile, document, releaseConfiguration, modelVersion, intro, outtro);
    }

    private void writePom(File pomFile, Document document, ReleaseConfiguration releaseConfiguration, String modelVersion, String intro, String outtro) throws ReleaseExecutionException {
        Element rootElement = document.getRootElement();
        if (releaseConfiguration.isAddSchema()) {
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)("http://maven.apache.org/POM/" + modelVersion));
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/" + modelVersion + " http://maven.apache.org/maven-v" + modelVersion.replace('.', '_') + ".xsd", xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            Iterator i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(pomFile);
            if (intro != null) {
                writer.write(intro);
            }
            Format format = Format.getRawFormat();
            format.setLineSeparator(LS);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)writer);
            if (outtro != null) {
                writer.write(outtro);
            }
        }
        catch (IOException e) {
            try {
                throw new ReleaseExecutionException("Error writing POM: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public void simulate(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.transform(releaseConfiguration, true);
    }

    public void clean(ReleaseConfiguration config) {
        super.clean(config);
        if (config.getReactorProjects() != null) {
            Iterator i = config.getReactorProjects().iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                File file = new File(project.getFile().getParentFile(), project.getFile().getName() + "." + this.pomSuffix);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    protected abstract Map getOriginalVersionMap(ReleaseConfiguration var1);

    protected abstract Map getNextVersionMap(ReleaseConfiguration var1);

    protected abstract void transformScm(MavenProject var1, Element var2, Namespace var3, ReleaseConfiguration var4, String var5, ScmRepository var6) throws ReleaseExecutionException;

    protected Element rewriteElement(String name, String value, Element root, Namespace namespace) {
        Element tagElement = root.getChild(name, namespace);
        if (tagElement != null) {
            if (value != null) {
                tagElement.setText(value);
            } else {
                int index = root.indexOf((Content)tagElement);
                root.removeContent(index);
                for (int i = index - 1; i >= 0 && root.getContent(i) instanceof Text; --i) {
                    root.removeContent(i);
                }
            }
        } else if (value != null) {
            Element element = new Element(name, namespace);
            element.setText(value);
            root.addContent("  ").addContent((Content)element).addContent("\n  ");
            tagElement = element;
        }
        return tagElement;
    }
}

