/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.exec;

import java.io.File;
import org.apache.maven.plugins.release.exec.CommandLineFactory;
import org.apache.maven.plugins.release.exec.MavenExecutor;
import org.apache.maven.plugins.release.exec.MavenExecutorException;
import org.apache.maven.plugins.release.exec.TeeConsumer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkedMavenExecutor
extends AbstractLogEnabled
implements MavenExecutor {
    private CommandLineFactory commandLineFactory;

    public void executeGoals(File workingDirectory, String goals, boolean interactive, String additionalArguments, String pomFileName) throws MavenExecutorException {
        Commandline cl = this.commandLineFactory.createCommandLine("mvn");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        if (pomFileName != null) {
            cl.createArgument().setLine("-f " + pomFileName);
        }
        if (goals != null) {
            String[] tokens = StringUtils.split((String)goals, (String)", ");
            for (int i = 0; i < tokens.length; ++i) {
                cl.createArgument().setValue(tokens[i]);
            }
        }
        cl.createArgument().setValue("--no-plugin-updates");
        if (!interactive) {
            cl.createArgument().setValue("--batch-mode");
        }
        if (!StringUtils.isEmpty((String)additionalArguments)) {
            cl.createArgument().setLine(additionalArguments);
        }
        TeeConsumer stdOut = new TeeConsumer(System.out);
        TeeConsumer stdErr = new TeeConsumer(System.err);
        try {
            this.getLogger().info("Executing: " + cl.toString());
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdOut, (StreamConsumer)stdErr);
            if (result != 0) {
                throw new MavenExecutorException("Maven execution failed, exit code: '" + result + "'", result, ((Object)stdOut).toString(), ((Object)stdErr).toString());
            }
        }
        catch (CommandLineException e) {
            throw new MavenExecutorException("Can't run goal " + goals, ((Object)stdOut).toString(), ((Object)stdErr).toString(), (Exception)((Object)e));
        }
    }

    public void executeGoals(File workingDirectory, String goals, boolean interactive, String arguments) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, interactive, arguments, null);
    }

    public void setCommandLineFactory(CommandLineFactory commandLineFactory) {
        this.commandLineFactory = commandLineFactory;
    }
}

