/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release.config;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public class ReleaseConfiguration {
    private String completedPhase;
    private Settings settings;
    private String tagBase;
    private String username;
    private String password;
    private String url;
    private String privateKey;
    private String passphrase;
    private File workingDirectory;
    private List reactorProjects;
    private boolean useEditMode;
    private boolean addSchema;
    private boolean generateReleasePoms;
    private boolean interactive = true;
    private Map releaseVersions = new HashMap();
    private Map developmentVersions = new HashMap();
    private Map originalScmInfo = new HashMap();
    private Map originalVersions;
    private String releaseLabel;
    private String additionalArguments;
    private String pomFileName;
    private String preparationGoals;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getPreparationGoals() {
        return this.preparationGoals;
    }

    public void setPreparationGoals(String preparationGoals) {
        this.preparationGoals = preparationGoals;
    }

    public void setPomFileName(String pomFileName) {
        this.pomFileName = pomFileName;
    }

    public String getPomFileName() {
        return this.pomFileName;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isGenerateReleasePoms() {
        return this.generateReleasePoms;
    }

    public String getCompletedPhase() {
        return this.completedPhase;
    }

    public void setCompletedPhase(String completedPhase) {
        this.completedPhase = completedPhase;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getTagBase() {
        return this.tagBase;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public List getReactorProjects() {
        return this.reactorProjects;
    }

    public void setReactorProjects(List reactorProjects) {
        this.reactorProjects = reactorProjects;
        this.originalVersions = null;
    }

    public boolean isUseEditMode() {
        return this.useEditMode;
    }

    public boolean isAddSchema() {
        return this.addSchema;
    }

    public void setUseEditMode(boolean useEditMode) {
        this.useEditMode = useEditMode;
    }

    public void setAddSchema(boolean addSchema) {
        this.addSchema = addSchema;
    }

    public void setGenerateReleasePoms(boolean generateReleasePoms) {
        this.generateReleasePoms = generateReleasePoms;
    }

    public Map getReleaseVersions() {
        return Collections.unmodifiableMap(this.releaseVersions);
    }

    public Map getDevelopmentVersions() {
        return Collections.unmodifiableMap(this.developmentVersions);
    }

    public Map getOriginalScmInfo() {
        return Collections.unmodifiableMap(this.originalScmInfo);
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public void merge(ReleaseConfiguration mergeConfiguration) {
        this.url = ReleaseConfiguration.mergeOverride(this.url, mergeConfiguration.url);
        this.releaseLabel = ReleaseConfiguration.mergeOverride(this.releaseLabel, mergeConfiguration.releaseLabel);
        this.tagBase = ReleaseConfiguration.mergeOverride(this.tagBase, mergeConfiguration.tagBase);
        this.username = ReleaseConfiguration.mergeOverride(this.username, mergeConfiguration.username);
        this.password = ReleaseConfiguration.mergeOverride(this.password, mergeConfiguration.password);
        this.privateKey = ReleaseConfiguration.mergeOverride(this.privateKey, mergeConfiguration.privateKey);
        this.passphrase = ReleaseConfiguration.mergeOverride(this.passphrase, mergeConfiguration.passphrase);
        this.additionalArguments = ReleaseConfiguration.mergeOverride(this.additionalArguments, mergeConfiguration.additionalArguments);
        this.preparationGoals = ReleaseConfiguration.mergeOverride(this.preparationGoals, mergeConfiguration.preparationGoals);
        this.pomFileName = ReleaseConfiguration.mergeOverride(this.pomFileName, mergeConfiguration.pomFileName);
        this.useEditMode = mergeConfiguration.useEditMode;
        this.addSchema = mergeConfiguration.addSchema;
        this.generateReleasePoms = mergeConfiguration.generateReleasePoms;
        this.interactive = mergeConfiguration.interactive;
        this.settings = ReleaseConfiguration.mergeOverride(this.settings, mergeConfiguration.settings);
        this.workingDirectory = ReleaseConfiguration.mergeOverride(this.workingDirectory, mergeConfiguration.workingDirectory);
        this.reactorProjects = this.mergeOverride(this.reactorProjects, mergeConfiguration.reactorProjects);
        this.completedPhase = ReleaseConfiguration.mergeDefault(this.completedPhase, mergeConfiguration.completedPhase);
    }

    private List mergeOverride(List thisValue, List mergeValue) {
        return mergeValue != null ? mergeValue : thisValue;
    }

    private static File mergeOverride(File thisValue, File mergeValue) {
        return mergeValue != null ? mergeValue : thisValue;
    }

    private static String mergeOverride(String thisValue, String mergeValue) {
        return mergeValue != null ? mergeValue : thisValue;
    }

    private static Settings mergeOverride(Settings thisValue, Settings mergeValue) {
        return mergeValue != null ? mergeValue : thisValue;
    }

    private static String mergeDefault(String thisValue, String mergeValue) {
        return thisValue != null ? thisValue : mergeValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseConfiguration that = (ReleaseConfiguration)obj;
        if (this.addSchema != that.addSchema) {
            return false;
        }
        if (this.generateReleasePoms != that.generateReleasePoms) {
            return false;
        }
        if (this.interactive != that.interactive) {
            return false;
        }
        if (this.useEditMode != that.useEditMode) {
            return false;
        }
        if (this.completedPhase != null ? !this.completedPhase.equals(that.completedPhase) : that.completedPhase != null) {
            return false;
        }
        if (this.developmentVersions != null ? !((Object)this.developmentVersions).equals(that.developmentVersions) : that.developmentVersions != null) {
            return false;
        }
        if (this.originalScmInfo != null ? !this.compareScmCollections(that.originalScmInfo) : that.originalScmInfo != null) {
            return false;
        }
        if (this.additionalArguments != null ? !this.additionalArguments.equals(that.additionalArguments) : that.additionalArguments != null) {
            return false;
        }
        if (this.preparationGoals != null ? !this.preparationGoals.equals(that.preparationGoals) : that.preparationGoals != null) {
            return false;
        }
        if (this.pomFileName != null ? !this.pomFileName.equals(that.pomFileName) : that.pomFileName != null) {
            return false;
        }
        if (this.passphrase != null ? !this.passphrase.equals(that.passphrase) : that.passphrase != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) {
            return false;
        }
        if (this.reactorProjects != null ? !((Object)this.reactorProjects).equals(that.reactorProjects) : that.reactorProjects != null) {
            return false;
        }
        if (this.releaseLabel != null ? !this.releaseLabel.equals(that.releaseLabel) : that.releaseLabel != null) {
            return false;
        }
        if (this.releaseVersions != null ? !((Object)this.releaseVersions).equals(that.releaseVersions) : that.releaseVersions != null) {
            return false;
        }
        if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) {
            return false;
        }
        if (this.tagBase != null ? !this.tagBase.equals(that.tagBase) : that.tagBase != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        return !(this.workingDirectory != null ? !this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory != null);
    }

    private boolean compareScmCollections(Map that) {
        if (that.size() != this.originalScmInfo.size()) {
            return false;
        }
        Iterator i = this.originalScmInfo.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Scm thatScm = (Scm)that.get(entry.getKey());
            Scm thisScm = (Scm)entry.getValue();
            if (thatScm == null && thisScm == null) {
                return true;
            }
            if (thatScm == null) {
                return false;
            }
            if (thisScm == null) {
                return true;
            }
            if (thisScm.getConnection() != null ? !thisScm.getConnection().equals(thatScm.getConnection()) : thatScm.getConnection() != null) {
                return false;
            }
            if (thisScm.getDeveloperConnection() != null ? !thisScm.getDeveloperConnection().equals(thatScm.getDeveloperConnection()) : thatScm.getDeveloperConnection() != null) {
                return false;
            }
            if (thisScm.getUrl() != null ? !thisScm.getUrl().equals(thatScm.getUrl()) : thatScm.getUrl() != null) {
                return false;
            }
            if (!(thisScm.getTag() != null ? !thisScm.getTag().equals(thatScm.getTag()) : thatScm.getTag() != null)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.completedPhase != null ? this.completedPhase.hashCode() : 0;
        result = 29 * result + (this.settings != null ? this.settings.hashCode() : 0);
        result = 29 * result + (this.releaseLabel != null ? this.releaseLabel.hashCode() : 0);
        result = 29 * result + (this.additionalArguments != null ? this.additionalArguments.hashCode() : 0);
        result = 29 * result + (this.preparationGoals != null ? this.preparationGoals.hashCode() : 0);
        result = 29 * result + (this.pomFileName != null ? this.pomFileName.hashCode() : 0);
        result = 29 * result + (this.tagBase != null ? this.tagBase.hashCode() : 0);
        result = 29 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 29 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 29 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 29 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
        result = 29 * result + (this.passphrase != null ? this.passphrase.hashCode() : 0);
        result = 29 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
        result = 29 * result + (this.reactorProjects != null ? ((Object)this.reactorProjects).hashCode() : 0);
        result = 29 * result + (this.useEditMode ? 1 : 0);
        result = 29 * result + (this.addSchema ? 1 : 0);
        result = 29 * result + (this.generateReleasePoms ? 1 : 0);
        result = 29 * result + (this.interactive ? 1 : 0);
        result = 29 * result + (this.releaseVersions != null ? ((Object)this.releaseVersions).hashCode() : 0);
        result = 29 * result + (this.developmentVersions != null ? ((Object)this.developmentVersions).hashCode() : 0);
        result = 29 * result + (this.originalScmInfo != null ? ((Object)this.originalScmInfo).hashCode() : 0);
        return result;
    }

    public void mapReleaseVersion(String projectId, String nextVersion) {
        if (!$assertionsDisabled && this.releaseVersions.containsKey(projectId)) {
            throw new AssertionError();
        }
        this.releaseVersions.put(projectId, nextVersion);
    }

    public void mapDevelopmentVersion(String projectId, String nextVersion) {
        if (!$assertionsDisabled && this.developmentVersions.containsKey(projectId)) {
            throw new AssertionError();
        }
        this.developmentVersions.put(projectId, nextVersion);
    }

    public void mapOriginalScmInfo(String projectId, Scm scm) {
        if (!$assertionsDisabled && this.originalScmInfo.containsKey(projectId)) {
            throw new AssertionError();
        }
        this.originalScmInfo.put(projectId, scm);
    }

    public synchronized Map getOriginalVersions() {
        if (this.originalVersions == null) {
            this.originalVersions = new HashMap();
            Iterator i = this.reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                this.originalVersions.put(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()), project.getVersion());
            }
        }
        return this.originalVersions;
    }

    static {
        $assertionsDisabled = !ReleaseConfiguration.class.desiredAssertionStatus();
    }
}

