/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.release.ReleaseExecutionException;
import org.apache.maven.plugins.release.ReleaseFailureException;
import org.apache.maven.plugins.release.ReleaseManager;
import org.apache.maven.plugins.release.config.ReleaseConfiguration;
import org.apache.maven.plugins.release.config.ReleaseConfigurationStore;
import org.apache.maven.plugins.release.config.ReleaseConfigurationStoreException;
import org.apache.maven.plugins.release.exec.MavenExecutor;
import org.apache.maven.plugins.release.exec.MavenExecutorException;
import org.apache.maven.plugins.release.phase.ReleasePhase;
import org.apache.maven.plugins.release.scm.ReleaseScmCommandException;
import org.apache.maven.plugins.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.plugins.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultReleaseManager
extends AbstractLogEnabled
implements ReleaseManager {
    private List phases;
    private Map releasePhases;
    private ReleaseConfigurationStore configStore;
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private MavenExecutor mavenExecutor;

    public void prepare(ReleaseConfiguration releaseConfiguration) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseConfiguration, true, false);
    }

    public void prepare(ReleaseConfiguration releaseConfiguration, boolean resume, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseConfiguration config;
        if (resume) {
            try {
                config = this.configStore.read(releaseConfiguration);
            }
            catch (ReleaseConfigurationStoreException e) {
                throw new ReleaseExecutionException("Error reading stored configuration: " + e.getMessage(), e);
            }
        } else {
            config = releaseConfiguration;
        }
        String completedPhase = config.getCompletedPhase();
        int index = this.phases.indexOf(completedPhase);
        if (index == this.phases.size() - 1) {
            this.getLogger().info("Release preparation already completed. You can now continue with release:perform, or start again using the -Dresume=false flag");
        } else if (index >= 0) {
            this.getLogger().info("Resuming release from phase '" + this.phases.get(index + 1) + "'");
        }
        for (int i = index + 1; i < this.phases.size(); ++i) {
            String name = (String)this.phases.get(i);
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            if (dryRun) {
                phase.simulate(config);
            } else {
                phase.execute(config);
            }
            config.setCompletedPhase(name);
            try {
                this.configStore.write(config);
                continue;
            }
            catch (ReleaseConfigurationStoreException e) {
                throw new ReleaseExecutionException("Error writing release properties after completing phase", e);
            }
        }
    }

    public void perform(ReleaseConfiguration releaseConfiguration, File checkoutDirectory, String goals, boolean useReleaseProfile) throws ReleaseExecutionException, ReleaseFailureException {
        CheckOutScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseConfiguration config;
        this.getLogger().info("Checking out the project to perform the release ...");
        try {
            config = this.configStore.read(releaseConfiguration);
        }
        catch (ReleaseConfigurationStoreException e) {
            throw new ReleaseExecutionException("Error reading stored configuration: " + e.getMessage(), e);
        }
        if (config.getCompletedPhase() != null && !"end-release".equals(config.getCompletedPhase())) {
            throw new ReleaseFailureException("Cannot perform release - the preparation step was stopped mid-way. Please re-run release:prepare to continue, or perform the release from an SCM tag.");
        }
        if (config.getUrl() == null) {
            throw new ReleaseFailureException("No SCM URL was provided to perform the release from");
        }
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(config);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        if (checkoutDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)checkoutDirectory);
            }
            catch (IOException e) {
                throw new ReleaseExecutionException("Unable to remove old checkout directory: " + e.getMessage(), e);
            }
        }
        checkoutDirectory.mkdirs();
        try {
            result = provider.checkOut(repository, new ScmFileSet(checkoutDirectory), config.getReleaseLabel());
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the checkout process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to checkout from SCM", (ScmResult)result);
        }
        String additionalArguments = config.getAdditionalArguments();
        if (useReleaseProfile) {
            additionalArguments = !StringUtils.isEmpty((String)additionalArguments) ? additionalArguments + " -DperformRelease=true" : "-DperformRelease=true";
        }
        try {
            this.mavenExecutor.executeGoals(checkoutDirectory, goals, config.isInteractive(), additionalArguments, config.getPomFileName());
        }
        catch (MavenExecutorException e) {
            throw new ReleaseExecutionException("Error executing Maven: " + e.getMessage(), e);
        }
        this.clean(config);
    }

    public void clean(ReleaseConfiguration releaseConfiguration) {
        this.getLogger().info("Cleaning up after release...");
        this.configStore.delete(releaseConfiguration);
        Iterator i = this.phases.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            phase.clean(releaseConfiguration);
        }
    }

    void setConfigStore(ReleaseConfigurationStore configStore) {
        this.configStore = configStore;
    }

    void setMavenExecutor(MavenExecutor mavenExecutor) {
        this.mavenExecutor = mavenExecutor;
    }
}

