/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.pmd.PMDVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pmd.PmdFileInfo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractPmdReport
extends AbstractMavenReport {
    @Parameter(property="project.build.directory", required=true)
    protected File targetDirectory;
    @Parameter(property="format", defaultValue="xml")
    protected String format = "xml";
    @Parameter(property="linkXRef", defaultValue="true")
    private boolean linkXRef;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref")
    private File xrefLocation;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref-test")
    private File xrefTestLocation;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<String> includes;
    @Parameter(defaultValue="${project.compileSourceRoots}")
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.testCompileSourceRoots}")
    private List<String> testSourceRoots;
    @Parameter
    private File[] excludeRoots;
    @Parameter(defaultValue="false")
    protected boolean includeTests;
    @Deprecated
    @Parameter(property="aggregate", defaultValue="false")
    protected boolean aggregate;
    @Parameter(defaultValue="false")
    protected boolean includeXmlInSite;
    @Parameter(defaultValue="false")
    protected boolean skipEmptyReport;
    @Parameter(property="pmd.excludeFromFailureFile", defaultValue="")
    protected String excludeFromFailureFile;
    @Parameter(defaultValue="true", property="pmd.showPmdLog")
    protected boolean showPmdLog = true;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    protected Map<File, PmdFileInfo> filesToProcess;

    protected MavenProject getProject() {
        return this.project;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    protected String constructXRefLocation(boolean test) {
        String location = null;
        if (this.linkXRef) {
            File xrefLoc = test ? this.xrefTestLocation : this.xrefLocation;
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory.getAbsolutePath(), (String)xrefLoc.getAbsolutePath());
            if (relativePath == null || relativePath.isEmpty()) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + xrefLoc.getName();
            if (xrefLoc.exists()) {
                location = relativePath;
            } else {
                Reporting reporting = this.project.getModel().getReporting();
                List reportPlugins = reporting != null ? reporting.getPlugins() : Collections.emptyList();
                for (ReportPlugin plugin : reportPlugins) {
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    protected Map<File, PmdFileInfo> getFilesToProcess() throws IOException {
        File sroot;
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return Collections.emptyMap();
        }
        if (this.excludeRoots == null) {
            this.excludeRoots = new File[0];
        }
        HashSet<File> excludeRootFiles = new HashSet<File>(this.excludeRoots.length);
        for (File file : this.excludeRoots) {
            if (!file.isDirectory()) continue;
            excludeRootFiles.add(file);
        }
        ArrayList<PmdFileInfo> directories = new ArrayList<PmdFileInfo>();
        if (null == this.compileSourceRoots) {
            this.compileSourceRoots = this.project.getCompileSourceRoots();
        }
        if (this.compileSourceRoots != null) {
            for (String root : this.compileSourceRoots) {
                sroot = new File(root);
                if (!sroot.exists()) continue;
                String sourceXref = this.constructXRefLocation(false);
                directories.add(new PmdFileInfo(this.project, sroot, sourceXref));
            }
        }
        if (null == this.testSourceRoots) {
            this.testSourceRoots = this.project.getTestCompileSourceRoots();
        }
        if (this.includeTests && this.testSourceRoots != null) {
            for (String root : this.testSourceRoots) {
                sroot = new File(root);
                if (!sroot.exists()) continue;
                String testXref = this.constructXRefLocation(true);
                directories.add(new PmdFileInfo(this.project, sroot, testXref));
            }
        }
        if (this.isAggregator()) {
            for (MavenProject localProject : this.getAggregatedProjects()) {
                Object root2;
                List localCompileSourceRoots = localProject.getCompileSourceRoots();
                for (Object root2 : localCompileSourceRoots) {
                    File sroot2 = new File((String)root2);
                    if (!sroot2.exists()) continue;
                    String sourceXref = this.constructXRefLocation(false);
                    directories.add(new PmdFileInfo(localProject, sroot2, sourceXref));
                }
                if (!this.includeTests) continue;
                List localTestCompileSourceRoots = localProject.getTestCompileSourceRoots();
                root2 = localTestCompileSourceRoots.iterator();
                while (root2.hasNext()) {
                    String root3 = (String)root2.next();
                    File sroot3 = new File(root3);
                    if (!sroot3.exists()) continue;
                    String testXref = this.constructXRefLocation(true);
                    directories.add(new PmdFileInfo(localProject, sroot3, testXref));
                }
            }
        }
        String excluding = this.getExcludes();
        this.getLog().debug((CharSequence)("Exclusions: " + excluding));
        String including = this.getIncludes();
        this.getLog().debug((CharSequence)("Inclusions: " + including));
        TreeMap<File, PmdFileInfo> files = new TreeMap<File, PmdFileInfo>();
        for (PmdFileInfo finfo : directories) {
            this.getLog().debug((CharSequence)("Searching for files in directory " + finfo.getSourceDirectory().toString()));
            File sourceDirectory = finfo.getSourceDirectory();
            if (!sourceDirectory.isDirectory() || this.isDirectoryExcluded(excludeRootFiles, sourceDirectory)) continue;
            List newfiles = FileUtils.getFiles((File)sourceDirectory, (String)including, (String)excluding);
            for (File newfile : newfiles) {
                files.put(newfile.getCanonicalFile(), finfo);
            }
        }
        return files;
    }

    private boolean isDirectoryExcluded(Collection<File> excludeRootFiles, File sourceDirectoryToCheck) {
        boolean returnVal = false;
        for (File excludeDir : excludeRootFiles) {
            try {
                if (!sourceDirectoryToCheck.getCanonicalFile().toPath().startsWith(excludeDir.getCanonicalFile().toPath())) continue;
                this.getLog().debug((CharSequence)("Directory " + sourceDirectoryToCheck.getAbsolutePath() + " has been excluded as it matches excludeRoot " + excludeDir.getAbsolutePath()));
                returnVal = true;
                break;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Error while checking " + sourceDirectoryToCheck + " whether it should be excluded."), (Throwable)e);
            }
        }
        return returnVal;
    }

    private String getIncludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (this.includes != null) {
            patterns.addAll(this.includes);
        }
        if (patterns.isEmpty()) {
            patterns.add("**/*.java");
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    private String getExcludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>(FileUtils.getDefaultExcludesAsList());
        if (this.excludes != null) {
            patterns.addAll(this.excludes);
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    protected boolean isXml() {
        return "xml".equals(this.format);
    }

    public boolean canGenerateReport() {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return false;
        }
        if (!this.isAggregator() && "pom".equalsIgnoreCase(this.project.getPackaging())) {
            return false;
        }
        if (this.isXml()) {
            return true;
        }
        try {
            this.filesToProcess = this.getFilesToProcess();
            if (this.filesToProcess.isEmpty()) {
                return false;
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        return true;
    }

    protected String determineCurrentRootLogLevel() {
        String logLevel = System.getProperty("org.slf4j.simpleLogger.defaultLogLevel");
        if (logLevel == null) {
            logLevel = System.getProperty("maven.logging.root.level");
        }
        if (logLevel == null) {
            logLevel = "info";
        }
        return logLevel;
    }

    static String getPmdVersion() {
        return PMDVersion.VERSION;
    }

    protected final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.jdkToolchain != null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", this.jdkToolchain);
                if (tcs != null && !tcs.isEmpty()) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    protected boolean isAggregator() {
        return this.aggregate;
    }

    protected Collection<MavenProject> getAggregatedProjects() {
        HashMap<Path, MavenProject> reactorProjectsMap = new HashMap<Path, MavenProject>();
        for (MavenProject reactorProject : this.reactorProjects) {
            reactorProjectsMap.put(reactorProject.getBasedir().toPath(), reactorProject);
        }
        return this.modulesForAggregatedProject(this.project, reactorProjectsMap);
    }

    private Set<MavenProject> modulesForAggregatedProject(MavenProject aggregatedProject, Map<Path, MavenProject> reactorProjectsMap) {
        if (aggregatedProject.getModules().isEmpty()) {
            return Collections.singleton(aggregatedProject);
        }
        LinkedList<Path> modulePaths = new LinkedList<Path>();
        for (String module : aggregatedProject.getModules()) {
            modulePaths.add(new File(aggregatedProject.getBasedir(), module).toPath());
        }
        LinkedHashSet<MavenProject> aggregatedModules = new LinkedHashSet<MavenProject>();
        for (Path modulePath : modulePaths) {
            MavenProject module = reactorProjectsMap.remove(modulePath);
            if (module == null) continue;
            aggregatedModules.addAll(this.modulesForAggregatedProject(module, reactorProjectsMap));
        }
        return aggregatedModules;
    }
}

