/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.EcmascriptLanguage;
import net.sourceforge.pmd.cpd.JSPLanguage;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.pmd.ExcludeDuplicationsFromFile;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.plugins.pmd.exec.CpdResult;
import org.apache.maven.plugins.pmd.exec.Executor;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpdExecutor
extends Executor {
    private static final Logger LOG = LoggerFactory.getLogger(CpdExecutor.class);
    private final CpdRequest request;
    private final ExcludeDuplicationsFromFile excludeDuplicationsFromFile = new ExcludeDuplicationsFromFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpdResult execute(CpdRequest request) throws MavenReportException {
        if (request.getJavaExecutable() != null) {
            return CpdExecutor.fork(request);
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CpdExecutor.class.getClassLoader());
            CpdExecutor cpdExecutor = new CpdExecutor(request);
            CpdResult cpdResult = cpdExecutor.run();
            return cpdResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private static CpdResult fork(CpdRequest request) throws MavenReportException {
        File basePmdDir = new File(request.getTargetDirectory(), "pmd");
        basePmdDir.mkdirs();
        File cpdRequestFile = new File(basePmdDir, "cpdrequest.bin");
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cpdRequestFile));){
            out.writeObject(request);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        String classpath = CpdExecutor.buildClasspath();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().put("CLASSPATH", classpath);
        pb.command().add(request.getJavaExecutable());
        pb.command().add(CpdExecutor.class.getName());
        pb.command().add(cpdRequestFile.getAbsolutePath());
        LOG.debug("Executing: CLASSPATH={}, command={}", (Object)classpath, pb.command());
        try {
            Process p = pb.start();
            Executor.ProcessStreamHandler.start(p.getInputStream(), System.out);
            Executor.ProcessStreamHandler.start(p.getErrorStream(), System.err);
            int exit = p.waitFor();
            LOG.debug("CpdExecutor exit code: {}", (Object)exit);
            if (exit != 0) {
                throw new MavenReportException("CpdExecutor exited with exit code " + exit);
            }
            return new CpdResult(new File(request.getTargetDirectory(), "cpd.xml"), request.getOutputEncoding());
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    public static void main(String[] args) {
        File requestFile = new File(args[0]);
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(requestFile));){
            CpdRequest request = (CpdRequest)in.readObject();
            CpdExecutor cpdExecutor = new CpdExecutor(request);
            cpdExecutor.setupLogLevel(request.getLogLevel());
            cpdExecutor.run();
            System.exit(0);
        }
        catch (IOException | ClassNotFoundException | MavenReportException e) {
            LOG.error(e.getMessage(), e);
        }
        System.exit(1);
    }

    public CpdExecutor(CpdRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    private CpdResult run() throws MavenReportException {
        this.setupPmdLogging(this.request.isShowPmdLog(), this.request.getLogLevel());
        try {
            this.excludeDuplicationsFromFile.loadExcludeFromFailuresData(this.request.getExcludeFromFailureFile());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Error loading exclusions", (Exception)((Object)e));
        }
        CPDConfiguration cpdConfiguration = new CPDConfiguration();
        cpdConfiguration.setMinimumTileSize(this.request.getMinimumTokens());
        Object cpdLanguage = "java".equals(this.request.getLanguage()) || null == this.request.getLanguage() ? new JavaLanguage(this.request.getLanguageProperties()) : ("javascript".equals(this.request.getLanguage()) ? new EcmascriptLanguage() : ("jsp".equals(this.request.getLanguage()) ? new JSPLanguage() : LanguageFactory.createLanguage((String)this.request.getLanguage(), (Properties)this.request.getLanguageProperties())));
        cpdConfiguration.setLanguage((Language)cpdLanguage);
        cpdConfiguration.setSourceEncoding(this.request.getSourceEncoding());
        CPD cpd = new CPD(cpdConfiguration);
        try {
            cpd.add(this.request.getFiles());
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
        LOG.debug("Executing CPD...");
        cpd.go();
        LOG.debug("CPD finished.");
        this.writeXmlReport(cpd);
        String format = this.request.getFormat();
        if (!"html".equals(format) && !"xml".equals(format)) {
            this.writeFormattedReport(cpd);
        }
        return new CpdResult(new File(this.request.getTargetDirectory(), "cpd.xml"), this.request.getOutputEncoding());
    }

    private void writeXmlReport(CPD cpd) throws MavenReportException {
        File targetFile = this.writeReport(cpd, (CPDRenderer)new XMLRenderer(this.request.getOutputEncoding()), "xml");
        if (this.request.isIncludeXmlInSite()) {
            File siteDir = new File(this.request.getReportOutputDirectory());
            siteDir.mkdirs();
            try {
                FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "cpd.xml"));
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        }
    }

    private File writeReport(CPD cpd, CPDRenderer r, String extension) throws MavenReportException {
        if (r == null) {
            return null;
        }
        File targetDir = new File(this.request.getTargetDirectory());
        targetDir.mkdirs();
        File targetFile = new File(targetDir, "cpd." + extension);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.request.getOutputEncoding());){
            r.render(this.filterMatches(cpd.getMatches()), (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
        }
        return targetFile;
    }

    private void writeFormattedReport(CPD cpd) throws MavenReportException {
        CPDRenderer r = CpdExecutor.createRenderer(this.request.getFormat(), this.request.getOutputEncoding());
        this.writeReport(cpd, r, this.request.getFormat());
    }

    public static CPDRenderer createRenderer(String format, String outputEncoding) throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(format)) {
            renderer = new XMLRenderer(outputEncoding);
        } else if ("csv".equals(format)) {
            renderer = new CSVRenderer();
        } else if ("txt".equals(format)) {
            renderer = new SimpleRenderer();
        } else if (!"".equals(format) && !"none".equals(format)) {
            try {
                renderer = (CPDRenderer)Class.forName(format).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find CPD custom format " + format + ": " + e.getClass().getName(), e);
            }
        }
        return renderer;
    }

    private Iterator<Match> filterMatches(Iterator<Match> matches) {
        LOG.debug("Filtering duplications. Using " + this.excludeDuplicationsFromFile.countExclusions() + " configured exclusions.");
        ArrayList<Match> filteredMatches = new ArrayList<Match>();
        int excludedDuplications = 0;
        while (matches.hasNext()) {
            Match match = matches.next();
            if (this.excludeDuplicationsFromFile.isExcludedFromFailure(match)) {
                ++excludedDuplications;
                continue;
            }
            filteredMatches.add(match);
        }
        LOG.debug("Excluded " + excludedDuplications + " duplications.");
        return filteredMatches.iterator();
    }
}

