/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.mavenone;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;

public class MavenOnePluginMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private File basedir;
    private String finalName;
    private JarArchiver jarArchiver;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File contentDirectory;

    public File createArchive() throws MojoExecutionException {
        File jarFile = new File(this.basedir, this.finalName + ".jar");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        try {
            if (this.contentDirectory.exists()) {
                archiver.getArchiver().addDirectory(this.contentDirectory, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
            }
            MavenOnePluginMojo.addFile(archiver, new File("plugin.jelly"));
            MavenOnePluginMojo.addFile(archiver, new File("plugin.properties"));
            MavenOnePluginMojo.addFile(archiver, new File("project.properties"));
            MavenOnePluginMojo.addFile(archiver, new File("build.properties"));
            MavenOnePluginMojo.addFile(archiver, new File("project.xml"));
            MavenOnePluginMojo.addDirectory(archiver, new File("src/plugin-resources"));
            archiver.createArchive(this.project, new MavenArchiveConfiguration());
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    private static void addDirectory(MavenArchiver archiver, File file) throws ArchiverException {
        if (file.exists()) {
            archiver.getArchiver().addDirectory(file, file.getName() + "/", DEFAULT_INCLUDES, FileUtils.getDefaultExcludes());
        }
    }

    private static void addFile(MavenArchiver archiver, File file) throws ArchiverException {
        if (file.exists()) {
            archiver.getArchiver().addFile(file, file.getName());
        }
    }

    public void execute() throws MojoExecutionException {
        File jarFile = this.createArchive();
        this.project.getArtifact().setFile(jarFile);
    }
}

