/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jarsigner.AbstractJarsignerMojo;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class JarsignerVerifyMojo
extends AbstractJarsignerMojo {
    @Parameter(property="jarsigner.certs", defaultValue="false")
    private boolean certs;
    @Parameter(property="jarsigner.errorWhenNotSigned", defaultValue="false")
    private boolean errorWhenNotSigned;

    @Override
    protected JarSignerRequest createRequest(File archive) {
        JarSignerVerifyRequest request = new JarSignerVerifyRequest();
        request.setCerts(this.certs);
        return request;
    }

    @Override
    protected void preProcessArchive(File archive) throws MojoExecutionException {
        super.preProcessArchive(archive);
        if (this.errorWhenNotSigned) {
            boolean archiveSigned;
            try {
                archiveSigned = JarSignerUtil.isArchiveSigned((File)archive);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to check if archive " + archive + " is signed: " + e.getMessage(), (Exception)e);
            }
            if (!archiveSigned) {
                throw new MojoExecutionException(this.getMessage("archiveNotSigned", archive));
            }
        }
    }

    @Override
    protected void executeJarSigner(JarSigner jarSigner, JarSignerRequest request) throws JavaToolException, MojoExecutionException {
        JavaToolResult result = jarSigner.execute((JavaToolRequest)request);
        int resultCode = result.getExitCode();
        if (resultCode != 0) {
            throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(result.getCommandline()), resultCode));
        }
    }
}

