/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgMojo;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="sign-and-deploy-file", requiresProject=false, threadSafe=true)
public class SignAndDeployFileMojo
extends AbstractGpgMojo {
    @Parameter(property="gpg.ascDirectory")
    private File ascDirectory;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @Parameter(property="types")
    private String types;
    @Parameter(property="classifiers")
    private String classifiers;
    @Parameter(property="files")
    private String files;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ModelValidator modelValidator;
    @Component
    private MavenProject project;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;

    private void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.packaging == null && this.file != null) {
            this.packaging = FileUtils.getExtension((String)this.file.getName());
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.settings.isOffline()) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
        this.initProperties();
        this.validateArtifactInformation();
        if (!this.file.exists()) {
            throw new MojoFailureException(this.file.getPath() + " not found.");
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(this.packaging);
        Artifact main = new DefaultArtifact(this.groupId, this.artifactId, this.classifier == null || this.classifier.trim().isEmpty() ? handler.getClassifier() : this.classifier, handler.getExtension(), this.version).setFile(this.file);
        File localRepoFile = new File(this.session.getRepositorySession().getLocalRepository().getBasedir(), this.session.getRepositorySession().getLocalRepositoryManager().getPathForLocalArtifact(main));
        if (this.file.equals(localRepoFile)) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        artifacts.add(main);
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile == null && this.generatePom) {
                this.pomFile = this.generatePomFile();
            }
            if (this.pomFile != null) {
                artifacts.add(new DefaultArtifact(main.getGroupId(), main.getArtifactId(), null, "pom", main.getVersion()).setFile(this.pomFile));
            }
        }
        if (this.sources != null) {
            artifacts.add(new DefaultArtifact(main.getGroupId(), main.getArtifactId(), "sources", "jar", main.getVersion()).setFile(this.sources));
        }
        if (this.javadoc != null) {
            artifacts.add(new DefaultArtifact(main.getGroupId(), main.getArtifactId(), "javadoc", "jar", main.getVersion()).setFile(this.javadoc));
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoExecutionException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoExecutionException("You must specify 'classifiers' if you specify 'files'");
            }
            String[] files = this.files.split(",", -1);
            String[] types = this.types.split(",", -1);
            String[] classifiers = this.classifiers.split(",", -1);
            if (types.length != files.length) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'types' (respectively " + files.length + " and " + types.length + " entries )");
            }
            if (classifiers.length != files.length) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + files.length + " and " + classifiers.length + " entries )");
            }
            for (int i = 0; i < files.length; ++i) {
                File file = new File(files[i]);
                if (!file.isFile()) {
                    file = new File(this.project.getBasedir(), files[i]);
                }
                if (!file.isFile()) {
                    throw new MojoExecutionException("Specified side artifact " + file + " does not exist");
                }
                String ext = this.artifactHandlerManager.getArtifactHandler(types[i]).getExtension();
                DefaultArtifact artifact = StringUtils.isWhitespace((String)classifiers[i]) ? new DefaultArtifact(main.getGroupId(), main.getArtifactId(), null, ext, main.getVersion()) : new DefaultArtifact(main.getGroupId(), main.getArtifactId(), (String)classifiers[i], ext, main.getVersion());
                artifacts.add(artifact.setFile(file));
            }
        } else {
            if (this.types != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        AbstractGpgSigner signer = this.newSigner(null);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBaseDirectory(new File("").getAbsoluteFile());
        this.getLog().info((CharSequence)("Signer '" + signer.signerName() + "' is signing " + artifacts.size() + " file" + (artifacts.size() > 1 ? "s" : "") + " with key " + signer.getKeyInfo()));
        ArrayList<Artifact> signatures = new ArrayList<Artifact>();
        for (Artifact a : artifacts) {
            signatures.add(new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension() + ".asc", a.getVersion()).setFile(signer.generateSignatureForArtifact(a.getFile())));
        }
        artifacts.addAll(signatures);
        RemoteRepository deploymentRepository = this.repositorySystem.newDeploymentRepository(this.session.getRepositorySession(), new RemoteRepository.Builder(this.repositoryId, "default", this.url).build());
        try {
            this.deploy(deploymentRepository, artifacts);
        }
        catch (DeploymentException e) {
            throw new MojoExecutionException("Error deploying attached artifacts " + artifacts + ": " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        block10: {
            InputStream inputStream = Files.newInputStream(pomFile.toPath(), new OpenOption[0]);
            try {
                model = new MavenXpp3Reader().read(inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("POM not found " + pomFile, (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
                }
            }
            inputStream.close();
        }
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        Model model = this.generateModel();
        try {
            File tempFile = Files.createTempFile("mvndeploy", ".pom", new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            try (OutputStream outputStream = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
                new MavenXpp3Writer().write(outputStream, model);
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
        }
    }

    private void validateArtifactInformation() throws MojoFailureException {
        Model model = this.generateModel();
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setValidationLevel(30);
        ArrayList<String> result = new ArrayList<String>();
        SimpleModelProblemCollector problemCollector = new SimpleModelProblemCollector(result);
        this.modelValidator.validateEffectiveModel(model, (ModelBuildingRequest)request, (ModelProblemCollector)problemCollector);
        if (!result.isEmpty()) {
            StringBuilder msg = new StringBuilder("The artifact information is incomplete or not valid:\n");
            for (String e : result) {
                msg.append(" - " + e + '\n');
            }
            throw new MojoFailureException(msg.toString());
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    protected void deploy(RemoteRepository deploymentRepository, List<Artifact> artifacts) throws DeploymentException {
        int retryFailedDeploymentCount = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        DeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCount; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info((CharSequence)("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCount));
                }
                DeployRequest deployRequest = new DeployRequest();
                deployRequest.setRepository(deploymentRepository);
                deployRequest.setArtifacts(artifacts);
                this.repositorySystem.deploy(this.session.getRepositorySession(), deployRequest);
                exception = null;
                break;
            }
            catch (DeploymentException e) {
                if (count + 1 < retryFailedDeploymentCount) {
                    this.getLog().warn((CharSequence)("Encountered issue during deployment: " + e.getLocalizedMessage()));
                    this.getLog().debug((Throwable)e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static class SimpleModelProblemCollector
    implements ModelProblemCollector {
        private final List<String> result;

        SimpleModelProblemCollector(List<String> result) {
            this.result = result;
        }

        public void add(ModelProblemCollectorRequest req) {
            if (!ModelProblem.Severity.WARNING.equals((Object)req.getSeverity())) {
                this.result.add(req.getMessage());
            }
        }
    }
}

