/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.EclipseClasspathWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWtpComponentWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWtpFacetsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWtpmodulesWriter;
import org.apache.maven.plugin.ide.AbstractIdeSupportMojo;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class EclipsePlugin
extends AbstractIdeSupportMojo {
    private static final String NATURE_WST_FACET_CORE_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilderDependencyResolver";
    private static final String BUILDER_WST_VALIDATION = "org.eclipse.wst.validation.validationbuilder";
    private static final String BUILDER_JDT_CORE_JAVA = "org.eclipse.jdt.core.javabuilder";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilder";
    private static final String NATURE_WST_MODULE_CORE_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final String NATURE_JDT_CORE_JAVA = "org.eclipse.jdt.core.javanature";
    private static final String NATURE_JEM_WORKBENCH_JAVA_EMF = "org.eclipse.jem.workbench.JavaEMFNature";
    private static final String COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String[] WTP_SUPPORTED_VERSIONS = new String[]{"1.0", "R7", "none"};
    private static final String POM_ELT_ARTIFACT_ID = "artifactId";
    private static final String POM_ELT_GROUP_ID = "groupId";
    private List projectnatures;
    private List additionalProjectnatures;
    private List buildcommands;
    private List additionalBuildcommands;
    private List classpathContainers;
    private boolean eclipseDownloadSources;
    private File eclipseProjectDir;
    private boolean useProjectReferences;
    private File buildOutputDirectory;
    private String wtpversion;
    private boolean wtpR7;
    private boolean wtp10;
    private boolean isJavaProject;

    public List getBuildcommands() {
        return this.buildcommands;
    }

    public void setBuildcommands(List buildcommands) {
        this.buildcommands = buildcommands;
    }

    public File getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public void setBuildOutputDirectory(File buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public List getClasspathContainers() {
        return this.classpathContainers;
    }

    public void setClasspathContainers(List classpathContainers) {
        this.classpathContainers = classpathContainers;
    }

    public File getEclipseProjectDir() {
        return this.eclipseProjectDir;
    }

    public void setEclipseProjectDir(File eclipseProjectDir) {
        this.eclipseProjectDir = eclipseProjectDir;
    }

    public List getProjectnatures() {
        return this.projectnatures;
    }

    public void setProjectnatures(List projectnatures) {
        this.projectnatures = projectnatures;
    }

    public boolean getUseProjectReferences() {
        return this.useProjectReferences;
    }

    public void setUseProjectReferences(boolean useProjectReferences) {
        this.useProjectReferences = useProjectReferences;
    }

    public String getWtpversion() {
        return this.wtpversion;
    }

    public void setWtpversion(String wtpversion) {
        this.wtpversion = wtpversion;
    }

    public List getAdditionalBuildcommands() {
        return this.additionalBuildcommands;
    }

    public void setAdditionalBuildcommands(List additionalBuildcommands) {
        this.additionalBuildcommands = additionalBuildcommands;
    }

    public List getAdditionalProjectnatures() {
        return this.additionalProjectnatures;
    }

    public void setAdditionalProjectnatures(List additionalProjectnatures) {
        this.additionalProjectnatures = additionalProjectnatures;
    }

    public boolean setup() throws MojoExecutionException {
        if (this.eclipseDownloadSources) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.deprecatedpar", new Object[]{"eclipse.downloadSources", "downloadSources"}));
            this.downloadSources = true;
        }
        if (Arrays.binarySearch(WTP_SUPPORTED_VERSIONS, this.wtpversion) < 0) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.unsupportedwtp", new Object[]{this.wtpversion, StringUtils.join((Object[])WTP_SUPPORTED_VERSIONS, (String)" ")}));
        }
        if ("R7".equalsIgnoreCase(this.wtpversion)) {
            this.wtpR7 = true;
        } else if ("1.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtp10 = true;
        }
        if (!"none".equalsIgnoreCase(this.wtpversion)) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wtpversion", this.wtpversion));
        }
        String packaging = this.executedProject.getPackaging();
        this.assertNotEmpty(this.executedProject.getGroupId(), POM_ELT_GROUP_ID);
        this.assertNotEmpty(this.executedProject.getArtifactId(), POM_ELT_ARTIFACT_ID);
        if (this.executedProject.getFile() == null || !this.executedProject.getFile().exists()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingpom"));
        }
        if ("pom".equals(packaging) && this.eclipseProjectDir == null) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.pompackaging"));
            return false;
        }
        if (this.eclipseProjectDir == null) {
            this.eclipseProjectDir = this.executedProject.getFile().getParentFile();
        } else if (!this.eclipseProjectDir.equals(this.executedProject.getFile().getParentFile())) {
            if (!this.eclipseProjectDir.isDirectory()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.notadir", this.eclipseProjectDir));
            }
            this.eclipseProjectDir = new File(this.eclipseProjectDir, this.executedProject.getArtifactId());
            if (!this.eclipseProjectDir.isDirectory() && !this.eclipseProjectDir.mkdirs()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.eclipseProjectDir));
            }
        }
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        boolean bl = this.isJavaProject = "java".equals(artifactHandler.getLanguage()) && !"ear".equals(packaging);
        if (this.projectnatures == null) {
            this.fillDefaultNatures(packaging);
        }
        if (this.additionalProjectnatures != null) {
            this.projectnatures.addAll(this.additionalProjectnatures);
        }
        if (this.buildcommands == null) {
            this.fillDefaultBuilders(packaging);
        }
        if (this.additionalBuildcommands != null) {
            this.buildcommands.addAll(this.additionalBuildcommands);
        }
        if (this.classpathContainers == null) {
            this.fillDefaultClasspathContainers(packaging);
        } else if (!this.classpathContainers.contains(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER)) {
            this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.missingjrecontainer"));
            this.classpathContainers.add(0, COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
        }
        return true;
    }

    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        File projectBaseDir = this.executedProject.getFile().getParentFile();
        EclipseSourceDir[] sourceDirs = this.buildDirectoryList(this.executedProject, this.eclipseProjectDir, this.buildOutputDirectory);
        if (this.wtpR7) {
            new EclipseWtpmodulesWriter(this.getLog(), this.eclipseProjectDir, this.project, deps).write(sourceDirs, this.localRepository, this.buildOutputDirectory);
        } else if (this.wtp10) {
            new EclipseWtpFacetsWriter(this.getLog(), this.eclipseProjectDir, this.project, deps).write(sourceDirs, this.localRepository, this.buildOutputDirectory);
            new EclipseWtpComponentWriter(this.getLog(), this.eclipseProjectDir, this.project, deps).write(sourceDirs, this.localRepository, this.buildOutputDirectory);
        }
        new EclipseProjectWriter(this.getLog(), this.eclipseProjectDir, this.project, deps).write(projectBaseDir, this.executedProject, this.projectnatures, this.buildcommands);
        new EclipseSettingsWriter(this.getLog(), this.eclipseProjectDir, this.project, deps).write();
        if (this.isJavaProject) {
            new EclipseClasspathWriter(this.getLog(), this.eclipseProjectDir, this.project, deps).write(projectBaseDir, sourceDirs, this.classpathContainers, this.localRepository, this.buildOutputDirectory);
        }
        this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wrote", new Object[]{this.project.getArtifactId(), this.eclipseProjectDir.getAbsolutePath()}));
    }

    private void assertNotEmpty(String string, String elementName) throws MojoExecutionException {
        if (string == null) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingelement", elementName));
        }
    }

    private void fillDefaultNatures(String packaging) {
        this.projectnatures = new ArrayList();
        if (this.wtp10) {
            this.projectnatures.add(NATURE_WST_FACET_CORE_NATURE);
        }
        if (this.isJavaProject) {
            this.projectnatures.add(NATURE_JDT_CORE_JAVA);
        }
        if (this.wtpR7 || this.wtp10) {
            this.projectnatures.add(NATURE_WST_MODULE_CORE_NATURE);
            if (this.isJavaProject) {
                this.projectnatures.add(NATURE_JEM_WORKBENCH_JAVA_EMF);
            }
        }
    }

    private void fillDefaultClasspathContainers(String packaging) {
        this.classpathContainers = new ArrayList();
        this.classpathContainers.add(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
    }

    private void fillDefaultBuilders(String packaging) {
        this.buildcommands = new ArrayList();
        if (this.wtpR7) {
            this.buildcommands.add(BUILDER_WST_COMPONENT_STRUCTURAL);
        }
        if (this.isJavaProject) {
            this.buildcommands.add(BUILDER_JDT_CORE_JAVA);
        }
        if (this.wtpR7 || this.wtp10) {
            this.buildcommands.add(BUILDER_WST_VALIDATION);
        }
        if (this.wtpR7) {
            this.buildcommands.add(BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER);
        }
    }

    public EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, File buildOutputDirectory) throws MojoExecutionException {
        boolean useFixedOutputDir;
        File projectBaseDir = project.getFile().getParentFile();
        TreeSet directories = new TreeSet();
        EclipsePlugin.extractSourceDirs(directories, project.getCompileSourceRoots(), basedir, projectBaseDir, false, null);
        String relativeOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, buildOutputDirectory, false);
        this.extractResourceDirs(directories, project.getBuild().getResources(), project, basedir, projectBaseDir, false, relativeOutput);
        String testOutput = null;
        boolean bl = useFixedOutputDir = !buildOutputDirectory.equals(new File(project.getBuild().getOutputDirectory()));
        if (!useFixedOutputDir) {
            testOutput = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, new File(project.getBuild().getTestOutputDirectory()), false);
        }
        EclipsePlugin.extractSourceDirs(directories, project.getTestCompileSourceRoots(), basedir, projectBaseDir, true, testOutput);
        this.extractResourceDirs(directories, project.getBuild().getTestResources(), project, basedir, projectBaseDir, true, testOutput);
        return directories.toArray(new EclipseSourceDir[directories.size()]);
    }

    private static void extractSourceDirs(Set directories, List sourceRoots, File basedir, File projectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            File sourceRootFile = new File((String)it.next());
            if (!sourceRootFile.isDirectory()) continue;
            String sourceRoot = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRootFile, !projectBaseDir.equals(basedir));
            directories.add(new EclipseSourceDir(sourceRoot, output, test, null, null));
        }
    }

    private void extractResourceDirs(Set directories, List resources, MavenProject project, File basedir, File projectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            File resourceDirectory;
            Resource resource = (Resource)it.next();
            String includePattern = null;
            String excludePattern = null;
            if (resource.getIncludes().size() != 0) {
                this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.includenotsupported"));
            }
            if (resource.getExcludes().size() != 0) {
                this.getLog().warn((CharSequence)Messages.getString("EclipsePlugin.excludenotsupported"));
            }
            if (!(resourceDirectory = new File(resource.getDirectory())).exists() || !resourceDirectory.isDirectory()) continue;
            String resourceDir = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, resourceDirectory, !projectBaseDir.equals(basedir));
            if (output != null) {
                File outputFile = new File(projectBaseDir, output);
                outputFile.mkdirs();
                if (!StringUtils.isEmpty((String)resource.getTargetPath())) {
                    outputFile = new File(outputFile, resource.getTargetPath());
                    outputFile.mkdirs();
                }
                output = IdeUtils.toRelativeAndFixSeparator(projectBaseDir, outputFile, false);
            }
            directories.add(new EclipseSourceDir(resourceDir, output, test, includePattern, excludePattern));
        }
    }
}

