/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractDependencyMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractFromConfigurationMojo
extends AbstractDependencyMojo {
    private File outputDirectory;
    private boolean overWriteReleases;
    private boolean overWriteSnapshots;
    private boolean overWriteIfNewer;
    private ArrayList artifactItems;

    abstract ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem var1);

    protected ArrayList getProcessedArtifactItems(boolean removeVersion) throws MojoExecutionException {
        if (this.artifactItems == null || this.artifactItems.size() < 1) {
            throw new MojoExecutionException("There are no artifactItems configured.");
        }
        Iterator iter = ((AbstractList)this.artifactItems).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            this.getLog().info((CharSequence)("Configured Artifact: " + artifactItem.toString()));
            if (artifactItem.getOutputDirectory() == null) {
                artifactItem.setOutputDirectory(this.outputDirectory);
            }
            artifactItem.getOutputDirectory().mkdirs();
            if (StringUtils.isEmpty((String)artifactItem.getVersion())) {
                this.fillMissingArtifactVersion(artifactItem);
            }
            artifactItem.setArtifact(this.getArtifact(artifactItem));
            if (StringUtils.isEmpty((String)artifactItem.getDestFileName())) {
                artifactItem.setDestFileName(DependencyUtil.getFormattedFileName(artifactItem.getArtifact(), removeVersion));
            }
            artifactItem.setNeedsProcessing(this.checkIfProcessingNeeded(artifactItem));
        }
        return this.artifactItems;
    }

    private boolean checkIfProcessingNeeded(ArtifactItem item) throws MojoExecutionException {
        boolean result = false;
        if (StringUtils.equalsIgnoreCase((String)item.getOverWrite(), (String)"true")) {
            result = true;
        } else if (StringUtils.equalsIgnoreCase((String)item.getOverWrite(), (String)"false")) {
            result = false;
        } else {
            ArtifactItemFilter filter = this.getMarkedArtifactFilter(item);
            result = filter.okToProcess(item);
        }
        return result;
    }

    protected Artifact getArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        Artifact artifact = StringUtils.isEmpty((String)artifactItem.getClassifier()) ? this.factory.createArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getVersion(), "provided", artifactItem.getType()) : this.factory.createArtifactWithClassifier(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getVersion(), artifactItem.getType(), artifactItem.getClassifier());
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private void fillMissingArtifactVersion(ArtifactItem artifact) throws MojoExecutionException {
        if (!this.findDependencyVersion(artifact, this.project.getDependencies()) && !this.findDependencyVersion(artifact, this.project.getDependencyManagement().getDependencies())) {
            throw new MojoExecutionException("Unable to find artifact version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " in either dependency list or in project's dependency management.");
        }
    }

    private boolean findDependencyVersion(ArtifactItem artifact, List list) {
        boolean result = false;
        for (int i = 0; i < list.size(); ++i) {
            Dependency dependency = (Dependency)list.get(i);
            if (!StringUtils.equals((String)dependency.getArtifactId(), (String)artifact.getArtifactId()) || !StringUtils.equals((String)dependency.getGroupId(), (String)artifact.getGroupId()) || !StringUtils.equals((String)dependency.getClassifier(), (String)artifact.getClassifier()) || !StringUtils.equals((String)dependency.getType(), (String)artifact.getType())) continue;
            artifact.setVersion(dependency.getVersion());
            result = true;
            break;
        }
        return result;
    }

    public ArrayList getArtifactItems() {
        return this.artifactItems;
    }

    public void setArtifactItems(ArrayList theArtifactItems) {
        this.artifactItems = theArtifactItems;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File theOutputDirectory) {
        this.outputDirectory = theOutputDirectory;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean theOverWriteIfNewer) {
        this.overWriteIfNewer = theOverWriteIfNewer;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean theOverWriteReleases) {
        this.overWriteReleases = theOverWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean theOverWriteSnapshots) {
        this.overWriteSnapshots = theOverWriteSnapshots;
    }
}

