/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.api.JavaPathType;

final class WorkaroundForPatchModule
implements JavaCompiler {
    static final boolean ENABLED = true;
    private final JavaCompiler compiler;

    WorkaroundForPatchModule(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public String name() {
        return this.compiler.name();
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return this.compiler.getSourceVersions();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.compiler.isSupportedOption(option);
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return new FileManager(this.compiler.getStandardFileManager(diagnosticListener, locale, charset), locale, charset);
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        FileManager wp;
        if (fileManager instanceof FileManager && (fileManager = (wp = (FileManager)fileManager).getFileManagerIfUsable()) == null) {
            final StandardJavaFileManager workaround = this.compiler.getStandardFileManager(diagnosticListener, wp.locale, wp.charset);
            try {
                wp.copyTo(workaround);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            final JavaCompiler.CompilationTask task = this.compiler.getTask(out, workaround, diagnosticListener, options, classes, compilationUnits);
            return new JavaCompiler.CompilationTask(){
                final /* synthetic */ WorkaroundForPatchModule this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void setLocale(Locale locale) {
                    task.setLocale(locale);
                }

                @Override
                public void setProcessors(Iterable<? extends Processor> processors) {
                    task.setProcessors(processors);
                }

                @Override
                public void addModules(Iterable<String> moduleNames) {
                    task.addModules(moduleNames);
                }

                @Override
                public Boolean call() {
                    Boolean result = task.call();
                    try {
                        workaround.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return result;
                }
            };
        }
        return this.compiler.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.compiler.run(in, out, err, arguments);
    }

    private static final class FileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager>
    implements StandardJavaFileManager {
        final Locale locale;
        final Charset charset;
        private final Set<JavaFileManager.Location> definedLocations;
        private final Map<String, Collection<? extends Path>> patchesAsOption;
        private boolean needsNewFileManager;

        FileManager(StandardJavaFileManager fileManager, Locale locale, Charset charset) {
            super(fileManager);
            this.locale = locale;
            this.charset = charset;
            this.definedLocations = new LinkedHashSet<JavaFileManager.Location>();
            this.patchesAsOption = new LinkedHashMap<String, Collection<? extends Path>>();
        }

        StandardJavaFileManager getFileManagerIfUsable() {
            return this.needsNewFileManager ? null : (StandardJavaFileManager)this.fileManager;
        }

        void copyTo(StandardJavaFileManager target) throws IOException {
            for (JavaFileManager.Location location : this.definedLocations) {
                target.setLocation(location, ((StandardJavaFileManager)this.fileManager).getLocation(location));
            }
            for (Map.Entry entry : this.patchesAsOption.entrySet()) {
                Collection paths = (Collection)entry.getValue();
                String moduleName = (String)entry.getKey();
                try {
                    target.setLocationForModule(StandardLocation.PATCH_MODULE_PATH, moduleName, paths);
                }
                catch (UnsupportedOperationException e) {
                    FileManager.specifyAsOption(target, JavaPathType.patchModule((String)moduleName), paths, e);
                }
            }
        }

        private static void specifyAsOption(StandardJavaFileManager fileManager, JavaPathType.Modular type, Collection<? extends Path> paths, UnsupportedOperationException cause) throws IOException {
            String message;
            Iterator<String> it = Arrays.asList(type.option(paths)).iterator();
            if (!fileManager.handleOption(it.next(), it)) {
                message = "Failed to set the %s option for module %s";
            } else if (it.hasNext()) {
                message = "Unexpected number of arguments after the %s option for module %s";
            } else {
                return;
            }
            JavaPathType rawType = type.rawType();
            throw new IllegalArgumentException(String.format(message, rawType.option().orElse(rawType.name()), type.moduleName()), cause);
        }

        @Override
        public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
            if (location == StandardLocation.PATCH_MODULE_PATH) {
                if (this.patchesAsOption.replace(moduleName, paths) != null) {
                    this.needsNewFileManager = true;
                    return;
                }
                try {
                    ((StandardJavaFileManager)this.fileManager).setLocationForModule(location, moduleName, paths);
                }
                catch (UnsupportedOperationException e) {
                    FileManager.specifyAsOption((StandardJavaFileManager)this.fileManager, JavaPathType.patchModule((String)moduleName), paths, e);
                    this.patchesAsOption.put(moduleName, paths);
                    return;
                }
            } else {
                ((StandardJavaFileManager)this.fileManager).setLocationForModule(location, moduleName, paths);
            }
            this.definedLocations.add(((StandardJavaFileManager)this.fileManager).getLocationForModule(location, moduleName));
        }

        @Override
        public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> paths) throws IOException {
            ((StandardJavaFileManager)this.fileManager).setLocationFromPaths(location, paths);
            this.definedLocations.add(location);
        }

        @Override
        public void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
            ((StandardJavaFileManager)this.fileManager).setLocation(location, files);
            this.definedLocations.add(location);
        }

        @Override
        public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
            return ((StandardJavaFileManager)this.fileManager).getLocation(location);
        }

        @Override
        public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
            return ((StandardJavaFileManager)this.fileManager).getLocationAsPaths(location);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(names);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(files);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjects(paths);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromStrings(names);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(files);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> paths) {
            return ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromPaths(paths);
        }

        @Override
        public Path asPath(FileObject file) {
            return ((StandardJavaFileManager)this.fileManager).asPath(file);
        }
    }
}

