/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.CompilationTaskSources;
import org.apache.maven.plugin.compiler.DiagnosticLogger;
import org.apache.maven.plugin.compiler.ForkedTool;
import org.apache.maven.plugin.compiler.IncrementalBuild;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.PathFilter;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;
import org.apache.maven.plugin.compiler.SourcesForRelease;
import org.apache.maven.plugin.compiler.WorkaroundForPatchModule;

public class ToolExecutor {
    private static final Locale LOCALE = null;
    protected final Charset encoding;
    final List<SourceDirectory> sourceDirectories;
    protected final Set<Path> generatedSourceDirectories;
    private List<SourceFile> sourceFiles;
    protected final boolean hasModuleDeclaration;
    final DependencyResolverResult dependencyResolution;
    protected final Map<PathType, List<Path>> dependencies;
    protected final Path outputDirectory;
    private final EnumSet<IncrementalBuild.Aspect> incrementalBuildConfig;
    private IncrementalBuild incrementalBuild;
    private boolean isPartialBuild;
    protected final DiagnosticListener<? super JavaFileObject> listener;
    protected final Log logger;
    final List<SourcesForRelease> sourcesForDebugFile;

    protected ToolExecutor(AbstractCompilerMojo mojo, DiagnosticListener<? super JavaFileObject> listener) throws IOException {
        this.logger = mojo.logger;
        if (listener == null) {
            Path root = mojo.project.getRootDirectory();
            listener = new DiagnosticLogger(this.logger, mojo.messageBuilderFactory, LOCALE, root);
        }
        this.listener = listener;
        this.encoding = mojo.charset();
        this.incrementalBuildConfig = mojo.incrementalCompilationConfiguration();
        this.outputDirectory = Files.createDirectories(mojo.getOutputDirectory(), new FileAttribute[0]);
        this.sourceDirectories = mojo.getSourceDirectories(this.outputDirectory);
        this.dependencies = new LinkedHashMap<PathType, List<Path>>();
        this.sourcesForDebugFile = new ArrayList<SourcesForRelease>();
        if (this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.MODULES)) {
            boolean hasNoFileMatchers = mojo.hasNoFileMatchers();
            for (SourceDirectory root : this.sourceDirectories) {
                if (root.moduleName == null) {
                    throw new CompilationFailureException("The <incrementalCompilation> value can be \"modules\" only if all source directories are Java modules.");
                }
                hasNoFileMatchers &= root.includes.isEmpty() && root.excludes.isEmpty();
            }
            if (!hasNoFileMatchers) {
                throw new CompilationFailureException("Include and exclude filters cannot be specified when <incrementalCompilation> is set to \"modules\".");
            }
            this.hasModuleDeclaration = true;
            this.sourceFiles = List.of();
        } else {
            this.sourceFiles = new PathFilter(mojo).walkSourceFiles(this.sourceDirectories);
            this.hasModuleDeclaration = mojo.hasModuleDeclaration(this.sourceDirectories);
            if (this.sourceFiles.isEmpty()) {
                this.generatedSourceDirectories = Set.of();
                this.dependencyResolution = null;
                return;
            }
        }
        this.generatedSourceDirectories = mojo.addGeneratedSourceDirectory();
        this.dependencyResolution = mojo.resolveDependencies(this.hasModuleDeclaration);
        if (this.dependencyResolution != null) {
            this.dependencies.putAll(this.dependencyResolution.getDispatchedPaths());
            this.copyDependencyValues();
        }
        mojo.resolveProcessorPathEntries(this.dependencies);
    }

    private void copyDependencyValues() {
        this.dependencies.entrySet().forEach(entry -> entry.setValue(List.copyOf((Collection)entry.getValue())));
    }

    final boolean isReleaseSpecifiedForAll() {
        for (SourceDirectory source : this.sourceDirectories) {
            if (source.release != null) continue;
            return false;
        }
        return true;
    }

    public boolean applyIncrementalBuild(AbstractCompilerMojo mojo, Options configuration) throws IOException {
        boolean checkOptions;
        boolean checkDepends;
        boolean checkClasses;
        boolean checkSources = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.SOURCES);
        if (checkSources | (checkClasses = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.CLASSES)) | (checkDepends = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.DEPENDENCIES)) | (checkOptions = this.incrementalBuildConfig.contains((Object)IncrementalBuild.Aspect.OPTIONS))) {
            this.incrementalBuild = new IncrementalBuild(mojo, this.sourceFiles, checkSources, configuration, this.incrementalBuildConfig);
            String causeOfRebuild = null;
            if (checkSources) {
                causeOfRebuild = this.incrementalBuild.inputFileTreeChanges();
            }
            if (checkClasses && causeOfRebuild == null) {
                causeOfRebuild = this.incrementalBuild.markNewOrModifiedSources();
            }
            if (checkDepends && causeOfRebuild == null) {
                List<String> fileExtensions = mojo.fileExtensions;
                causeOfRebuild = this.incrementalBuild.dependencyChanges(this.dependencies.values(), fileExtensions);
            }
            if (checkOptions && causeOfRebuild == null) {
                causeOfRebuild = this.incrementalBuild.optionChanges();
            }
            if (causeOfRebuild != null) {
                if (!this.sourceFiles.isEmpty()) {
                    this.logger.info((CharSequence)causeOfRebuild);
                }
            } else {
                this.isPartialBuild = true;
                this.sourceFiles = this.incrementalBuild.getModifiedSources();
                if (IncrementalBuild.isEmptyOrIgnorable(this.sourceFiles)) {
                    this.incrementalBuildConfig.clear();
                    this.logger.info((CharSequence)"Nothing to compile - all classes are up to date.");
                    this.sourceFiles = List.of();
                    return false;
                }
                int n = this.sourceFiles.size();
                StringBuilder sb = new StringBuilder("Compiling ").append(n).append(" modified source file");
                if (n > 1) {
                    sb.append('s');
                }
                this.logger.info((CharSequence)sb.append('.'));
            }
            if (!(checkSources | checkDepends | checkOptions)) {
                this.incrementalBuild.deleteCache();
                this.incrementalBuild = null;
            }
        }
        this.incrementalBuildConfig.clear();
        return true;
    }

    protected List<Path> dependencies(PathType pathType) {
        return this.dependencies.compute(pathType, (key, paths) -> {
            if (paths == null) {
                return new ArrayList();
            }
            if (paths instanceof ArrayList) {
                return paths;
            }
            ArrayList copy = new ArrayList(paths.size() + 4);
            copy.addAll(paths);
            return copy;
        });
    }

    private void setDependencyPaths(StandardJavaFileManager fileManager) throws IOException {
        ArrayList<Path> unresolvedPaths = new ArrayList<Path>();
        for (Map.Entry<PathType, List<Path>> entry : this.dependencies.entrySet()) {
            JavaPathType.Modular type;
            Optional location;
            List<Path> paths = entry.getValue();
            PathType key = entry.getKey();
            if (key instanceof JavaPathType) {
                JavaPathType type2 = (JavaPathType)key;
                location = type2.location();
                if (location.isPresent()) {
                    JavaFileManager.Location value = (JavaFileManager.Location)location.get();
                    if (value == StandardLocation.CLASS_PATH && this.isPartialBuild && !this.hasModuleDeclaration) {
                        paths = new ArrayList<Path>(paths);
                        paths.add(this.outputDirectory);
                        entry.setValue(paths);
                    }
                    fileManager.setLocationFromPaths(value, paths);
                    continue;
                }
            } else if (key instanceof JavaPathType.Modular && (location = (type = (JavaPathType.Modular)key).rawType().location()).isPresent()) {
                fileManager.setLocationForModule((JavaFileManager.Location)location.get(), type.moduleName(), paths);
                continue;
            }
            unresolvedPaths.addAll(paths);
        }
        if (!unresolvedPaths.isEmpty()) {
            StringBuilder sb = new StringBuilder("Cannot determine where to place the following artifacts:");
            for (Path p : unresolvedPaths) {
                sb.append(System.lineSeparator()).append(" - ").append(p);
            }
            this.logger.warn((CharSequence)sb);
        }
    }

    protected List<Path> prependDependency(PathType pathType, Path first) {
        List<Path> paths = this.dependencies(pathType);
        paths.add(0, first);
        return paths;
    }

    private static SourceVersion nonNullOrLatest(SourceVersion release) {
        return release != null ? release : SourceVersion.latest();
    }

    String inferModuleNameIfMissing(String moduleName) throws IOException {
        return moduleName;
    }

    private Collection<SourcesForRelease> groupByReleaseAndModule() {
        EnumMap<SourceVersion, SourcesForRelease> result = new EnumMap<SourceVersion, SourcesForRelease>(SourceVersion.class);
        for (SourceDirectory directory : this.sourceDirectories) {
            SourcesForRelease unit = result.computeIfAbsent(ToolExecutor.nonNullOrLatest(directory.release), release -> new SourcesForRelease(directory.release));
            String moduleName = directory.moduleName;
            if (moduleName == null || moduleName.isBlank()) {
                moduleName = "";
            }
            unit.roots.computeIfAbsent(moduleName, key -> new LinkedHashSet());
        }
        for (SourceFile source : this.sourceFiles) {
            ((SourcesForRelease)result.get((Object)ToolExecutor.nonNullOrLatest(source.directory.release))).add(source);
        }
        return result.values();
    }

    private StandardJavaFileManager createFileManager(JavaCompiler compiler, boolean workaround) {
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(this.listener, LOCALE, this.encoding);
        if (workaround && !(compiler instanceof ForkedTool)) {
            fileManager = new WorkaroundForPatchModule(fileManager);
        }
        return fileManager;
    }

    public boolean compile(JavaCompiler compiler, Options configuration, Writer otherOutput) throws IOException {
        this.sourcesForDebugFile.clear();
        if (this.sourceFiles.isEmpty()) {
            Object message = "No sources to compile.";
            try {
                Files.delete(this.outputDirectory);
            }
            catch (DirectoryNotEmptyException e) {
                message = (String)message + " However, the output directory is not empty.";
            }
            this.logger.info((CharSequence)message);
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            int n = this.sourceFiles.size();
            StringBuilder sb = new StringBuilder(n * 40).append("The source files to compile are:");
            for (SourceFile file : this.sourceFiles) {
                sb.append(System.lineSeparator()).append("    ").append(file);
            }
            this.logger.debug((CharSequence)sb);
        }
        boolean success = true;
        try (StandardJavaFileManager fileManager = this.createFileManager(compiler, this.hasModuleDeclaration);){
            DiagnosticListener<? super JavaFileObject> diagnosticListener;
            this.setDependencyPaths(fileManager);
            if (!this.generatedSourceDirectories.isEmpty()) {
                fileManager.setLocationFromPaths(StandardLocation.SOURCE_OUTPUT, this.generatedSourceDirectories);
            }
            boolean isVersioned = false;
            Path latestOutputDirectory = null;
            block10: for (SourcesForRelease unit : this.groupByReleaseAndModule()) {
                Set<Path> paths;
                Path outputForRelease = null;
                boolean isClasspathProject = false;
                boolean isModularProject = false;
                String defaultModuleName = null;
                configuration.setRelease(unit.getReleaseString());
                for (Map.Entry<String, Set<Path>> root : unit.roots.entrySet()) {
                    String declaredModuleName = root.getKey();
                    String moduleName = this.inferModuleNameIfMissing(declaredModuleName);
                    if (moduleName.isEmpty()) {
                        isClasspathProject = true;
                    } else {
                        isModularProject = true;
                        if (declaredModuleName.isEmpty()) {
                            defaultModuleName = moduleName;
                        }
                    }
                    if (isClasspathProject & isModularProject) {
                        throw new CompilationFailureException("Mix of modular and non-modular sources.");
                    }
                    Set<Path> sourcePaths = root.getValue();
                    if (isClasspathProject) {
                        fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, sourcePaths);
                    } else {
                        fileManager.setLocationForModule(StandardLocation.MODULE_SOURCE_PATH, moduleName, sourcePaths);
                    }
                    outputForRelease = this.outputDirectory;
                    if (!isVersioned) continue;
                    outputForRelease = Files.createDirectories(SourceDirectory.outputDirectoryForReleases(outputForRelease, unit.release), new FileAttribute[0]);
                    if (isClasspathProject) {
                        List<Path> classpath = this.prependDependency((PathType)JavaPathType.CLASSES, latestOutputDirectory);
                        fileManager.setLocationFromPaths(StandardLocation.CLASS_PATH, classpath);
                        continue;
                    }
                    Path latestOutputForModule = latestOutputDirectory.resolve(moduleName);
                    JavaPathType.Modular pathType = JavaPathType.patchModule((String)moduleName);
                    List<Path> paths2 = this.prependDependency((PathType)pathType, latestOutputForModule);
                    fileManager.setLocationForModule(StandardLocation.PATCH_MODULE_PATH, moduleName, paths2);
                }
                if (defaultModuleName != null && (paths = unit.roots.remove("")) != null) {
                    unit.roots.put(defaultModuleName, paths);
                }
                this.copyDependencyValues();
                unit.dependencySnapshot = new LinkedHashMap<PathType, List<Path>>(this.dependencies);
                fileManager.setLocationFromPaths(StandardLocation.CLASS_OUTPUT, Set.of(outputForRelease));
                latestOutputDirectory = outputForRelease;
                unit.outputForRelease = outputForRelease;
                for (CompilationTaskSources c : this.toCompilationTasks(unit)) {
                    WorkaroundForPatchModule wp;
                    Iterable<? extends JavaFileObject> sources = fileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)c.files);
                    StandardJavaFileManager workaround = fileManager;
                    boolean workaroundNeedsClose = false;
                    if (workaround instanceof WorkaroundForPatchModule && (workaround = (wp = (WorkaroundForPatchModule)workaround).getFileManagerIfUsable()) == null) {
                        workaround = this.createFileManager(compiler, false);
                        wp.copyTo(workaround);
                        workaroundNeedsClose = true;
                    }
                    JavaCompiler.CompilationTask task = compiler.getTask(otherOutput, workaround, this.listener, configuration.options, null, sources);
                    success = c.compile(task);
                    if (workaroundNeedsClose) {
                        workaround.close();
                    }
                    this.sourcesForDebugFile.add(unit);
                    if (!success) break block10;
                }
                isVersioned = true;
            }
            if ((diagnosticListener = this.listener) instanceof DiagnosticLogger) {
                DiagnosticLogger diagnostic = (DiagnosticLogger)diagnosticListener;
                diagnostic.logSummary();
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        if (success && this.incrementalBuild != null) {
            this.incrementalBuild.writeCache();
            this.incrementalBuild = null;
        }
        return success;
    }

    CompilationTaskSources[] toCompilationTasks(SourcesForRelease unit) {
        if (unit.files.isEmpty()) {
            return new CompilationTaskSources[0];
        }
        return new CompilationTaskSources[]{new CompilationTaskSources(unit.files)};
    }
}

