/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.clean;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.clean.Selector;
import org.codehaus.plexus.util.Os;
import org.eclipse.aether.SessionData;

class Cleaner {
    private static final boolean ON_WINDOWS = Os.isFamily((String)"windows");
    private static final String LAST_DIRECTORY_TO_DELETE = Cleaner.class.getName() + ".lastDirectoryToDelete";
    private final MavenSession session;
    private final Path fastDir;
    private final String fastMode;
    private final boolean verbose;
    private Log log;

    Cleaner(MavenSession session, Log log, boolean verbose, Path fastDir, String fastMode) {
        this.session = session;
        this.log = log;
        this.fastDir = fastDir;
        this.fastMode = fastMode;
        this.verbose = verbose;
    }

    public void delete(Path basedir, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        Path file;
        if (!Files.isDirectory(basedir, new LinkOption[0])) {
            if (!Files.exists(basedir, new LinkOption[0])) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Skipping non-existing directory " + basedir));
                }
                return;
            }
            throw new IOException("Invalid base directory " + basedir);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Deleting " + basedir + (selector != null ? " (" + selector + ")" : "")));
        }
        Path path = file = followSymlinks ? basedir : basedir.toRealPath(new LinkOption[0]);
        if (selector == null && !followSymlinks && this.fastDir != null && this.session != null && this.fastDelete(file)) {
            return;
        }
        this.delete(file, "", selector, followSymlinks, failOnError, retryOnError);
    }

    private boolean fastDelete(Path baseDir) {
        if (this.fastDir.toAbsolutePath().startsWith(baseDir.toAbsolutePath())) {
            try {
                String prefix = baseDir.getFileName().toString() + ".";
                Path tmpDir = Files.createTempDirectory(baseDir.getParent(), prefix, new FileAttribute[0]);
                try {
                    Files.move(baseDir, tmpDir, StandardCopyOption.REPLACE_EXISTING);
                    if (this.session != null) {
                        this.session.getRepositorySession().getData().set((Object)LAST_DIRECTORY_TO_DELETE, (Object)baseDir);
                    }
                    baseDir = tmpDir;
                }
                catch (IOException e) {
                    Files.delete(tmpDir);
                    throw e;
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)"Unable to fast delete directory: ", (Throwable)e);
                }
                return false;
            }
        }
        try {
            if (!Files.isDirectory(this.fastDir, new LinkOption[0])) {
                Files.createDirectories(this.fastDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Unable to fast delete directory as the path " + this.fastDir + " does not point to a directory or cannot be created: "), (Throwable)e);
            }
            return false;
        }
        try {
            Path tmpDir = Files.createTempDirectory(this.fastDir, "", new FileAttribute[0]);
            Path dstDir = tmpDir.resolve(baseDir.getFileName());
            Files.move(baseDir, dstDir, StandardCopyOption.ATOMIC_MOVE);
            BackgroundCleaner.delete(this, tmpDir, this.fastMode);
            return true;
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Unable to fast delete directory: ", (Throwable)e);
            }
            return false;
        }
    }

    private Result delete(Path file, String pathname, Selector selector, boolean followSymlinks, boolean failOnError, boolean retryOnError) throws IOException {
        Result result = new Result();
        boolean isDirectory = Files.isDirectory(file, new LinkOption[0]);
        if (isDirectory) {
            if (selector == null || selector.couldHoldSelected(pathname)) {
                if (followSymlinks || !this.isSymbolicLink(file)) {
                    Path canonical = followSymlinks ? file : file.toRealPath(new LinkOption[0]);
                    String prefix = pathname.length() > 0 ? pathname + File.separatorChar : "";
                    try (DirectoryStream<Path> children = Files.newDirectoryStream(canonical);){
                        for (Path child : children) {
                            String filename = child.getFileName().toString();
                            result.update(this.delete(child, prefix + filename, selector, followSymlinks, failOnError, retryOnError));
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Not recursing into symlink " + file));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Not recursing into directory without included files " + file));
            }
        }
        if (!result.excluded && (selector == null || selector.isSelected(pathname))) {
            String logmessage = isDirectory ? "Deleting directory " + file : (Files.exists(file, new LinkOption[0]) ? "Deleting file " + file : "Deleting dangling symlink " + file);
            if (this.verbose && this.log.isInfoEnabled()) {
                this.log.info((CharSequence)logmessage);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)logmessage);
            }
            result.failures += this.delete(file, failOnError, retryOnError);
        } else {
            result.excluded = true;
        }
        return result;
    }

    private boolean isSymbolicLink(Path path) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        return attrs.isSymbolicLink() || attrs.isDirectory() && attrs.isOther();
    }

    private int delete(Path file, boolean failOnError, boolean retryOnError) throws IOException {
        IOException failure = Cleaner.delete(file);
        if (failure != null) {
            boolean deleted = false;
            if (retryOnError) {
                if (ON_WINDOWS) {
                    System.gc();
                }
                int[] delays = new int[]{50, 250, 750};
                for (int i = 0; !deleted && i < delays.length; ++i) {
                    try {
                        Thread.sleep(delays[i]);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    deleted = Cleaner.delete(file) == null || !Files.exists(file, new LinkOption[0]);
                }
            } else {
                boolean bl = deleted = !Files.exists(file, new LinkOption[0]);
            }
            if (!deleted) {
                if (failOnError) {
                    throw new IOException("Failed to delete " + file, failure);
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((CharSequence)("Failed to delete " + file), (Throwable)failure);
                }
                return 1;
            }
        }
        return 0;
    }

    private static IOException delete(Path file) {
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    private static class Result {
        private int failures;
        private boolean excluded;

        private Result() {
        }

        public void update(Result result) {
            this.failures += result.failures;
            this.excluded |= result.excluded;
        }
    }

    private static class BackgroundCleaner
    extends Thread {
        private static final int NEW = 0;
        private static final int RUNNING = 1;
        private static final int STOPPED = 2;
        private static BackgroundCleaner instance;
        private final Deque<Path> filesToDelete = new ArrayDeque<Path>();
        private final Cleaner cleaner;
        private final String fastMode;
        private int status = 0;

        private BackgroundCleaner(Cleaner cleaner, Path dir, String fastMode) throws IOException {
            super("mvn-background-cleaner");
            this.cleaner = cleaner;
            this.fastMode = fastMode;
            this.init(cleaner.fastDir, dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void delete(Cleaner cleaner, Path dir, String fastMode) throws IOException {
            Class<BackgroundCleaner> clazz = BackgroundCleaner.class;
            synchronized (BackgroundCleaner.class) {
                if (instance == null || !instance.doDelete(dir)) {
                    instance = new BackgroundCleaner(cleaner, dir, fastMode);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void sessionEnd() {
            Class<BackgroundCleaner> clazz = BackgroundCleaner.class;
            synchronized (BackgroundCleaner.class) {
                if (instance != null) {
                    instance.doSessionEnd();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void run() {
            Path basedir;
            while ((basedir = this.pollNext()) != null) {
                try {
                    this.cleaner.delete(basedir, "", null, false, false, true);
                }
                catch (IOException iOException) {}
            }
        }

        synchronized void init(Path fastDir, Path dir) throws IOException {
            if (Files.isDirectory(fastDir, new LinkOption[0])) {
                try (DirectoryStream<Path> children = Files.newDirectoryStream(fastDir);){
                    for (Path child : children) {
                        this.doDelete(child);
                    }
                }
            }
            this.doDelete(dir);
        }

        synchronized Path pollNext() {
            Path basedir = this.filesToDelete.poll();
            if (basedir == null) {
                SessionData data;
                Path lastDir;
                if (this.cleaner.session != null && (lastDir = (Path)(data = this.cleaner.session.getRepositorySession().getData()).get((Object)LAST_DIRECTORY_TO_DELETE)) != null) {
                    data.set((Object)LAST_DIRECTORY_TO_DELETE, null);
                    return lastDir;
                }
                this.status = 2;
                this.notifyAll();
            }
            return basedir;
        }

        synchronized boolean doDelete(Path dir) {
            if (this.status == 2) {
                return false;
            }
            this.filesToDelete.add(dir);
            if (this.status == 0 && "background".equals(this.fastMode)) {
                this.status = 1;
                this.notifyAll();
                this.start();
            }
            this.wrapExecutionListener();
            return true;
        }

        private void wrapExecutionListener() {
            ExecutionListener executionListener = this.cleaner.session.getRequest().getExecutionListener();
            if (executionListener == null || !Proxy.isProxyClass(executionListener.getClass()) || !(Proxy.getInvocationHandler(executionListener) instanceof SpyInvocationHandler)) {
                ExecutionListener listener = (ExecutionListener)Proxy.newProxyInstance(ExecutionListener.class.getClassLoader(), new Class[]{ExecutionListener.class}, (InvocationHandler)new SpyInvocationHandler(executionListener));
                this.cleaner.session.getRequest().setExecutionListener(listener);
            }
        }

        synchronized void doSessionEnd() {
            if (this.status != 2) {
                if (this.status == 0) {
                    this.start();
                }
                if (!"defer".equals(this.fastMode)) {
                    try {
                        if (this.cleaner.log.isInfoEnabled()) {
                            this.cleaner.log.info((CharSequence)"Waiting for background file deletion");
                        }
                        while (this.status != 2) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static class SpyInvocationHandler
    implements InvocationHandler {
        private final ExecutionListener delegate;

        SpyInvocationHandler(ExecutionListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("sessionEnded".equals(method.getName())) {
                BackgroundCleaner.sessionEnd();
            }
            if (this.delegate != null) {
                return method.invoke((Object)this.delegate, args);
            }
            return null;
        }
    }
}

