/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle.exec;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleCheckerListener;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutor;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorException;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleExecutorRequest;
import org.apache.maven.plugins.checkstyle.exec.CheckstyleResults;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Component(role=CheckstyleExecutor.class, hint="default", instantiationStrategy="per-lookup")
public class DefaultCheckstyleExecutor
extends AbstractLogEnabled
implements CheckstyleExecutor {
    @Requirement(hint="default")
    private ResourceManager locator;
    @Requirement(hint="license")
    private ResourceManager licenseLocator;

    @Override
    public CheckstyleResults executeCheckstyle(CheckstyleExecutorRequest request) throws CheckstyleExecutorException, CheckstyleException {
        CharSequence message;
        List<File> files;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executeCheckstyle start headerLocation : " + request.getHeaderLocation());
        }
        MavenProject project = request.getProject();
        this.configureResourceLocator(this.locator, request, null);
        this.configureResourceLocator(this.licenseLocator, request, request.getLicenseArtifacts());
        try {
            files = this.getFilesToProcess(request);
        }
        catch (IOException e) {
            throw new CheckstyleExecutorException("Error getting files to process", e);
        }
        String suppressionsFilePath = this.getSuppressionsFilePath(request);
        FilterSet filterSet = this.getSuppressionsFilterSet(suppressionsFilePath);
        Checker checker = new Checker();
        ArrayList<String> classPathStrings = new ArrayList<String>();
        ArrayList<String> outputDirectories = new ArrayList<String>();
        Collection sourceDirectories = null;
        Collection testSourceDirectories = request.getTestSourceDirectories();
        HashMap<MavenProject, Collection> sourceDirectoriesByProject = new HashMap<MavenProject, Collection>();
        HashMap<MavenProject, Collection> testSourceDirectoriesByProject = new HashMap<MavenProject, Collection>();
        if (request.isAggregate()) {
            for (MavenProject childProject : request.getReactorProjects()) {
                Object compileSourceRoot2;
                sourceDirectories = new ArrayList<File>(childProject.getCompileSourceRoots().size());
                List compileSourceRoots = childProject.getCompileSourceRoots();
                for (Object compileSourceRoot2 : compileSourceRoots) {
                    sourceDirectories.add((File)new File((String)compileSourceRoot2));
                }
                sourceDirectoriesByProject.put(childProject, sourceDirectories);
                testSourceDirectories = new ArrayList<File>(childProject.getTestCompileSourceRoots().size());
                List testCompileSourceRoots = childProject.getTestCompileSourceRoots();
                compileSourceRoot2 = testCompileSourceRoots.iterator();
                while (compileSourceRoot2.hasNext()) {
                    String testCompileSourceRoot = (String)compileSourceRoot2.next();
                    testSourceDirectories.add((File)new File(testCompileSourceRoot));
                }
                testSourceDirectoriesByProject.put(childProject, testSourceDirectories);
                this.prepareCheckstylePaths(request, childProject, classPathStrings, outputDirectories, sourceDirectories, testSourceDirectories);
            }
        } else {
            sourceDirectories = request.getSourceDirectories();
            this.prepareCheckstylePaths(request, project, classPathStrings, outputDirectories, sourceDirectories, testSourceDirectories);
        }
        checker.setModuleClassLoader(Thread.currentThread().getContextClassLoader());
        if (filterSet != null) {
            checker.addFilter((Filter)filterSet);
        }
        Configuration configuration = this.getConfiguration(request);
        checker.configure(configuration);
        AuditListener listener = request.getListener();
        if (listener != null) {
            checker.addListener(listener);
        }
        if (request.isConsoleOutput()) {
            checker.addListener((AuditListener)request.getConsoleListener());
        }
        CheckstyleCheckerListener checkerListener = new CheckstyleCheckerListener(configuration);
        if (request.isAggregate()) {
            for (MavenProject childProject : request.getReactorProjects()) {
                sourceDirectories = (Collection)sourceDirectoriesByProject.get(childProject);
                testSourceDirectories = (Collection)testSourceDirectoriesByProject.get(childProject);
                this.addSourceDirectory(checkerListener, sourceDirectories, testSourceDirectories, childProject.getResources(), request);
            }
        } else {
            this.addSourceDirectory(checkerListener, sourceDirectories, testSourceDirectories, request.getResources(), request);
        }
        checker.addListener((AuditListener)checkerListener);
        int nbErrors = checker.process(files);
        checker.destroy();
        if (request.getStringOutputStream() != null && ((String)(message = request.getStringOutputStream().toString().trim())).length() > 0) {
            this.getLogger().info((String)message);
        }
        if (nbErrors > 0) {
            message = new StringBuilder("There ");
            if (nbErrors == 1) {
                ((StringBuilder)message).append("is");
            } else {
                ((StringBuilder)message).append("are");
            }
            ((StringBuilder)message).append(" ");
            ((StringBuilder)message).append(nbErrors);
            ((StringBuilder)message).append(" error");
            if (nbErrors != 1) {
                ((StringBuilder)message).append("s");
            }
            ((StringBuilder)message).append(" reported by Checkstyle");
            String version = this.getCheckstyleVersion();
            if (version != null) {
                ((StringBuilder)message).append(" ");
                ((StringBuilder)message).append(version);
            }
            ((StringBuilder)message).append(" with ");
            ((StringBuilder)message).append(request.getConfigLocation());
            ((StringBuilder)message).append(" ruleset.");
            if (request.isFailsOnError()) {
                throw new CheckstyleExecutorException(((StringBuilder)message).toString());
            }
            this.getLogger().info(((StringBuilder)message).toString());
        }
        return checkerListener.getResults();
    }

    protected void addSourceDirectory(CheckstyleCheckerListener sinkListener, Collection<File> sourceDirectories, Collection<File> testSourceDirectories, List<Resource> resources, CheckstyleExecutorRequest request) {
        if (sourceDirectories != null) {
            for (File sourceDirectory : sourceDirectories) {
                if (!sourceDirectory.exists()) continue;
                sinkListener.addSourceDirectory(sourceDirectory);
            }
        }
        if (request.isIncludeTestSourceDirectory() && testSourceDirectories != null) {
            for (File testSourceDirectory : testSourceDirectories) {
                if (!testSourceDirectory.isDirectory()) continue;
                sinkListener.addSourceDirectory(testSourceDirectory);
            }
        }
        if (resources != null) {
            for (Resource resource : resources) {
                File resourcesDirectory;
                if (resource.getDirectory() == null || !(resourcesDirectory = new File(resource.getDirectory())).exists() || !resourcesDirectory.isDirectory()) continue;
                sinkListener.addSourceDirectory(resourcesDirectory);
                this.getLogger().debug("Added '" + resourcesDirectory.getAbsolutePath() + "' as a source directory.");
            }
        }
    }

    @Override
    public Configuration getConfiguration(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            String effectiveEncoding;
            ClassLoader checkstyleClassLoader = PackageNamesLoader.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(checkstyleClassLoader);
            String configFile = this.getConfigFile(request);
            Properties overridingProperties = this.getOverridingProperties(request);
            ConfigurationLoader.IgnoredModulesOptions omitIgnoredModules = request.isOmitIgnoredModules() ? ConfigurationLoader.IgnoredModulesOptions.OMIT : ConfigurationLoader.IgnoredModulesOptions.EXECUTE;
            Configuration config = ConfigurationLoader.loadConfiguration((String)configFile, (PropertyResolver)new PropertiesExpander(overridingProperties), (ConfigurationLoader.IgnoredModulesOptions)omitIgnoredModules);
            String string = effectiveEncoding = StringUtils.isNotEmpty((String)request.getEncoding()) ? request.getEncoding() : System.getProperty("file.encoding", "UTF-8");
            if (StringUtils.isEmpty((String)request.getEncoding())) {
                this.getLogger().warn("File encoding has not been set, using platform encoding " + effectiveEncoding + ", i.e. build is platform dependent!");
            }
            if ("Checker".equals(config.getName()) || "com.puppycrawl.tools.checkstyle.Checker".equals(config.getName())) {
                if (config instanceof DefaultConfiguration) {
                    this.addAttributeIfNotExists((DefaultConfiguration)config, "charset", effectiveEncoding);
                    this.addAttributeIfNotExists((DefaultConfiguration)config, "cacheFile", request.getCacheFile());
                } else {
                    this.getLogger().warn("Failed to configure file encoding on module " + config);
                }
            }
            return config;
        }
        catch (CheckstyleException e) {
            throw new CheckstyleExecutorException("Failed during checkstyle configuration", e);
        }
    }

    private void addAttributeIfNotExists(DefaultConfiguration config, String name, String value) {
        try {
            if (config.getAttribute(name) == null) {
                config.addAttribute(name, value);
            }
        }
        catch (CheckstyleException ex) {
            config.addAttribute(name, value);
        }
    }

    private void prepareCheckstylePaths(CheckstyleExecutorRequest request, MavenProject project, List<String> classPathStrings, List<String> outputDirectories, Collection<File> sourceDirectories, Collection<File> testSourceDirectories) throws CheckstyleExecutorException {
        try {
            outputDirectories.add(project.getBuild().getOutputDirectory());
            if (request.isIncludeTestSourceDirectory() && testSourceDirectories != null && this.anyDirectoryExists(testSourceDirectories)) {
                classPathStrings.addAll(project.getTestClasspathElements());
                outputDirectories.add(project.getBuild().getTestOutputDirectory());
            } else {
                classPathStrings.addAll(project.getCompileClasspathElements());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new CheckstyleExecutorException(e.getMessage(), e);
        }
    }

    private boolean anyDirectoryExists(Collection<File> files) {
        for (File file : files) {
            if (!file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private String getCheckstyleVersion() {
        Package checkstyleApiPackage = Configuration.class.getPackage();
        return checkstyleApiPackage == null ? null : checkstyleApiPackage.getImplementationVersion();
    }

    private Properties getOverridingProperties(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        String suppressionsFilePath;
        Properties p = new Properties();
        try {
            if (request.getPropertiesLocation() != null) {
                File propertiesFile;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("request.getPropertiesLocation() " + request.getPropertiesLocation());
                }
                if ((propertiesFile = this.locator.getResourceAsFile(request.getPropertiesLocation(), "checkstyle-checker.properties")) != null) {
                    try (FileInputStream in = new FileInputStream(propertiesFile);){
                        p.load(in);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)request.getPropertyExpansion())) {
                String propertyExpansion = request.getPropertyExpansion();
                propertyExpansion = StringUtils.replace((String)propertyExpansion, (String)"\\", (String)"\\\\");
                p.load(new ByteArrayInputStream(propertyExpansion.getBytes()));
            }
            String headerLocation = request.getHeaderLocation();
            if ("config/maven_checks.xml".equals(request.getConfigLocation()) && "LICENSE.txt".equals(request.getHeaderLocation())) {
                headerLocation = "config/maven-header.txt";
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("headerLocation " + headerLocation);
            }
            if (StringUtils.isNotEmpty((String)headerLocation)) {
                try {
                    File headerFile = this.licenseLocator.getResourceAsFile(headerLocation, "checkstyle-header.txt");
                    if (headerFile != null) {
                        p.setProperty("checkstyle.header.file", headerFile.getAbsolutePath());
                    }
                }
                catch (FileResourceCreationException | ResourceNotFoundException e) {
                    this.getLogger().debug("Unable to process header location: " + headerLocation);
                    this.getLogger().debug("Checkstyle will throw exception if ${checkstyle.header.file} is used");
                }
            }
            if (request.getCacheFile() != null) {
                p.setProperty("checkstyle.cache.file", request.getCacheFile());
            }
        }
        catch (IOException | FileResourceCreationException | ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Failed to get overriding properties", e);
        }
        if (request.getSuppressionsFileExpression() != null && (suppressionsFilePath = this.getSuppressionsFilePath(request)) != null) {
            p.setProperty(request.getSuppressionsFileExpression(), suppressionsFilePath);
        }
        return p;
    }

    private List<File> getFilesToProcess(CheckstyleExecutorRequest request) throws IOException {
        String[] defaultExcludes;
        StringBuilder excludesStr = new StringBuilder();
        if (StringUtils.isNotEmpty((String)request.getExcludes())) {
            excludesStr.append(request.getExcludes());
        }
        for (String defaultExclude : defaultExcludes = FileUtils.getDefaultExcludes()) {
            if (excludesStr.length() > 0) {
                excludesStr.append(",");
            }
            excludesStr.append(defaultExclude);
        }
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (request.isAggregate()) {
            for (MavenProject project : request.getReactorProjects()) {
                LinkedHashSet<File> sourceDirectories = new LinkedHashSet<File>();
                List compileSourceRoots = project.getCompileSourceRoots();
                for (String compileSourceRoot : compileSourceRoots) {
                    sourceDirectories.add(new File(compileSourceRoot));
                }
                LinkedHashSet<File> testSourceDirectories = new LinkedHashSet<File>();
                List testCompileSourceRoots = project.getTestCompileSourceRoots();
                for (String testCompileSourceRoot : testCompileSourceRoots) {
                    testSourceDirectories.add(new File(testCompileSourceRoot));
                }
                this.addFilesToProcess(request, sourceDirectories, project.getResources(), project.getTestResources(), files, testSourceDirectories);
            }
        } else {
            Collection<File> sourceDirectories = request.getSourceDirectories();
            this.addFilesToProcess(request, sourceDirectories, request.getResources(), request.getTestResources(), files, request.getTestSourceDirectories());
        }
        this.getLogger().debug("Added " + files.size() + " files to process.");
        return new ArrayList<File>(files);
    }

    private void addFilesToProcess(CheckstyleExecutorRequest request, Collection<File> sourceDirectories, List<Resource> resources, List<Resource> testResources, Collection<File> files, Collection<File> testSourceDirectories) throws IOException {
        if (sourceDirectories != null) {
            for (File sourceDirectory : sourceDirectories) {
                if (!sourceDirectory.isDirectory()) continue;
                List sourceFiles = FileUtils.getFiles((File)sourceDirectory, (String)request.getIncludes(), (String)request.getExcludes());
                files.addAll(sourceFiles);
                this.getLogger().debug("Added " + sourceFiles.size() + " source files found in '" + sourceDirectory.getAbsolutePath() + "'.");
            }
        }
        if (request.isIncludeTestSourceDirectory() && testSourceDirectories != null) {
            for (File testSourceDirectory : testSourceDirectories) {
                if (!testSourceDirectory.isDirectory()) continue;
                List testSourceFiles = FileUtils.getFiles((File)testSourceDirectory, (String)request.getIncludes(), (String)request.getExcludes());
                files.addAll(testSourceFiles);
                this.getLogger().debug("Added " + testSourceFiles.size() + " test source files found in '" + testSourceDirectory.getAbsolutePath() + "'.");
            }
        }
        if (resources != null && request.isIncludeResources()) {
            this.addResourceFilesToProcess(request, resources, files);
        } else {
            this.getLogger().debug("No resources found in this project.");
        }
        if (testResources != null && request.isIncludeTestResources()) {
            this.addResourceFilesToProcess(request, testResources, files);
        } else {
            this.getLogger().debug("No test resources found in this project.");
        }
    }

    private void addResourceFilesToProcess(CheckstyleExecutorRequest request, List<Resource> resources, Collection<File> files) throws IOException {
        for (Resource resource : resources) {
            if (resource.getDirectory() == null) continue;
            File resourcesDirectory = new File(resource.getDirectory());
            if (resourcesDirectory.isDirectory()) {
                String includes = request.getResourceIncludes();
                String excludes = request.getResourceExcludes();
                if (resourcesDirectory.equals(request.getProject().getBasedir())) {
                    String resourceIncludes = StringUtils.join(resource.getIncludes().iterator(), (String)",");
                    includes = StringUtils.isEmpty((String)includes) ? resourceIncludes : includes + "," + resourceIncludes;
                    String resourceExcludes = StringUtils.join(resource.getExcludes().iterator(), (String)",");
                    excludes = StringUtils.isEmpty((String)excludes) ? resourceExcludes : excludes + "," + resourceExcludes;
                }
                List resourceFiles = FileUtils.getFiles((File)resourcesDirectory, (String)includes, (String)excludes);
                files.addAll(resourceFiles);
                this.getLogger().debug("Added " + resourceFiles.size() + " resource files found in '" + resourcesDirectory.getAbsolutePath() + "'.");
                continue;
            }
            this.getLogger().debug("The resources directory '" + resourcesDirectory.getAbsolutePath() + "' does not exist or is not a directory.");
        }
    }

    private FilterSet getSuppressionsFilterSet(String suppressionsFilePath) throws CheckstyleExecutorException {
        if (suppressionsFilePath == null) {
            return null;
        }
        try {
            return SuppressionsLoader.loadSuppressions((String)suppressionsFilePath);
        }
        catch (CheckstyleException ce) {
            throw new CheckstyleExecutorException("Failed to load suppressions file from: " + suppressionsFilePath, ce);
        }
    }

    private String getSuppressionsFilePath(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        String suppressionsLocation = request.getSuppressionsLocation();
        if (StringUtils.isEmpty((String)suppressionsLocation)) {
            return null;
        }
        try {
            File suppressionsFile = this.locator.getResourceAsFile(suppressionsLocation, "checkstyle-suppressions.xml");
            return suppressionsFile == null ? null : suppressionsFile.getAbsolutePath();
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Unable to find suppressions file at location: " + suppressionsLocation, e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Unable to process suppressions file location: " + suppressionsLocation, e);
        }
    }

    private String getConfigFile(CheckstyleExecutorRequest request) throws CheckstyleExecutorException {
        try {
            File configFile;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("request.getConfigLocation() " + request.getConfigLocation());
            }
            if ((configFile = this.locator.getResourceAsFile(request.getConfigLocation(), "checkstyle-checker.xml")) == null) {
                throw new CheckstyleExecutorException("Unable to process config location: " + request.getConfigLocation());
            }
            return configFile.getAbsolutePath();
        }
        catch (ResourceNotFoundException e) {
            throw new CheckstyleExecutorException("Unable to find configuration file at location: " + request.getConfigLocation(), e);
        }
        catch (FileResourceCreationException e) {
            throw new CheckstyleExecutorException("Unable to process configuration file at location: " + request.getConfigLocation(), e);
        }
    }

    private void configureResourceLocator(ResourceManager resourceManager, CheckstyleExecutorRequest request, List<Artifact> additionalArtifacts) {
        MavenProject project = request.getProject();
        resourceManager.setOutputDirectory(new File(project.getBuild().getDirectory()));
        for (MavenProject parent = project; parent != null && parent.getFile() != null; parent = parent.getParent()) {
            File dir = parent.getFile().getParentFile();
            resourceManager.addSearchPath("file", dir.getAbsolutePath());
        }
        resourceManager.addSearchPath("url", "");
        if (additionalArtifacts != null) {
            for (Artifact licenseArtifact : additionalArtifacts) {
                try {
                    resourceManager.addSearchPath("jar", "jar:" + licenseArtifact.getFile().toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }
}

