/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.trac;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.trac.TracTicket;

public class TracReportGenerator {
    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        sink.text(bundle.getString("report.trac.error"));
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink, ArrayList ticketList) {
        this.sinkBeginReport(sink, bundle);
        this.constructHeaderRow(sink, ticketList, bundle);
        this.constructDetailRows(sink, ticketList, bundle);
        this.sinkEndReport(sink);
    }

    private void constructHeaderRow(Sink sink, List ticketList, ResourceBundle bundle) {
        if (ticketList == null) {
            return;
        }
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.trac.label.id"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.type"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.summary"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.owner"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.reporter"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.priority"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.status"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.resolution"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.created"));
        this.sinkHeader(sink, bundle.getString("report.trac.label.changed"));
        sink.tableRow_();
    }

    private void constructDetailRows(Sink sink, List ticketList, ResourceBundle bundle) {
        if (ticketList == null) {
            return;
        }
        for (int idx = 0; idx < ticketList.size(); ++idx) {
            SimpleDateFormat sdf = new SimpleDateFormat(bundle.getString("report.trac.dateformat"));
            TracTicket ticket = (TracTicket)ticketList.get(idx);
            sink.tableRow();
            sink.tableCell();
            sink.link(ticket.getLink());
            sink.text(ticket.getId());
            sink.link_();
            sink.tableCell_();
            this.sinkCell(sink, ticket.getType());
            this.sinkCell(sink, ticket.getSummary());
            this.sinkCell(sink, ticket.getOwner());
            this.sinkCell(sink, ticket.getReporter());
            this.sinkCell(sink, ticket.getPriority());
            this.sinkCell(sink, ticket.getStatus());
            this.sinkCell(sink, ticket.getResolution());
            this.sinkCell(sink, sdf.format(ticket.getTimeCreated()));
            this.sinkCell(sink, sdf.format(ticket.getTimeChanged()));
            sink.tableRow_();
        }
        sink.table_();
    }

    private void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        sink.text(bundle.getString("report.trac.header"));
        sink.head_();
        sink.body();
        this.sinkSectionTitle1(sink, bundle.getString("report.trac.header"));
    }

    private void sinkEndReport(Sink sink) {
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkFigure(Sink sink, String image) {
        sink.figure();
        sink.figureGraphics(image);
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        if (text != null) {
            sink.rawText(text);
        } else {
            sink.rawText("&nbsp;");
        }
        sink.tableCell_();
    }

    private void sinkSectionTitle1(Sink sink, String text) {
        sink.sectionTitle1();
        sink.text(text);
        sink.sectionTitle1_();
    }
}

