/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.changes.schema.ChangesSchemaValidator;
import org.apache.maven.plugin.changes.schema.SchemaValidatorException;
import org.apache.maven.plugin.changes.schema.XmlValidationHandler;
import org.xml.sax.SAXException;

public class ChangesValidatorMojo
extends AbstractMojo {
    private File xmlPath;
    private String changesXsdVersion;
    private ChangesSchemaValidator changesSchemaValidator;
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block5: {
            if (!this.xmlPath.exists()) {
                this.getLog().warn((CharSequence)("changes.xml file " + this.xmlPath.getAbsolutePath() + " does not exist."));
                return;
            }
            try {
                boolean hasErrors;
                XmlValidationHandler xmlValidationHandler = this.changesSchemaValidator.validateXmlWithSchema(this.xmlPath, this.changesXsdVersion, this.failOnError);
                boolean bl = hasErrors = !xmlValidationHandler.getErrors().isEmpty();
                if (hasErrors) {
                    this.logSchemaValidation(xmlValidationHandler.getErrors());
                    if (this.failOnError) {
                        throw new MojoExecutionException("changes.xml file " + this.xmlPath.getAbsolutePath() + " is not valid, see previous errors.");
                    }
                    this.getLog().info((CharSequence)" skip previous validation errors due to failOnError=false.");
                }
            }
            catch (SchemaValidatorException e) {
                if (!this.failOnError) break block5;
                throw new MojoExecutionException("failed to validate changes.xml file " + this.xmlPath.getAbsolutePath() + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    private void logSchemaValidation(List errors) {
        this.getLog().warn((CharSequence)("failed to validate changes.xml file " + this.xmlPath.getAbsolutePath()));
        this.getLog().warn((CharSequence)"validation errors: ");
        Iterator iterator = errors.iterator();
        while (iterator.hasNext()) {
            SAXException error = (SAXException)iterator.next();
            this.getLog().warn((CharSequence)error.getMessage());
        }
    }
}

