/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.DueTo;
import org.apache.maven.plugins.changes.model.FixedIssue;
import org.apache.maven.plugins.changes.model.Release;

public class ChangesReportGenerator {
    private static final String URL_TOKEN = "%URL%";
    private static final String ISSUE_TOKEN = "%ISSUE%";
    private static final String DEFAULT_ISSUE_SYSTEM_KEY = "default";
    private ChangesXML report;
    private String url;
    private Map issueLinksPerSystem = new HashMap();
    private boolean addActionDate;

    public ChangesReportGenerator() {
    }

    public ChangesReportGenerator(File xmlPath, Log log) {
        this();
        this.report = new ChangesXML(xmlPath, log);
    }

    public void setIssueLink(String issueLink) {
        if (this.issueLinksPerSystem == null) {
            this.issueLinksPerSystem = new HashMap();
        }
        this.issueLinksPerSystem.put(DEFAULT_ISSUE_SYSTEM_KEY, issueLink);
    }

    public String getIssueLink() {
        return (String)this.issueLinksPerSystem.get(DEFAULT_ISSUE_SYSTEM_KEY);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public Map getIssueLinksPerSystem() {
        return this.issueLinksPerSystem;
    }

    public void setIssueLinksPerSystem(Map issueLinksPerSystem) {
        if (this.issueLinksPerSystem != null && issueLinksPerSystem == null) {
            return;
        }
        this.issueLinksPerSystem = issueLinksPerSystem;
    }

    public boolean isAddActionDate() {
        return this.addActionDate;
    }

    public void setAddActionDate(boolean addActionDate) {
        this.addActionDate = addActionDate;
    }

    public boolean canGenerateIssueLinks(String system) {
        if (!this.issueLinksPerSystem.containsKey(system)) {
            return false;
        }
        String issueLink = (String)this.issueLinksPerSystem.get(system);
        return !StringUtils.isBlank((String)issueLink) && (!StringUtils.isBlank((String)this.getUrl()) || issueLink.indexOf(URL_TOKEN) < 0);
    }

    public boolean canGenerateIssueLinks() {
        if (this.issueLinksPerSystem == null || this.issueLinksPerSystem.isEmpty()) {
            return false;
        }
        return this.issueLinksPerSystem.containsKey(DEFAULT_ISSUE_SYSTEM_KEY);
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink, String message) {
        this.sinkBeginReport(sink, bundle);
        sink.text(message);
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        this.constructReleaseHistory(sink, bundle);
        this.constructReleases(sink, bundle);
        this.sinkEndReport(sink);
    }

    private void constructActions(Sink sink, List actionList, ResourceBundle bundle) {
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.changes.label.type"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.changes"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.by"));
        if (this.isAddActionDate()) {
            this.sinkHeader(sink, bundle.getString("report.changes.label.date"));
        }
        sink.tableRow_();
        for (int idx = 0; idx < actionList.size(); ++idx) {
            Action action = (Action)actionList.get(idx);
            sink.tableRow();
            this.sinkShowTypeIcon(sink, action.getType());
            sink.tableCell();
            sink.rawText(action.getAction());
            if (StringUtils.isNotEmpty((String)action.getIssue()) || !action.getFixedIssues().isEmpty()) {
                sink.text(" " + bundle.getString("report.changes.text.fixes") + " ");
                String system = action.getSystem();
                String string = system = StringUtils.isEmpty((String)system) ? DEFAULT_ISSUE_SYSTEM_KEY : system;
                if (!this.canGenerateIssueLinks(system)) {
                    this.constructIssueText(action.getIssue(), sink, action.getFixedIssues());
                } else {
                    this.constructIssueLink(action.getIssue(), system, sink, action.getFixedIssues());
                }
                sink.text(".");
            }
            if (StringUtils.isNotEmpty((String)action.getDueTo()) || !action.getDueTos().isEmpty()) {
                this.constructDueTo(sink, action, bundle, action.getDueTos());
            }
            sink.tableCell_();
            this.sinkCellLink(sink, action.getDev(), "team-list.html#" + action.getDev());
            if (this.isAddActionDate()) {
                this.sinkCell(sink, action.getDate());
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void constructReleaseHistory(Sink sink, ResourceBundle bundle) {
        sink.section2();
        this.sinkSectionTitle2Anchor(sink, bundle.getString("report.changes.label.releasehistory"), bundle.getString("report.changes.label.releasehistory"));
        List releaseList = this.report.getReleaseList();
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.changes.label.version"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.date"));
        this.sinkHeader(sink, bundle.getString("report.changes.label.description"));
        sink.tableRow_();
        for (int idx = 0; idx < releaseList.size(); ++idx) {
            Release release = (Release)releaseList.get(idx);
            sink.tableRow();
            this.sinkCellLink(sink, release.getVersion(), "#" + HtmlTools.encodeId((String)release.getVersion()));
            this.sinkCell(sink, release.getDateRelease());
            this.sinkCell(sink, release.getDescription());
            sink.tableRow_();
        }
        sink.table_();
        sink.section2_();
    }

    private void constructReleases(Sink sink, ResourceBundle bundle) {
        List releaseList = this.report.getReleaseList();
        for (int idx = 0; idx < releaseList.size(); ++idx) {
            Release release = (Release)releaseList.get(idx);
            sink.section2();
            this.sinkSectionTitle2Anchor(sink, bundle.getString("report.changes.label.release") + " " + release.getVersion() + " - " + release.getDateRelease(), HtmlTools.encodeId((String)release.getVersion()));
            this.constructActions(sink, release.getActions(), bundle);
            sink.section2_();
        }
    }

    private String parseIssueLink(String issue, String system) {
        String issueLink = (String)this.issueLinksPerSystem.get(system);
        String parseLink = issueLink.replaceFirst(ISSUE_TOKEN, issue);
        if (parseLink.indexOf(URL_TOKEN) >= 0) {
            String url = this.url.substring(0, this.url.lastIndexOf("/"));
            parseLink = parseLink.replaceFirst(URL_TOKEN, url);
        }
        return parseLink;
    }

    private void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        String title = null;
        title = this.report.getTitle() != null ? this.report.getTitle() : bundle.getString("report.changes.header");
        sink.title();
        sink.text(title);
        sink.title_();
        if (StringUtils.isNotEmpty((String)this.report.getAuthor())) {
            sink.author();
            sink.text(this.report.getAuthor());
            sink.author_();
        }
        sink.head_();
        sink.body();
        sink.section1();
        this.sinkSectionTitle1Anchor(sink, title, title);
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        this.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private void sinkEndReport(Sink sink) {
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkFigure(String image, Sink sink, String altText) {
        sink.figure();
        sink.figureGraphics(image);
        sink.figureCaption();
        sink.text(altText);
        sink.figureCaption_();
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private void sinkSectionTitle1Anchor(Sink sink, String text, String anchor) {
        sink.sectionTitle1();
        sink.anchor(anchor);
        sink.anchor_();
        sink.text(text);
        sink.sectionTitle1_();
    }

    private void sinkSectionTitle2Anchor(Sink sink, String text, String anchor) {
        sink.sectionTitle2();
        sink.anchor(anchor);
        sink.anchor_();
        sink.text(text);
        sink.sectionTitle2_();
    }

    private void sinkShowTypeIcon(Sink sink, String type) {
        String image = "";
        String altText = "";
        if (type == null) {
            image = "images/icon_help_sml.gif";
            altText = "?";
        } else if (type.equals("fix")) {
            image = "images/fix.gif";
            altText = "fix";
        } else if (type.equals("update")) {
            image = "images/update.gif";
            altText = "update";
        } else if (type.equals("add")) {
            image = "images/add.gif";
            altText = "add";
        } else if (type.equals("remove")) {
            image = "images/remove.gif";
            altText = "remove";
        }
        sink.tableCell();
        this.sinkFigure(image, sink, altText);
        sink.tableCell_();
    }

    private void constructIssueLink(String issue, String system, Sink sink, List fixes) {
        if (StringUtils.isNotEmpty((String)issue)) {
            sink.link(this.parseIssueLink(issue, system));
            sink.text(issue);
            sink.link_();
            if (!fixes.isEmpty()) {
                sink.text(", ");
            }
        }
        Iterator iterator = fixes.iterator();
        while (iterator.hasNext()) {
            FixedIssue fixedIssue = (FixedIssue)iterator.next();
            String currentIssueId = fixedIssue.getIssue();
            if (StringUtils.isNotEmpty((String)currentIssueId)) {
                sink.link(this.parseIssueLink(currentIssueId, system));
                sink.text(currentIssueId);
                sink.link_();
            }
            if (!iterator.hasNext()) continue;
            sink.text(", ");
        }
    }

    private void constructIssueText(String issue, Sink sink, List fixes) {
        if (StringUtils.isNotEmpty((String)issue)) {
            sink.text(issue);
            if (!fixes.isEmpty()) {
                sink.text(", ");
            }
        }
        Iterator iterator = fixes.iterator();
        while (iterator.hasNext()) {
            FixedIssue fixedIssue = (FixedIssue)iterator.next();
            String currentIssueId = fixedIssue.getIssue();
            if (StringUtils.isNotEmpty((String)currentIssueId)) {
                sink.text(currentIssueId);
            }
            if (!iterator.hasNext()) continue;
            sink.text(", ");
        }
    }

    private void constructDueTo(Sink sink, Action action, ResourceBundle bundle, List dueTos) {
        LinkedHashMap<String, String> namesEmailMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotEmpty((String)action.getDueTo()) || StringUtils.isNotEmpty((String)action.getDueToEmail())) {
            namesEmailMap.put(action.getDueTo(), action.getDueToEmail());
        }
        Iterator iterator = dueTos.iterator();
        while (iterator.hasNext()) {
            DueTo dueTo = (DueTo)iterator.next();
            namesEmailMap.put(dueTo.getName(), dueTo.getEmail());
        }
        if (namesEmailMap.isEmpty()) {
            return;
        }
        sink.text(" " + bundle.getString("report.changes.text.thanx") + " ");
        int i = 0;
        Iterator iterator2 = namesEmailMap.keySet().iterator();
        while (iterator2.hasNext()) {
            String currentDueTo = (String)iterator2.next();
            String currentDueToEmail = (String)namesEmailMap.get(currentDueTo);
            ++i;
            if (StringUtils.isNotEmpty((String)currentDueToEmail)) {
                this.sinkLink(sink, currentDueTo, "mailto:" + currentDueToEmail);
            } else if (StringUtils.isNotEmpty((String)currentDueTo)) {
                sink.text(currentDueTo);
            }
            if (i >= namesEmailMap.size()) continue;
            sink.text(", ");
        }
        sink.text(".");
    }
}

