/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeFile;

public class FileActivityComparator
implements Comparator {
    public int compare(Object o1, Object o2) throws ClassCastException {
        List list1 = (List)o1;
        List list2 = (List)o2;
        int returnValue = this.sortByCommits(list1, list2);
        if (returnValue != 0) {
            return returnValue;
        }
        returnValue = this.sortByRevision(list1, list2);
        if (returnValue != 0) {
            return returnValue;
        }
        returnValue = this.sortByName(list1, list2);
        return returnValue;
    }

    private int sortByCommits(List list1, List list2) {
        if (list1.size() > list2.size()) {
            return -1;
        }
        if (list1.size() < list2.size()) {
            return 1;
        }
        return 0;
    }

    private int sortByRevision(List list1, List list2) {
        String revision1 = this.getLatestRevision(list1);
        String revision2 = this.getLatestRevision(list2);
        return revision1.compareTo(revision2);
    }

    private String getLatestRevision(List list) {
        String latest = "";
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ChangeFile file = (ChangeFile)i.next();
            if (latest.length() == 0) {
                latest = file.getRevision();
                continue;
            }
            if (latest.compareTo(file.getRevision()) >= 0) continue;
            latest = file.getRevision();
        }
        return latest;
    }

    private int sortByName(List list1, List list2) {
        ChangeFile file1 = (ChangeFile)list1.get(0);
        ChangeFile file2 = (ChangeFile)list2.get(0);
        return file1.getName().compareTo(file2.getName());
    }
}

