/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChangeLogHandler
extends DefaultHandler {
    private Collection changeSets;
    private String bufData = "";
    private ChangeFile bufFile;
    private ChangeSet bufEntry;
    private LinkedList bufEntries;
    private ChangeLogSet bufSet;
    private String currentPattern;

    public ChangeLogHandler(Collection changeSets) {
        this.changeSets = changeSets;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bufData = this.bufData + new String(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("changeset".equals(qName)) {
            this.changeSets.add(this.bufSet);
        }
        if ("changelog-entry".equals(qName)) {
            this.bufEntries.add(this.bufEntry);
        }
        if ("file".equals(qName)) {
            this.bufEntry.addFile(this.bufFile);
        } else if ("date".equals(qName)) {
            try {
                long ms = 0L;
                if (this.bufEntry.getDate() != null) {
                    ms = this.bufEntry.getDate().getTime();
                }
                this.bufEntry.setDate(new Date(ms + new SimpleDateFormat(this.currentPattern).parse(this.bufData).getTime()));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("time".equals(qName)) {
            try {
                long ms = 0L;
                if (this.bufEntry.getDate() != null) {
                    ms = this.bufEntry.getDate().getTime();
                }
                this.bufEntry.setDate(new Date(ms + new SimpleDateFormat(this.currentPattern).parse(this.bufData).getTime() + (long)TimeZone.getDefault().getRawOffset()));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("author".equals(qName)) {
            this.bufEntry.setAuthor(this.bufData);
        } else if ("msg".equals(qName)) {
            this.bufEntry.setComment(this.bufData);
        }
        if ("revision".equals(qName)) {
            this.bufFile.setRevision(this.bufData);
        } else if ("name".equals(qName)) {
            this.bufFile.setName(this.bufData.replaceFirst(" \\(from [^:]+:\\d+\\)", ""));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.bufData = "";
        if ("file".equals(qName)) {
            this.bufFile = new ChangeFile("");
        } else if ("changelog-entry".equals(qName)) {
            this.bufEntry = new ChangeSet();
        } else if ("date".equals(qName)) {
            this.currentPattern = attributes.getValue("pattern");
            if (this.currentPattern == null) {
                this.currentPattern = "yyyy-MM-dd";
            }
        } else if ("time".equals(qName)) {
            this.currentPattern = attributes.getValue("pattern");
            if (this.currentPattern == null) {
                this.currentPattern = "HH:mm:ss";
            }
        } else if ("changeset".equals(qName)) {
            this.bufEntries = new LinkedList();
            this.currentPattern = attributes.getValue("datePattern");
            if (this.currentPattern == null) {
                this.currentPattern = "yyyy-MM-dd";
            }
            SimpleDateFormat formatter = new SimpleDateFormat(this.currentPattern);
            String start = attributes.getValue("start");
            String end = attributes.getValue("end");
            Date startDate = null;
            Date endDate = null;
            if (start != null) {
                try {
                    startDate = formatter.parse(start);
                }
                catch (ParseException e) {
                    throw new SAXException("Can't parse start date '" + start + "'.", e);
                }
            }
            if (end != null) {
                try {
                    endDate = formatter.parse(end);
                }
                catch (ParseException e) {
                    throw new SAXException("Can't parse end date '" + end + "'.", e);
                }
            }
            this.bufSet = new ChangeLogSet((List)this.bufEntries, startDate, endDate);
            this.bufSet.setStartVersion((ScmVersion)new ScmTag(attributes.getValue("startTag")));
            this.bufSet.setEndVersion((ScmVersion)new ScmTag(attributes.getValue("endTag")));
        }
    }
}

