/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.repository;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.assembly.repository.RepositoryAssembler;
import org.apache.maven.plugins.assembly.repository.RepositoryAssemblyException;
import org.apache.maven.plugins.assembly.repository.RepositoryBuilderConfigSource;
import org.apache.maven.plugins.assembly.repository.model.GroupVersionAlignment;
import org.apache.maven.plugins.assembly.repository.model.RepositoryInfo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.transfer.artifact.TransferUtils;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultRepositoryAssembler
implements RepositoryAssembler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryAssembler.class);
    private final ArtifactResolver artifactResolver;
    private final RepositoryManager repositoryManager;
    private final DependencyResolver dependencyResolver;

    @Inject
    public DefaultRepositoryAssembler(ArtifactResolver artifactResolver, RepositoryManager repositoryManager, DependencyResolver dependencyResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.dependencyResolver = Objects.requireNonNull(dependencyResolver);
    }

    @Override
    public void buildRemoteRepository(File repositoryDirectory, RepositoryInfo repository, RepositoryBuilderConfigSource configSource) throws RepositoryAssemblyException {
        Iterable result;
        MavenProject project = configSource.getProject();
        ProjectBuildingRequest buildingRequest = configSource.getProjectBuildingRequest();
        List dependencies = project.getDependencies();
        if (dependencies == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("dependency-artifact set for project: " + project.getId() + " is null. Skipping repository processing.");
            }
            return;
        }
        List managedDependencies = null;
        if (project.getDependencyManagement() != null) {
            managedDependencies = project.getDependencyManagement().getDependencies();
        }
        File tempRepo = new File(repositoryDirectory.getParentFile(), repositoryDirectory.getName() + "_tmp");
        buildingRequest = this.repositoryManager.setLocalRepositoryBasedir(buildingRequest, tempRepo);
        try {
            result = this.dependencyResolver.resolveDependencies(buildingRequest, (Collection)dependencies, (Collection)managedDependencies, null);
        }
        catch (DependencyResolverException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        ArtifactFilter filter = this.buildRepositoryFilter(repository, project);
        buildingRequest = this.repositoryManager.setLocalRepositoryBasedir(buildingRequest, repositoryDirectory);
        Map<String, GroupVersionAlignment> groupVersionAlignments = this.createGroupVersionAlignments(repository.getGroupVersionAlignments());
        this.assembleRepositoryArtifacts(buildingRequest, result, filter, groupVersionAlignments);
        if (repository.isIncludeMetadata()) {
            // empty if block
        }
        try {
            FileUtils.deleteDirectory((File)tempRepo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ArtifactFilter buildRepositoryFilter(RepositoryInfo repository, MavenProject project) {
        AndArtifactFilter filter = new AndArtifactFilter();
        ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter(repository.getScope());
        filter.add((ArtifactFilter)scopeFilter);
        List<String> includes = repository.getIncludes();
        if (includes == null || includes.isEmpty()) {
            ArrayList<String> patterns = new ArrayList<String>();
            Set projectArtifacts = project.getDependencyArtifacts();
            if (projectArtifacts != null) {
                for (Artifact artifact : projectArtifacts) {
                    patterns.add(artifact.getDependencyConflictId());
                }
            }
            PatternIncludesArtifactFilter includeFilter = new PatternIncludesArtifactFilter(patterns, true);
            filter.add((ArtifactFilter)includeFilter);
        } else {
            filter.add((ArtifactFilter)new PatternIncludesArtifactFilter(repository.getIncludes(), true));
        }
        List<String> excludes = repository.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            filter.add((ArtifactFilter)new PatternExcludesArtifactFilter(repository.getExcludes(), true));
        }
        return filter;
    }

    private void assembleRepositoryArtifacts(ProjectBuildingRequest buildingRequest, Iterable<ArtifactResult> result, ArtifactFilter filter, Map<String, GroupVersionAlignment> groupVersionAlignments) throws RepositoryAssemblyException {
        try {
            for (ArtifactResult ar : result) {
                Artifact a = ar.getArtifact();
                if (!filter.include(a)) continue;
                LOGGER.debug("Re-resolving: " + a + " for repository assembly.");
                this.setAlignment(a, groupVersionAlignments);
                this.artifactResolver.resolveArtifact(buildingRequest, TransferUtils.toArtifactCoordinate((Artifact)a));
                a.setVersion(a.getBaseVersion());
                File targetFile = new File(this.repositoryManager.getLocalRepositoryBasedir(buildingRequest), this.repositoryManager.getPathForLocalArtifact(buildingRequest, a));
                FileUtils.copyFile((File)a.getFile(), (File)targetFile);
            }
        }
        catch (ArtifactResolverException e) {
            throw new RepositoryAssemblyException("Error resolving artifacts: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryAssemblyException("Error writing artifact metdata.", e);
        }
    }

    protected Map<String, GroupVersionAlignment> createGroupVersionAlignments(List<GroupVersionAlignment> versionAlignments) {
        HashMap<String, GroupVersionAlignment> groupVersionAlignments = new HashMap<String, GroupVersionAlignment>();
        if (versionAlignments != null) {
            for (GroupVersionAlignment alignment : versionAlignments) {
                groupVersionAlignments.put(alignment.getId(), alignment);
            }
        }
        return groupVersionAlignments;
    }

    private void setAlignment(Artifact artifact, Map<String, GroupVersionAlignment> groupVersionAlignments) {
        GroupVersionAlignment alignment = groupVersionAlignments.get(artifact.getGroupId());
        if (alignment != null && !alignment.getExcludes().contains(artifact.getArtifactId())) {
            artifact.setVersion(alignment.getVersion());
        }
    }
}

