/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestCreationFinalizer
extends AbstractArchiveFinalizer {
    private final MavenProject project;
    private final MavenSession session;
    private final MavenArchiveConfiguration archiveConfiguration;
    private final MavenArchiver mavenArchiver = new MavenArchiver();

    public ManifestCreationFinalizer(MavenSession session, MavenProject project, MavenArchiveConfiguration archiveConfiguration) {
        this.session = session;
        this.project = project;
        this.archiveConfiguration = archiveConfiguration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalizeArchiveCreation(Archiver archiver) {
        if (this.archiveConfiguration == null) return;
        try {
            Manifest manifest;
            File manifestFile = this.archiveConfiguration.getManifestFile();
            if (manifestFile != null) {
                InputStreamReader manifestFileReader = null;
                try {
                    manifestFileReader = new InputStreamReader((InputStream)new FileInputStream(manifestFile), "UTF-8");
                    manifest = new Manifest((Reader)manifestFileReader);
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new ArchiverException("Manifest not found: " + e.getMessage(), (Throwable)e);
                        catch (IOException e2) {
                            throw new ArchiverException("Error processing manifest: " + e2.getMessage(), (Throwable)e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(manifestFileReader);
                        throw throwable;
                    }
                }
                IOUtil.close((Reader)manifestFileReader);
            } else {
                manifest = this.mavenArchiver.getManifest(this.session, this.project, this.archiveConfiguration);
            }
            if (manifest == null) return;
            if (!(archiver instanceof JarArchiver)) return;
            JarArchiver jarArchiver = (JarArchiver)archiver;
            jarArchiver.addConfiguredManifest(manifest);
            return;
        }
        catch (ManifestException e) {
            throw new ArchiverException("Error creating manifest: " + e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new ArchiverException("Dependencies were not resolved: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getVirtualFiles() {
        if (this.archiveConfiguration != null) {
            try {
                if (this.mavenArchiver.getManifest(this.project, this.archiveConfiguration.getManifest()) != null) {
                    return Collections.singletonList("META-INF/MANIFEST.MF");
                }
            }
            catch (ManifestException ignore) {
            }
            catch (DependencyResolutionRequiredException dependencyResolutionRequiredException) {
                // empty catch block
            }
        }
        return null;
    }
}

