// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.8.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugin.assembly.model;

/**
 * 
 *         Contains configuration options for including the binary
 * files of a
 *         project module in an assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ModuleBinaries
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     *           
     */
    private String outputDirectory;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String fileMode;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the directory
     * mode of the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String directoryMode;

    /**
     * 
     *           When specified, the attachmentClassifier will
     * cause the assembler to look at artifacts
     *           attached to the module instead of the main project
     * artifact. If it can find an attached
     *           artifact matching the specified classifier, it
     * will use it; otherwise, it will throw an
     *           exception. (Since 2.2)
     *           .
     */
    private String attachmentClassifier;

    /**
     * 
     *           If set to true, the plugin will include the direct
     * and transitive dependencies of
     *           of the project modules included here.  Otherwise,
     * it will only include the module
     *           packages only. Default value is true.
     *           
     */
    private boolean includeDependencies = true;

    /**
     * Field dependencySets.
     */
    private java.util.List<DependencySet> dependencySets;

    /**
     * 
     *             If set to true, this property will unpack all
     * module packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     *           
     */
    private boolean unpack = true;

    /**
     * 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a module artifact. (Since 2.2)
     *           .
     */
    private UnpackOptions unpackOptions;

    /**
     * 
     *             Sets the mapping pattern for all NON-UNPACKED
     * dependencies included
     *             in this assembly.
     *             Default is
     * ${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     * NOTE: If the 
     *             dependencySet specifies unpack == true,
     * outputFileNameMapping WILL NOT BE USED; in these cases, use
     * outputDirectory.
     *             See the plugin FAQ for more details about
     * entries usable in the outputFileNameMapping parameter.
     *           
     */
    private String outputFileNameMapping = "${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependencySet.
     * 
     * @param dependencySet
     */
    public void addDependencySet( DependencySet dependencySet )
    {
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet( DependencySet )

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get when specified, the attachmentClassifier will cause the
     * assembler to look at artifacts
     *           attached to the module instead of the main project
     * artifact. If it can find an attached
     *           artifact matching the specified classifier, it
     * will use it; otherwise, it will throw an
     *           exception. (Since 2.2).
     * 
     * @return String
     */
    public String getAttachmentClassifier()
    {
        return this.attachmentClassifier;
    } //-- String getAttachmentClassifier()

    /**
     * Method getDependencySets.
     * 
     * @return List
     */
    public java.util.List<DependencySet> getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList<DependencySet>();
        }

        return this.dependencySets;
    } //-- java.util.List<DependencySet> getDependencySets()

    /**
     * Get similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory()

    /**
     * Get sets the mapping pattern for all NON-UNPACKED
     * dependencies included
     *             in this assembly.
     *             Default is
     * ${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     * NOTE: If the 
     *             dependencySet specifies unpack == true,
     * outputFileNameMapping WILL NOT BE USED; in these cases, use
     * outputDirectory.
     *             See the plugin FAQ for more details about
     * entries usable in the outputFileNameMapping parameter.
     * 
     * @return String
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping()

    /**
     * Get allows the specification of includes and excludes, along
     * with filtering options, for items
     *           unpacked from a module artifact. (Since 2.2).
     * 
     * @return UnpackOptions
     */
    public UnpackOptions getUnpackOptions()
    {
        return this.unpackOptions;
    } //-- UnpackOptions getUnpackOptions()

    /**
     * Get if set to true, the plugin will include the direct and
     * transitive dependencies of
     *           of the project modules included here.  Otherwise,
     * it will only include the module
     *           packages only. Default value is true.
     * 
     * @return boolean
     */
    public boolean isIncludeDependencies()
    {
        return this.includeDependencies;
    } //-- boolean isIncludeDependencies()

    /**
     * Get if set to true, this property will unpack all module
     * packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     * 
     * @return boolean
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack()

    /**
     * Method removeDependencySet.
     * 
     * @param dependencySet
     */
    public void removeDependencySet( DependencySet dependencySet )
    {
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet( DependencySet )

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set when specified, the attachmentClassifier will cause the
     * assembler to look at artifacts
     *           attached to the module instead of the main project
     * artifact. If it can find an attached
     *           artifact matching the specified classifier, it
     * will use it; otherwise, it will throw an
     *           exception. (Since 2.2).
     * 
     * @param attachmentClassifier
     */
    public void setAttachmentClassifier( String attachmentClassifier )
    {
        this.attachmentClassifier = attachmentClassifier;
    } //-- void setAttachmentClassifier( String )

    /**
     * Set specifies which dependencies of the module to include in
     * the assembly. A
     *             dependencySet is specified by providing one or
     * more of
     *             &lt;dependencySet&gt; subelements. (Since 2.2).
     * 
     * @param dependencySets
     */
    public void setDependencySets( java.util.List<DependencySet> dependencySets )
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets( java.util.List )

    /**
     * Set similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param directoryMode
     */
    public void setDirectoryMode( String directoryMode )
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode( String )

    /**
     * Set when &lt;exclude&gt; subelements are present, they
     * define a set of
     *             dependency artifact coordinates to exclude. If
     * none is present, then
     *             &lt;excludes&gt; represents no exclusions.
     * 
     *             Artifact coordinates may be given in simple
     * groupId:artifactId form,
     *             or they may be fully qualified in the form
     * groupId:artifactId:type[:classifier]:version.
     *             Additionally, wildcards can be used, as in
     * *:maven-*.
     * 
     * @param excludes
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param fileMode
     */
    public void setFileMode( String fileMode )
    {
        this.fileMode = fileMode;
    } //-- void setFileMode( String )

    /**
     * Set if set to true, the plugin will include the direct and
     * transitive dependencies of
     *           of the project modules included here.  Otherwise,
     * it will only include the module
     *           packages only. Default value is true.
     * 
     * @param includeDependencies
     */
    public void setIncludeDependencies( boolean includeDependencies )
    {
        this.includeDependencies = includeDependencies;
    } //-- void setIncludeDependencies( boolean )

    /**
     * Set when &lt;include&gt; subelements are present, they
     * define a set of
     *             artifact coordinates to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     * 
     *             Artifact coordinates may be given in simple
     * groupId:artifactId form,
     *             or they may be fully qualified in the form
     * groupId:artifactId:type[:classifier]:version.
     *             Additionally, wildcards can be used, as in
     * *:maven-*.
     * 
     * @param includes
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String )

    /**
     * Set sets the mapping pattern for all NON-UNPACKED
     * dependencies included
     *             in this assembly.
     *             Default is
     * ${module.artifactId}-${module.version}${dashClassifier?}.${module.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     * NOTE: If the 
     *             dependencySet specifies unpack == true,
     * outputFileNameMapping WILL NOT BE USED; in these cases, use
     * outputDirectory.
     *             See the plugin FAQ for more details about
     * entries usable in the outputFileNameMapping parameter.
     * 
     * @param outputFileNameMapping
     */
    public void setOutputFileNameMapping( String outputFileNameMapping )
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping( String )

    /**
     * Set if set to true, this property will unpack all module
     * packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     * 
     * @param unpack
     */
    public void setUnpack( boolean unpack )
    {
        this.unpack = unpack;
    } //-- void setUnpack( boolean )

    /**
     * Set allows the specification of includes and excludes, along
     * with filtering options, for items
     *           unpacked from a module artifact. (Since 2.2).
     * 
     * @param unpackOptions
     */
    public void setUnpackOptions( UnpackOptions unpackOptions )
    {
        this.unpackOptions = unpackOptions;
    } //-- void setUnpackOptions( UnpackOptions )

}
