/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes the component layout and packaging.
 * 
 * @version $Revision$ $Date$
 */
public class Component
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field fileSets.
     */
    private java.util.List/*<FileSet>*/ fileSets;

    /**
     * Field files.
     */
    private java.util.List/*<FileItem>*/ files;

    /**
     * Field dependencySets.
     */
    private java.util.List/*<DependencySet>*/ dependencySets;

    /**
     * Field repositories.
     */
    private java.util.List/*<Repository>*/ repositories;

    /**
     * Field containerDescriptorHandlers.
     */
    private java.util.List/*<ContainerDescriptorHandlerConfig>*/ containerDescriptorHandlers;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addContainerDescriptorHandler.
     * 
     * @param containerDescriptorHandlerConfig
     */
    public void addContainerDescriptorHandler( ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig )
    {
        if ( !(containerDescriptorHandlerConfig instanceof ContainerDescriptorHandlerConfig) )
        {
            throw new ClassCastException( "Component.addContainerDescriptorHandlers(containerDescriptorHandlerConfig) parameter must be instanceof " + ContainerDescriptorHandlerConfig.class.getName() );
        }
        getContainerDescriptorHandlers().add( containerDescriptorHandlerConfig );
    } //-- void addContainerDescriptorHandler( ContainerDescriptorHandlerConfig )

    /**
     * Method addDependencySet.
     * 
     * @param dependencySet
     */
    public void addDependencySet( DependencySet dependencySet )
    {
        if ( !(dependencySet instanceof DependencySet) )
        {
            throw new ClassCastException( "Component.addDependencySets(dependencySet) parameter must be instanceof " + DependencySet.class.getName() );
        }
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet( DependencySet )

    /**
     * Method addFile.
     * 
     * @param fileItem
     */
    public void addFile( FileItem fileItem )
    {
        if ( !(fileItem instanceof FileItem) )
        {
            throw new ClassCastException( "Component.addFiles(fileItem) parameter must be instanceof " + FileItem.class.getName() );
        }
        getFiles().add( fileItem );
    } //-- void addFile( FileItem )

    /**
     * Method addFileSet.
     * 
     * @param fileSet
     */
    public void addFileSet( FileSet fileSet )
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "Component.addFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().add( fileSet );
    } //-- void addFileSet( FileSet )

    /**
     * Method addRepository.
     * 
     * @param repository
     */
    public void addRepository( Repository repository )
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Component.addRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getRepositories().add( repository );
    } //-- void addRepository( Repository )

    /**
     * Method getContainerDescriptorHandlers.
     * 
     * @return List
     */
    public java.util.List/*<ContainerDescriptorHandlerConfig>*/ getContainerDescriptorHandlers()
    {
        if ( this.containerDescriptorHandlers == null )
        {
            this.containerDescriptorHandlers = new java.util.ArrayList/*<ContainerDescriptorHandlerConfig>*/();
        }

        return this.containerDescriptorHandlers;
    } //-- java.util.List/*<ContainerDescriptorHandlerConfig>*/ getContainerDescriptorHandlers()

    /**
     * Method getDependencySets.
     * 
     * @return List
     */
    public java.util.List/*<DependencySet>*/ getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList/*<DependencySet>*/();
        }

        return this.dependencySets;
    } //-- java.util.List/*<DependencySet>*/ getDependencySets()

    /**
     * Method getFileSets.
     * 
     * @return List
     */
    public java.util.List/*<FileSet>*/ getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList/*<FileSet>*/();
        }

        return this.fileSets;
    } //-- java.util.List/*<FileSet>*/ getFileSets()

    /**
     * Method getFiles.
     * 
     * @return List
     */
    public java.util.List/*<FileItem>*/ getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList/*<FileItem>*/();
        }

        return this.files;
    } //-- java.util.List/*<FileItem>*/ getFiles()

    /**
     * Method getModelEncoding.
     * 
     * @return the current encoding used when reading/writing this
     * model
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List/*<Repository>*/ getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList/*<Repository>*/();
        }

        return this.repositories;
    } //-- java.util.List/*<Repository>*/ getRepositories()

    /**
     * Method removeContainerDescriptorHandler.
     * 
     * @param containerDescriptorHandlerConfig
     */
    public void removeContainerDescriptorHandler( ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig )
    {
        if ( !(containerDescriptorHandlerConfig instanceof ContainerDescriptorHandlerConfig) )
        {
            throw new ClassCastException( "Component.removeContainerDescriptorHandlers(containerDescriptorHandlerConfig) parameter must be instanceof " + ContainerDescriptorHandlerConfig.class.getName() );
        }
        getContainerDescriptorHandlers().remove( containerDescriptorHandlerConfig );
    } //-- void removeContainerDescriptorHandler( ContainerDescriptorHandlerConfig )

    /**
     * Method removeDependencySet.
     * 
     * @param dependencySet
     */
    public void removeDependencySet( DependencySet dependencySet )
    {
        if ( !(dependencySet instanceof DependencySet) )
        {
            throw new ClassCastException( "Component.removeDependencySets(dependencySet) parameter must be instanceof " + DependencySet.class.getName() );
        }
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet( DependencySet )

    /**
     * Method removeFile.
     * 
     * @param fileItem
     */
    public void removeFile( FileItem fileItem )
    {
        if ( !(fileItem instanceof FileItem) )
        {
            throw new ClassCastException( "Component.removeFiles(fileItem) parameter must be instanceof " + FileItem.class.getName() );
        }
        getFiles().remove( fileItem );
    } //-- void removeFile( FileItem )

    /**
     * Method removeFileSet.
     * 
     * @param fileSet
     */
    public void removeFileSet( FileSet fileSet )
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "Component.removeFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().remove( fileSet );
    } //-- void removeFileSet( FileSet )

    /**
     * Method removeRepository.
     * 
     * @param repository
     */
    public void removeRepository( Repository repository )
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Component.removeRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getRepositories().remove( repository );
    } //-- void removeRepository( Repository )

    /**
     * Set 
     *             
     *             Set of components which filter various container
     * descriptors out of
     *             the normal archive stream, so they can be
     * aggregated then added.
     *             
     *           
     * 
     * @param containerDescriptorHandlers
     */
    public void setContainerDescriptorHandlers( java.util.List/*<ContainerDescriptorHandlerConfig>*/ containerDescriptorHandlers )
    {
        this.containerDescriptorHandlers = containerDescriptorHandlers;
    } //-- void setContainerDescriptorHandlers( java.util.List )

    /**
     * Set 
     *             
     *             Specifies which dependencies to include in the
     * assembly. A
     *             dependencySet is specified by providing one or
     * more of
     *             &lt;dependencySet&gt; subelements.
     *             
     *           
     * 
     * @param dependencySets
     */
    public void setDependencySets( java.util.List/*<DependencySet>*/ dependencySets )
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets( java.util.List )

    /**
     * Set 
     *             
     *             Specifies which groups of files to include in
     * the assembly. A
     *             fileSet is specified by providing one or more of
     * &lt;fileSet&gt;
     *             subelements.
     *             
     *           
     * 
     * @param fileSets
     */
    public void setFileSets( java.util.List/*<FileSet>*/ fileSets )
    {
        this.fileSets = fileSets;
    } //-- void setFileSets( java.util.List )

    /**
     * Set 
     *             
     *             Specifies which single files to include in the
     * assembly. A file
     *             is specified by providing one or more of
     * &lt;file&gt;
     *             subelements.
     *             
     *           
     * 
     * @param files
     */
    public void setFiles( java.util.List/*<FileItem>*/ files )
    {
        this.files = files;
    } //-- void setFiles( java.util.List )

    /**
     * Set an encoding used for reading/writing the model.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set 
     *             
     *             Specifies a set of repositories to include in
     * the assembly. A
     *             repository is specified by providing one or more
     * of
     *             &lt;repository&gt; subelements.
     *             
     *           
     * 
     * @param repositories
     */
    public void setRepositories( java.util.List/*<Repository>*/ repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )


}
