/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.plugin.assembly.model.Component;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.GroupVersionAlignment;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.SetBase;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class ComponentXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class ComponentXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param component
     * @throws java.io.IOException
     */
    public void write(Writer writer, Component component)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( component.getModelEncoding(), null );
        writeComponent( component, "component", serializer );
        serializer.endDocument();
    } //-- void write(Writer, Component) 

    /**
     * Method writeComponent.
     * 
     * @param component
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeComponent(Component component, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( component != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( component.getFileSets() != null && component.getFileSets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "fileSets" );
                for ( Iterator iter = component.getFileSets().iterator(); iter.hasNext(); )
                {
                    FileSet o = (FileSet) iter.next();
                    writeFileSet( o, "fileSet", serializer );
                }
                serializer.endTag( NAMESPACE, "fileSets" );
            }
            if ( component.getFiles() != null && component.getFiles().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "files" );
                for ( Iterator iter = component.getFiles().iterator(); iter.hasNext(); )
                {
                    FileItem o = (FileItem) iter.next();
                    writeFileItem( o, "file", serializer );
                }
                serializer.endTag( NAMESPACE, "files" );
            }
            if ( component.getDependencySets() != null && component.getDependencySets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencySets" );
                for ( Iterator iter = component.getDependencySets().iterator(); iter.hasNext(); )
                {
                    DependencySet o = (DependencySet) iter.next();
                    writeDependencySet( o, "dependencySet", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencySets" );
            }
            if ( component.getRepositories() != null && component.getRepositories().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "repositories" );
                for ( Iterator iter = component.getRepositories().iterator(); iter.hasNext(); )
                {
                    Repository o = (Repository) iter.next();
                    writeRepository( o, "repository", serializer );
                }
                serializer.endTag( NAMESPACE, "repositories" );
            }
            if ( component.getContainerDescriptorHandlers() != null && component.getContainerDescriptorHandlers().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "containerDescriptorHandlers" );
                for ( Iterator iter = component.getContainerDescriptorHandlers().iterator(); iter.hasNext(); )
                {
                    ContainerDescriptorHandlerConfig o = (ContainerDescriptorHandlerConfig) iter.next();
                    writeContainerDescriptorHandlerConfig( o, "containerDescriptorHandler", serializer );
                }
                serializer.endTag( NAMESPACE, "containerDescriptorHandlers" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeComponent(Component, String, XmlSerializer) 

    /**
     * Method writeContainerDescriptorHandlerConfig.
     * 
     * @param containerDescriptorHandlerConfig
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeContainerDescriptorHandlerConfig(ContainerDescriptorHandlerConfig containerDescriptorHandlerConfig, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( containerDescriptorHandlerConfig != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( containerDescriptorHandlerConfig.getHandlerName() != null )
            {
                serializer.startTag( NAMESPACE, "handlerName" ).text( containerDescriptorHandlerConfig.getHandlerName() ).endTag( NAMESPACE, "handlerName" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeContainerDescriptorHandlerConfig(ContainerDescriptorHandlerConfig, String, XmlSerializer) 

    /**
     * Method writeDependencySet.
     * 
     * @param dependencySet
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( dependencySet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals( "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}" ) )
            {
                serializer.startTag( NAMESPACE, "outputFileNameMapping" ).text( dependencySet.getOutputFileNameMapping() ).endTag( NAMESPACE, "outputFileNameMapping" );
            }
            if ( dependencySet.isUnpack() != false )
            {
                serializer.startTag( NAMESPACE, "unpack" ).text( String.valueOf( dependencySet.isUnpack() ) ).endTag( NAMESPACE, "unpack" );
            }
            if ( dependencySet.getUnpackOptions() != null )
            {
                writeUnpackOptions( (UnpackOptions) dependencySet.getUnpackOptions(), "unpackOptions", serializer );
            }
            if ( dependencySet.getScope() != null && !dependencySet.getScope().equals( "runtime" ) )
            {
                serializer.startTag( NAMESPACE, "scope" ).text( dependencySet.getScope() ).endTag( NAMESPACE, "scope" );
            }
            if ( dependencySet.isUseProjectArtifact() != true )
            {
                serializer.startTag( NAMESPACE, "useProjectArtifact" ).text( String.valueOf( dependencySet.isUseProjectArtifact() ) ).endTag( NAMESPACE, "useProjectArtifact" );
            }
            if ( dependencySet.isUseProjectAttachments() != false )
            {
                serializer.startTag( NAMESPACE, "useProjectAttachments" ).text( String.valueOf( dependencySet.isUseProjectAttachments() ) ).endTag( NAMESPACE, "useProjectAttachments" );
            }
            if ( dependencySet.isUseTransitiveDependencies() != true )
            {
                serializer.startTag( NAMESPACE, "useTransitiveDependencies" ).text( String.valueOf( dependencySet.isUseTransitiveDependencies() ) ).endTag( NAMESPACE, "useTransitiveDependencies" );
            }
            if ( dependencySet.isUseTransitiveFiltering() != false )
            {
                serializer.startTag( NAMESPACE, "useTransitiveFiltering" ).text( String.valueOf( dependencySet.isUseTransitiveFiltering() ) ).endTag( NAMESPACE, "useTransitiveFiltering" );
            }
            if ( dependencySet.isUseStrictFiltering() != false )
            {
                serializer.startTag( NAMESPACE, "useStrictFiltering" ).text( String.valueOf( dependencySet.isUseStrictFiltering() ) ).endTag( NAMESPACE, "useStrictFiltering" );
            }
            if ( dependencySet.isUseDefaultExcludes() != true )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( dependencySet.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( dependencySet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( dependencySet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = dependencySet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = dependencySet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( dependencySet.getFileMode() != null )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( dependencySet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( dependencySet.getDirectoryMode() != null )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( dependencySet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDependencySet(DependencySet, String, XmlSerializer) 

    /**
     * Method writeFileItem.
     * 
     * @param fileItem
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeFileItem(FileItem fileItem, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileItem != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileItem.getSource() != null )
            {
                serializer.startTag( NAMESPACE, "source" ).text( fileItem.getSource() ).endTag( NAMESPACE, "source" );
            }
            if ( fileItem.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileItem.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileItem.getDestName() != null )
            {
                serializer.startTag( NAMESPACE, "destName" ).text( fileItem.getDestName() ).endTag( NAMESPACE, "destName" );
            }
            if ( fileItem.getFileMode() != null )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileItem.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileItem.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileItem.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileItem.isFiltered() != false )
            {
                serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( fileItem.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileItem(FileItem, String, XmlSerializer) 

    /**
     * Method writeFileSet.
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( fileSet.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileSet.isFiltered() != false )
            {
                serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( fileSet.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
            }
            if ( fileSet.isUseStrictFiltering() != false )
            {
                serializer.startTag( NAMESPACE, "useStrictFiltering" ).text( String.valueOf( fileSet.isUseStrictFiltering() ) ).endTag( NAMESPACE, "useStrictFiltering" );
            }
            if ( fileSet.isUseDefaultExcludes() != true )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( fileSet.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( fileSet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileSet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( fileSet.getFileMode() != null )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileSet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileSet.getDirectoryMode() != null )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( fileSet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet(FileSet, String, XmlSerializer) 

    /**
     * Method writeGroupVersionAlignment.
     * 
     * @param groupVersionAlignment
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeGroupVersionAlignment(GroupVersionAlignment groupVersionAlignment, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( groupVersionAlignment != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( groupVersionAlignment.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( groupVersionAlignment.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( groupVersionAlignment.getVersion() != null )
            {
                serializer.startTag( NAMESPACE, "version" ).text( groupVersionAlignment.getVersion() ).endTag( NAMESPACE, "version" );
            }
            if ( groupVersionAlignment.getExcludes() != null && groupVersionAlignment.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = groupVersionAlignment.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeGroupVersionAlignment(GroupVersionAlignment, String, XmlSerializer) 

    /**
     * Method writeRepository.
     * 
     * @param repository
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( repository != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( repository.isIncludeMetadata() != false )
            {
                serializer.startTag( NAMESPACE, "includeMetadata" ).text( String.valueOf( repository.isIncludeMetadata() ) ).endTag( NAMESPACE, "includeMetadata" );
            }
            if ( repository.getGroupVersionAlignments() != null && repository.getGroupVersionAlignments().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "groupVersionAlignments" );
                for ( Iterator iter = repository.getGroupVersionAlignments().iterator(); iter.hasNext(); )
                {
                    GroupVersionAlignment o = (GroupVersionAlignment) iter.next();
                    writeGroupVersionAlignment( o, "groupVersionAlignment", serializer );
                }
                serializer.endTag( NAMESPACE, "groupVersionAlignments" );
            }
            if ( repository.getScope() != null && !repository.getScope().equals( "runtime" ) )
            {
                serializer.startTag( NAMESPACE, "scope" ).text( repository.getScope() ).endTag( NAMESPACE, "scope" );
            }
            if ( repository.isUseStrictFiltering() != false )
            {
                serializer.startTag( NAMESPACE, "useStrictFiltering" ).text( String.valueOf( repository.isUseStrictFiltering() ) ).endTag( NAMESPACE, "useStrictFiltering" );
            }
            if ( repository.isUseDefaultExcludes() != true )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( repository.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( repository.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( repository.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( repository.getIncludes() != null && repository.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = repository.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( repository.getExcludes() != null && repository.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = repository.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( repository.getFileMode() != null )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( repository.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( repository.getDirectoryMode() != null )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( repository.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeRepository(Repository, String, XmlSerializer) 

    /**
     * Method writeSetBase.
     * 
     * @param setBase
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( setBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( setBase.isUseStrictFiltering() != false )
            {
                serializer.startTag( NAMESPACE, "useStrictFiltering" ).text( String.valueOf( setBase.isUseStrictFiltering() ) ).endTag( NAMESPACE, "useStrictFiltering" );
            }
            if ( setBase.isUseDefaultExcludes() != true )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( setBase.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( setBase.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( setBase.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( setBase.getIncludes() != null && setBase.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = setBase.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( setBase.getExcludes() != null && setBase.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = setBase.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( setBase.getFileMode() != null )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( setBase.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( setBase.getDirectoryMode() != null )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( setBase.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSetBase(SetBase, String, XmlSerializer) 

    /**
     * Method writeUnpackOptions.
     * 
     * @param unpackOptions
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeUnpackOptions(UnpackOptions unpackOptions, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( unpackOptions != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( unpackOptions.getIncludes() != null && unpackOptions.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = unpackOptions.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( unpackOptions.getExcludes() != null && unpackOptions.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = unpackOptions.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( unpackOptions.isFiltered() != false )
            {
                serializer.startTag( NAMESPACE, "filtered" ).text( String.valueOf( unpackOptions.isFiltered() ) ).endTag( NAMESPACE, "filtered" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeUnpackOptions(UnpackOptions, String, XmlSerializer) 


}
