/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A dependencySet allows inclusion and exclusion of
 * project dependencies
 *         in the assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class DependencySet extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Sets the mapping pattern for all dependencies
     * included in this
     *             assembly. Default is
     * ${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}.
     *             If the artifact doesn't have a classifier, that
     * part of the pattern will be left off.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     *           .
     */
    private String outputFileNameMapping = "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";

    /**
     * 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     */
    private boolean unpack = false;

    /**
     * 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a dependency artifact.
     *           
     */
    private UnpackOptions unpackOptions;

    /**
     * 
     *             Sets the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     */
    private String scope = "runtime";

    /**
     * 
     *           Determines whether the artifact produced during
     * the current project's
     *           build should be included in this dependency set.
     * Default value is true,
     *           for backward compatibility. (Since 2.2)
     *           .
     */
    private boolean useProjectArtifact = true;

    /**
     * 
     *           Determines whether the attached artifacts produced
     * during the current project's
     *           build should be included in this dependency set.
     * Default value is false. (Since 2.2)
     *           .
     */
    private boolean useProjectAttachments = false;

    /**
     * 
     *           Determines whether transitive dependencies will be
     * included in the processing of
     *           the current dependency set. If true,
     * includes/excludes/useTransitiveFiltering
     *           will apply to transitive dependency artifacts in
     * addition to the main project
     *           dependency artifacts. If false,
     * useTransitiveFiltering is meaningless, and 
     *           includes/excludes only affect the immediate
     * dependencies of the project.
     *           By default, this value is true. (Since 2.2)
     *           .
     */
    private boolean useTransitiveDependencies = true;

    /**
     * 
     *           Determines whether the include/exclude patterns in
     * this dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern, 
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2)
     *           .
     */
    private boolean useTransitiveFiltering = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Sets the mapping pattern for all dependencies
     * included in this
     *             assembly. Default is
     * ${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}.
     *             If the artifact doesn't have a classifier, that
     * part of the pattern will be left off.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     *           .
     * 
     * @return String
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping() 

    /**
     * Get 
     *             Sets the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     * 
     * @return String
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Get 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a dependency artifact.
     *           
     * 
     * @return UnpackOptions
     */
    public UnpackOptions getUnpackOptions()
    {
        return this.unpackOptions;
    } //-- UnpackOptions getUnpackOptions() 

    /**
     * Get 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     * 
     * @return boolean
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack() 

    /**
     * Get 
     *           Determines whether the artifact produced during
     * the current project's
     *           build should be included in this dependency set.
     * Default value is true,
     *           for backward compatibility. (Since 2.2)
     *           .
     * 
     * @return boolean
     */
    public boolean isUseProjectArtifact()
    {
        return this.useProjectArtifact;
    } //-- boolean isUseProjectArtifact() 

    /**
     * Get 
     *           Determines whether the attached artifacts produced
     * during the current project's
     *           build should be included in this dependency set.
     * Default value is false. (Since 2.2)
     *           .
     * 
     * @return boolean
     */
    public boolean isUseProjectAttachments()
    {
        return this.useProjectAttachments;
    } //-- boolean isUseProjectAttachments() 

    /**
     * Get 
     *           Determines whether transitive dependencies will be
     * included in the processing of
     *           the current dependency set. If true,
     * includes/excludes/useTransitiveFiltering
     *           will apply to transitive dependency artifacts in
     * addition to the main project
     *           dependency artifacts. If false,
     * useTransitiveFiltering is meaningless, and 
     *           includes/excludes only affect the immediate
     * dependencies of the project.
     *           By default, this value is true. (Since 2.2)
     *           .
     * 
     * @return boolean
     */
    public boolean isUseTransitiveDependencies()
    {
        return this.useTransitiveDependencies;
    } //-- boolean isUseTransitiveDependencies() 

    /**
     * Get 
     *           Determines whether the include/exclude patterns in
     * this dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern, 
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2)
     *           .
     * 
     * @return boolean
     */
    public boolean isUseTransitiveFiltering()
    {
        return this.useTransitiveFiltering;
    } //-- boolean isUseTransitiveFiltering() 

    /**
     * Set 
     *             Sets the mapping pattern for all dependencies
     * included in this
     *             assembly. Default is
     * ${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}.
     *             If the artifact doesn't have a classifier, that
     * part of the pattern will be left off.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension})
     *           .
     * 
     * @param outputFileNameMapping
     */
    public void setOutputFileNameMapping(String outputFileNameMapping)
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping(String) 

    /**
     * Set 
     *             Sets the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Set 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     * 
     * @param unpack
     */
    public void setUnpack(boolean unpack)
    {
        this.unpack = unpack;
    } //-- void setUnpack(boolean) 

    /**
     * Set 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a dependency artifact.
     *           
     * 
     * @param unpackOptions
     */
    public void setUnpackOptions(UnpackOptions unpackOptions)
    {
        this.unpackOptions = unpackOptions;
    } //-- void setUnpackOptions(UnpackOptions) 

    /**
     * Set 
     *           Determines whether the artifact produced during
     * the current project's
     *           build should be included in this dependency set.
     * Default value is true,
     *           for backward compatibility. (Since 2.2)
     *           .
     * 
     * @param useProjectArtifact
     */
    public void setUseProjectArtifact(boolean useProjectArtifact)
    {
        this.useProjectArtifact = useProjectArtifact;
    } //-- void setUseProjectArtifact(boolean) 

    /**
     * Set 
     *           Determines whether the attached artifacts produced
     * during the current project's
     *           build should be included in this dependency set.
     * Default value is false. (Since 2.2)
     *           .
     * 
     * @param useProjectAttachments
     */
    public void setUseProjectAttachments(boolean useProjectAttachments)
    {
        this.useProjectAttachments = useProjectAttachments;
    } //-- void setUseProjectAttachments(boolean) 

    /**
     * Set 
     *           Determines whether transitive dependencies will be
     * included in the processing of
     *           the current dependency set. If true,
     * includes/excludes/useTransitiveFiltering
     *           will apply to transitive dependency artifacts in
     * addition to the main project
     *           dependency artifacts. If false,
     * useTransitiveFiltering is meaningless, and 
     *           includes/excludes only affect the immediate
     * dependencies of the project.
     *           By default, this value is true. (Since 2.2)
     *           .
     * 
     * @param useTransitiveDependencies
     */
    public void setUseTransitiveDependencies(boolean useTransitiveDependencies)
    {
        this.useTransitiveDependencies = useTransitiveDependencies;
    } //-- void setUseTransitiveDependencies(boolean) 

    /**
     * Set 
     *           Determines whether the include/exclude patterns in
     * this dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern, 
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2)
     *           .
     * 
     * @param useTransitiveFiltering
     */
    public void setUseTransitiveFiltering(boolean useTransitiveFiltering)
    {
        this.useTransitiveFiltering = useTransitiveFiltering;
    } //-- void setUseTransitiveFiltering(boolean) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
