/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         A moduleSet represent one or more project &lt;module&gt;
 * present inside
 *         a project's pom.xml. This allows you to include sources
 * or binaries
 *         belonging to a project's &lt;modules&gt;.
 * 
 *         <br/><b>NOTE:</b> When using &lt;moduleSets&gt; from the
 * command-line, it
 *         is required to pass first the package phase by doing:
 * "mvn package
 *         assembly:assembly". This bug/issue is scheduled to be
 * addressed by Maven 2.1.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ModuleSet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includeSubModules
     */
    private boolean includeSubModules = true;

    /**
     * Field includes
     */
    private java.util.List includes;

    /**
     * Field excludes
     */
    private java.util.List excludes;

    /**
     * Field sources
     */
    private ModuleSources sources;

    /**
     * Field binaries
     */
    private ModuleBinaries binaries;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude
     * 
     * @param string
     */
    public void addExclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModuleSet.addExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().add( string );
    } //-- void addExclude(String) 

    /**
     * Method addInclude
     * 
     * @param string
     */
    public void addInclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModuleSet.addIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().add( string );
    } //-- void addInclude(String) 

    /**
     * Get 
     *             When this is present, the plugin will include
     * the binaries of the
     *             included modules from this set in the resulting
     * assembly.
     *           
     */
    public ModuleBinaries getBinaries()
    {
        return this.binaries;
    } //-- ModuleBinaries getBinaries() 

    /**
     * Method getExcludes
     */
    public java.util.List getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList();
        }
        
        return this.excludes;
    } //-- java.util.List getExcludes() 

    /**
     * Method getIncludes
     */
    public java.util.List getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList();
        }
        
        return this.includes;
    } //-- java.util.List getIncludes() 

    /**
     * Get 
     *             When this is present, the plugin will include
     * the source files of
     *             the included modules from this set in the
     * resulting assembly.
     *           
     */
    public ModuleSources getSources()
    {
        return this.sources;
    } //-- ModuleSources getSources() 

    /**
     * Get 
     *           If set to false, the plugin will exclude
     * sub-modules from processing in this ModuleSet.
     *           Otherwise, it will process all sub-modules, each
     * subject to include/exclude rules.
     *           Default value is true. (Since 2.2)
     *           
     */
    public boolean isIncludeSubModules()
    {
        return this.includeSubModules;
    } //-- boolean isIncludeSubModules() 

    /**
     * Method removeExclude
     * 
     * @param string
     */
    public void removeExclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModuleSet.removeExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().remove( string );
    } //-- void removeExclude(String) 

    /**
     * Method removeInclude
     * 
     * @param string
     */
    public void removeInclude(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "ModuleSet.removeIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().remove( string );
    } //-- void removeInclude(String) 

    /**
     * Set 
     *             When this is present, the plugin will include
     * the binaries of the
     *             included modules from this set in the resulting
     * assembly.
     *           
     * 
     * @param binaries
     */
    public void setBinaries(ModuleBinaries binaries)
    {
        this.binaries = binaries;
    } //-- void setBinaries(ModuleBinaries) 

    /**
     * Set 
     *             
     *             This is a list of &lt;exclude/&gt; subelements,
     * each containing a
     *             module reference of the type groupId:artifactId.
     * Modules matching
     *             these elements will be excluded from this set.
     *             
     *           
     * 
     * @param excludes
     */
    public void setExcludes(java.util.List excludes)
    {
        this.excludes = excludes;
    } //-- void setExcludes(java.util.List) 

    /**
     * Set 
     *           If set to false, the plugin will exclude
     * sub-modules from processing in this ModuleSet.
     *           Otherwise, it will process all sub-modules, each
     * subject to include/exclude rules.
     *           Default value is true. (Since 2.2)
     *           
     * 
     * @param includeSubModules
     */
    public void setIncludeSubModules(boolean includeSubModules)
    {
        this.includeSubModules = includeSubModules;
    } //-- void setIncludeSubModules(boolean) 

    /**
     * Set 
     *             
     *             This is a list of &lt;include/&gt; subelements,
     * each containing a
     *             module reference of the type groupId:artifactId.
     * Modules matching
     *             these elements will be included in this set. If
     * none is present,
     *             then &lt;includes&gt; represents all valid
     * values.
     *             
     *           
     * 
     * @param includes
     */
    public void setIncludes(java.util.List includes)
    {
        this.includes = includes;
    } //-- void setIncludes(java.util.List) 

    /**
     * Set 
     *             When this is present, the plugin will include
     * the source files of
     *             the included modules from this set in the
     * resulting assembly.
     *           
     * 
     * @param sources
     */
    public void setSources(ModuleSources sources)
    {
        this.sources = sources;
    } //-- void setSources(ModuleSources) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
