/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         A dependencySet allows inclusion and exclusion of
 * project dependencies
 *         in the assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class DependencySet extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputFileNameMapping
     */
    private String outputFileNameMapping = "${artifactId}-${version}.${extension}";

    /**
     * Field unpack
     */
    private boolean unpack = false;

    /**
     * Field unpackOptions
     */
    private UnpackOptions unpackOptions;

    /**
     * Field scope
     */
    private String scope = "runtime";

    /**
     * Field useTransitiveFiltering
     */
    private boolean useTransitiveFiltering = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Sets the mapping pattern for all dependencies
     * included in this
     *             assembly. Default is
     * ${artifactId}-${version}.${extension}.
     *           
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping() 

    /**
     * Get 
     *             Sets the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Get 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a dependency artifact.
     *           
     */
    public UnpackOptions getUnpackOptions()
    {
        return this.unpackOptions;
    } //-- UnpackOptions getUnpackOptions() 

    /**
     * Get 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack() 

    /**
     * Get 
     *           Determines whether the include/exclude patterns in
     * this dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern, 
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2)
     *           
     */
    public boolean isUseTransitiveFiltering()
    {
        return this.useTransitiveFiltering;
    } //-- boolean isUseTransitiveFiltering() 

    /**
     * Set 
     *             Sets the mapping pattern for all dependencies
     * included in this
     *             assembly. Default is
     * ${artifactId}-${version}.${extension}.
     *           
     * 
     * @param outputFileNameMapping
     */
    public void setOutputFileNameMapping(String outputFileNameMapping)
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping(String) 

    /**
     * Set 
     *             Sets the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Set 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     * 
     * @param unpack
     */
    public void setUnpack(boolean unpack)
    {
        this.unpack = unpack;
    } //-- void setUnpack(boolean) 

    /**
     * Set 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a dependency artifact.
     *           
     * 
     * @param unpackOptions
     */
    public void setUnpackOptions(UnpackOptions unpackOptions)
    {
        this.unpackOptions = unpackOptions;
    } //-- void setUnpackOptions(UnpackOptions) 

    /**
     * Set 
     *           Determines whether the include/exclude patterns in
     * this dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern, 
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2)
     *           
     * 
     * @param useTransitiveFiltering
     */
    public void setUseTransitiveFiltering(boolean useTransitiveFiltering)
    {
        this.useTransitiveFiltering = useTransitiveFiltering;
    } //-- void setUseTransitiveFiltering(boolean) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
