/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         An assembly defines a collection of files usually
 * distributed in an
 *         archive format such as zip, tar, or tar.gz that is
 * generated from a
 *         project.  For example, a project could produce a ZIP
 * assembly which
 *         contains a project's JAR artifact in the root directory,
 * the
 *         runtime dependencies in a lib/ directory, and a shell
 * script to launch
 *         a stand-alone application.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Assembly implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field formats
     */
    private java.util.List formats;

    /**
     * Field includeBaseDirectory
     */
    private boolean includeBaseDirectory = true;

    /**
     * Field baseDirectory
     */
    private String baseDirectory;

    /**
     * Field includeSiteDirectory
     */
    private boolean includeSiteDirectory = false;

    /**
     * Field moduleSets
     */
    private java.util.List moduleSets;

    /**
     * Field fileSets
     */
    private java.util.List fileSets;

    /**
     * Field files
     */
    private java.util.List files;

    /**
     * Field dependencySets
     */
    private java.util.List dependencySets;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * Field componentDescriptors
     */
    private java.util.List componentDescriptors;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addComponentDescriptor
     * 
     * @param string
     */
    public void addComponentDescriptor(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Assembly.addComponentDescriptors(string) parameter must be instanceof " + String.class.getName() );
        }
        getComponentDescriptors().add( string );
    } //-- void addComponentDescriptor(String) 

    /**
     * Method addDependencySet
     * 
     * @param dependencySet
     */
    public void addDependencySet(DependencySet dependencySet)
    {
        if ( !(dependencySet instanceof DependencySet) )
        {
            throw new ClassCastException( "Assembly.addDependencySets(dependencySet) parameter must be instanceof " + DependencySet.class.getName() );
        }
        getDependencySets().add( dependencySet );
    } //-- void addDependencySet(DependencySet) 

    /**
     * Method addFile
     * 
     * @param fileItem
     */
    public void addFile(FileItem fileItem)
    {
        if ( !(fileItem instanceof FileItem) )
        {
            throw new ClassCastException( "Assembly.addFiles(fileItem) parameter must be instanceof " + FileItem.class.getName() );
        }
        getFiles().add( fileItem );
    } //-- void addFile(FileItem) 

    /**
     * Method addFileSet
     * 
     * @param fileSet
     */
    public void addFileSet(FileSet fileSet)
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "Assembly.addFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().add( fileSet );
    } //-- void addFileSet(FileSet) 

    /**
     * Method addFormat
     * 
     * @param string
     */
    public void addFormat(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Assembly.addFormats(string) parameter must be instanceof " + String.class.getName() );
        }
        getFormats().add( string );
    } //-- void addFormat(String) 

    /**
     * Method addModuleSet
     * 
     * @param moduleSet
     */
    public void addModuleSet(ModuleSet moduleSet)
    {
        if ( !(moduleSet instanceof ModuleSet) )
        {
            throw new ClassCastException( "Assembly.addModuleSets(moduleSet) parameter must be instanceof " + ModuleSet.class.getName() );
        }
        getModuleSets().add( moduleSet );
    } //-- void addModuleSet(ModuleSet) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Assembly.addRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Get 
     *             Sets the base directory of the resulting
     * assembly archive. If this is not
     *             set and includeBaseDirectory == true,
     * ${project.build.finalName} will be used instead.
     *             (Since 2.2)
     *           
     */
    public String getBaseDirectory()
    {
        return this.baseDirectory;
    } //-- String getBaseDirectory() 

    /**
     * Method getComponentDescriptors
     */
    public java.util.List getComponentDescriptors()
    {
        if ( this.componentDescriptors == null )
        {
            this.componentDescriptors = new java.util.ArrayList();
        }
        
        return this.componentDescriptors;
    } //-- java.util.List getComponentDescriptors() 

    /**
     * Method getDependencySets
     */
    public java.util.List getDependencySets()
    {
        if ( this.dependencySets == null )
        {
            this.dependencySets = new java.util.ArrayList();
        }
        
        return this.dependencySets;
    } //-- java.util.List getDependencySets() 

    /**
     * Method getFileSets
     */
    public java.util.List getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList();
        }
        
        return this.fileSets;
    } //-- java.util.List getFileSets() 

    /**
     * Method getFiles
     */
    public java.util.List getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList();
        }
        
        return this.files;
    } //-- java.util.List getFiles() 

    /**
     * Method getFormats
     */
    public java.util.List getFormats()
    {
        if ( this.formats == null )
        {
            this.formats = new java.util.ArrayList();
        }
        
        return this.formats;
    } //-- java.util.List getFormats() 

    /**
     * Get 
     *             Sets the id of this assembly. This is a symbolic
     * name for a
     *             particular assembly of files from this project.
     * Also, aside from
     *             being used to distinctly name the assembled
     * package by attaching
     *             its value to the generated archive, the id is
     * used as your
     *             artifact's classifier when deploying.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getModuleSets
     */
    public java.util.List getModuleSets()
    {
        if ( this.moduleSets == null )
        {
            this.moduleSets = new java.util.ArrayList();
        }
        
        return this.moduleSets;
    } //-- java.util.List getModuleSets() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Get 
     *             Includes a base directory in the final archive.
     * For example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory. Default value is true.
     *           
     */
    public boolean isIncludeBaseDirectory()
    {
        return this.includeBaseDirectory;
    } //-- boolean isIncludeBaseDirectory() 

    /**
     * Get 
     *             Includes a site directory in the final archive.
     * The site directory
     *             location of a project is determined by the
     * siteDirectory parameter
     *             of the Assembly Plugin. Default value is false.
     *           
     */
    public boolean isIncludeSiteDirectory()
    {
        return this.includeSiteDirectory;
    } //-- boolean isIncludeSiteDirectory() 

    /**
     * Method removeComponentDescriptor
     * 
     * @param string
     */
    public void removeComponentDescriptor(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Assembly.removeComponentDescriptors(string) parameter must be instanceof " + String.class.getName() );
        }
        getComponentDescriptors().remove( string );
    } //-- void removeComponentDescriptor(String) 

    /**
     * Method removeDependencySet
     * 
     * @param dependencySet
     */
    public void removeDependencySet(DependencySet dependencySet)
    {
        if ( !(dependencySet instanceof DependencySet) )
        {
            throw new ClassCastException( "Assembly.removeDependencySets(dependencySet) parameter must be instanceof " + DependencySet.class.getName() );
        }
        getDependencySets().remove( dependencySet );
    } //-- void removeDependencySet(DependencySet) 

    /**
     * Method removeFile
     * 
     * @param fileItem
     */
    public void removeFile(FileItem fileItem)
    {
        if ( !(fileItem instanceof FileItem) )
        {
            throw new ClassCastException( "Assembly.removeFiles(fileItem) parameter must be instanceof " + FileItem.class.getName() );
        }
        getFiles().remove( fileItem );
    } //-- void removeFile(FileItem) 

    /**
     * Method removeFileSet
     * 
     * @param fileSet
     */
    public void removeFileSet(FileSet fileSet)
    {
        if ( !(fileSet instanceof FileSet) )
        {
            throw new ClassCastException( "Assembly.removeFileSets(fileSet) parameter must be instanceof " + FileSet.class.getName() );
        }
        getFileSets().remove( fileSet );
    } //-- void removeFileSet(FileSet) 

    /**
     * Method removeFormat
     * 
     * @param string
     */
    public void removeFormat(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Assembly.removeFormats(string) parameter must be instanceof " + String.class.getName() );
        }
        getFormats().remove( string );
    } //-- void removeFormat(String) 

    /**
     * Method removeModuleSet
     * 
     * @param moduleSet
     */
    public void removeModuleSet(ModuleSet moduleSet)
    {
        if ( !(moduleSet instanceof ModuleSet) )
        {
            throw new ClassCastException( "Assembly.removeModuleSets(moduleSet) parameter must be instanceof " + ModuleSet.class.getName() );
        }
        getModuleSets().remove( moduleSet );
    } //-- void removeModuleSet(ModuleSet) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        if ( !(repository instanceof Repository) )
        {
            throw new ClassCastException( "Assembly.removeRepositories(repository) parameter must be instanceof " + Repository.class.getName() );
        }
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Set 
     *             Sets the base directory of the resulting
     * assembly archive. If this is not
     *             set and includeBaseDirectory == true,
     * ${project.build.finalName} will be used instead.
     *             (Since 2.2)
     *           
     * 
     * @param baseDirectory
     */
    public void setBaseDirectory(String baseDirectory)
    {
        this.baseDirectory = baseDirectory;
    } //-- void setBaseDirectory(String) 

    /**
     * Set 
     *             
     *             Specifies the shared components xml file
     * locations to include in the
     *             assembly. The locations specified must be
     * relative to the basedir of
     *             the project. When multiple componentDescriptors
     * are found, their
     *             contents are merged. Check out the <a
     * href="component.html">
     *             descriptor components</a> for more information.
     * A
     *             componentDescriptor is specified by providing
     * one or more of
     *             &lt;componentDescriptor&gt; subelements.
     *             
     *           
     * 
     * @param componentDescriptors
     */
    public void setComponentDescriptors(java.util.List componentDescriptors)
    {
        this.componentDescriptors = componentDescriptors;
    } //-- void setComponentDescriptors(java.util.List) 

    /**
     * Set 
     *             
     *             Specifies which dependencies to include in the
     * assembly. A
     *             dependencySet is specified by providing one or
     * more of
     *             &lt;dependencySet&gt; subelements.
     *             
     *           
     * 
     * @param dependencySets
     */
    public void setDependencySets(java.util.List dependencySets)
    {
        this.dependencySets = dependencySets;
    } //-- void setDependencySets(java.util.List) 

    /**
     * Set 
     *             
     *             Specifies which groups of files to include in
     * the assembly. A
     *             fileSet is specified by providing one or more of
     * &lt;fileSet&gt;
     *             subelements.
     *             
     *           
     * 
     * @param fileSets
     */
    public void setFileSets(java.util.List fileSets)
    {
        this.fileSets = fileSets;
    } //-- void setFileSets(java.util.List) 

    /**
     * Set 
     *             
     *             Specifies which single files to include in the
     * assembly. A file
     *             is specified by providing one or more of
     * &lt;file&gt;
     *             subelements.
     *             
     *           
     * 
     * @param files
     */
    public void setFiles(java.util.List files)
    {
        this.files = files;
    } //-- void setFiles(java.util.List) 

    /**
     * Set 
     *             
     *             Specifies the formats of the assembly. Multiple
     * formats can be
     *             supplied and the Assembly Plugin will generate
     * an archive for each
     *             desired formats. When deploying your project,
     * all file formats
     *             specified will also be deployed. A format is
     * specified by supplying
     *             one of the following values in a &lt;format&gt;
     * subelement:
     *             <ul>
     *               <li><b>"zip"</b> - Creates a ZIP file
     * format</li>
     *               <li><b>"gz"</b> - Creates a GZIP format</li>
     *               <li><b>"tar"</b> - Creates a TAR format</li>
     *               <li><b>"tar.gz"</b> - Creates a gzip'd TAR
     * format</li>
     *               <li><b>"tar.bz2</b> - Creates a bzip'd TAR
     * format</li>
     *             </ul>
     *             
     *           
     * 
     * @param formats
     */
    public void setFormats(java.util.List formats)
    {
        this.formats = formats;
    } //-- void setFormats(java.util.List) 

    /**
     * Set 
     *             Sets the id of this assembly. This is a symbolic
     * name for a
     *             particular assembly of files from this project.
     * Also, aside from
     *             being used to distinctly name the assembled
     * package by attaching
     *             its value to the generated archive, the id is
     * used as your
     *             artifact's classifier when deploying.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             Includes a base directory in the final archive.
     * For example,
     *             if you are creating an assembly named
     * "your-app", setting
     *             includeBaseDirectory to true will create an
     * archive that
     *             includes this base directory. If this option is
     * set to false
     *             the archive created will unzip its content to
     * the current
     *             directory. Default value is true.
     *           
     * 
     * @param includeBaseDirectory
     */
    public void setIncludeBaseDirectory(boolean includeBaseDirectory)
    {
        this.includeBaseDirectory = includeBaseDirectory;
    } //-- void setIncludeBaseDirectory(boolean) 

    /**
     * Set 
     *             Includes a site directory in the final archive.
     * The site directory
     *             location of a project is determined by the
     * siteDirectory parameter
     *             of the Assembly Plugin. Default value is false.
     *           
     * 
     * @param includeSiteDirectory
     */
    public void setIncludeSiteDirectory(boolean includeSiteDirectory)
    {
        this.includeSiteDirectory = includeSiteDirectory;
    } //-- void setIncludeSiteDirectory(boolean) 

    /**
     * Set 
     *             
     *             Specifies which module files to include in the
     * assembly. A moduleSet
     *             is specified by providing one or more of
     * &lt;moduleSet&gt;
     *             subelements.
     *             
     *           
     * 
     * @param moduleSets
     */
    public void setModuleSets(java.util.List moduleSets)
    {
        this.moduleSets = moduleSets;
    } //-- void setModuleSets(java.util.List) 

    /**
     * Set 
     *             
     *             Specifies which repository files to include in
     * the assembly. A
     *             repository is specified by providing one or more
     * of
     *             &lt;repository&gt; subelements.
     *             
     *           
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
