/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class SetBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field includes
     */
    private java.util.List includes;

    /**
     * Field excludes
     */
    private java.util.List excludes;

    /**
     * Field fileMode
     */
    private String fileMode = "0644";

    /**
     * Field directoryMode
     */
    private String directoryMode = "0755";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude
     * 
     * @param string
     */
    public void addExclude(String string)
    {
        getExcludes().add( string );
    } //-- void addExclude(String) 

    /**
     * Method addInclude
     * 
     * @param string
     */
    public void addInclude(String string)
    {
        getIncludes().add( string );
    } //-- void addInclude(String) 

    /**
     * Get 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other 
     *             read-only. 
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode() 

    /**
     * Method getExcludes
     */
    public java.util.List getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList();
        }
        
        return this.excludes;
    } //-- java.util.List getExcludes() 

    /**
     * Get 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other 
     *             read-only. 
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode() 

    /**
     * Method getIncludes
     */
    public java.util.List getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList();
        }
        
        return this.includes;
    } //-- java.util.List getIncludes() 

    /**
     * Get 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Method removeExclude
     * 
     * @param string
     */
    public void removeExclude(String string)
    {
        getExcludes().remove( string );
    } //-- void removeExclude(String) 

    /**
     * Method removeInclude
     * 
     * @param string
     */
    public void removeInclude(String string)
    {
        getIncludes().remove( string );
    } //-- void removeInclude(String) 

    /**
     * Set 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other 
     *             read-only. 
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     * 
     * @param directoryMode
     */
    public void setDirectoryMode(String directoryMode)
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode(String) 

    /**
     * Set 
     *             
     *             When &lt;exclude&gt; subelements are present,
     * they define
     *             a set of files and directory to exclude.
     *             
     *           
     * 
     * @param excludes
     */
    public void setExcludes(java.util.List excludes)
    {
        this.excludes = excludes;
    } //-- void setExcludes(java.util.List) 

    /**
     * Set 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other 
     *             read-only. 
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     * 
     * @param fileMode
     */
    public void setFileMode(String fileMode)
    {
        this.fileMode = fileMode;
    } //-- void setFileMode(String) 

    /**
     * Set 
     *             
     *             When &lt;include&gt; subelements are present,
     * they define
     *             a set of files and directory to include.
     *             
     *           
     * 
     * @param includes
     */
    public void setIncludes(java.util.List includes)
    {
        this.includes = includes;
    } //-- void setIncludes(java.util.List) 

    /**
     * Set 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
