/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ModuleSet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includes
     */
    private java.util.List includes;

    /**
     * Field excludes
     */
    private java.util.List excludes;

    /**
     * Field sources
     */
    private ModuleSources sources;

    /**
     * Field binaries
     */
    private ModuleBinaries binaries;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude
     * 
     * @param string
     */
    public void addExclude(String string)
    {
        getExcludes().add( string );
    } //-- void addExclude(String) 

    /**
     * Method addInclude
     * 
     * @param string
     */
    public void addInclude(String string)
    {
        getIncludes().add( string );
    } //-- void addInclude(String) 

    /**
     * Get 
     *             When this is configured, the plugin will include
     * the binaries of the included modules from this set in 
     *             the resulting assembly, according to the
     * configuration.
     *           
     */
    public ModuleBinaries getBinaries()
    {
        return this.binaries;
    } //-- ModuleBinaries getBinaries() 

    /**
     * Method getExcludes
     */
    public java.util.List getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList();
        }
        
        return this.excludes;
    } //-- java.util.List getExcludes() 

    /**
     * Method getIncludes
     */
    public java.util.List getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList();
        }
        
        return this.includes;
    } //-- java.util.List getIncludes() 

    /**
     * Get 
     *             When this is configured, the plugin will include
     * the source files of the included modules from this set in 
     *             the resulting assembly, according to the
     * configuration.
     *           
     */
    public ModuleSources getSources()
    {
        return this.sources;
    } //-- ModuleSources getSources() 

    /**
     * Method removeExclude
     * 
     * @param string
     */
    public void removeExclude(String string)
    {
        getExcludes().remove( string );
    } //-- void removeExclude(String) 

    /**
     * Method removeInclude
     * 
     * @param string
     */
    public void removeInclude(String string)
    {
        getIncludes().remove( string );
    } //-- void removeInclude(String) 

    /**
     * Set 
     *             When this is configured, the plugin will include
     * the binaries of the included modules from this set in 
     *             the resulting assembly, according to the
     * configuration.
     *           
     * 
     * @param binaries
     */
    public void setBinaries(ModuleBinaries binaries)
    {
        this.binaries = binaries;
    } //-- void setBinaries(ModuleBinaries) 

    /**
     * Set 
     *             This is a list of <exclude> elements, each
     * containing a module reference of the type
     * groupId:artifactId.
     *             Modules matching these elements will be excluded
     * from this set.
     *           
     * 
     * @param excludes
     */
    public void setExcludes(java.util.List excludes)
    {
        this.excludes = excludes;
    } //-- void setExcludes(java.util.List) 

    /**
     * Set 
     *             This is a list of <include> elements, each
     * containing a module reference of the type
     * groupId:artifactId.
     *             Modules matching these elements will be included
     * in this set.
     *           
     * 
     * @param includes
     */
    public void setIncludes(java.util.List includes)
    {
        this.includes = includes;
    } //-- void setIncludes(java.util.List) 

    /**
     * Set 
     *             When this is configured, the plugin will include
     * the source files of the included modules from this set in 
     *             the resulting assembly, according to the
     * configuration.
     *           
     * 
     * @param sources
     */
    public void setSources(ModuleSources sources)
    {
        this.sources = sources;
    } //-- void setSources(ModuleSources) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
