/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Configuration for including the binary files for a Module in an
 * assembly.
 * 
 * @version $Revision$ $Date$
 */
public class ModuleBinaries extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includeDependencies
     */
    private boolean includeDependencies = false;

    /**
     * Field unpack
     */
    private boolean unpack = true;

    /**
     * Field outputFileNameMapping
     */
    private String outputFileNameMapping = "${artifactId}-${version}.${extension}";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Specify the mapping pattern for all dependencies
     * included
     *             in this assembly.
     *             Default is
     * ${artifactId}-${version}.${extension}.
     *           
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping() 

    /**
     * Get 
     *             If set to true, the plugin will include the
     * direct and transitive dependencies of
     *             of the project modules included here. 
     * Otherwise, it will only include the module
     *             packages only. Default value is false.
     *           
     */
    public boolean isIncludeDependencies()
    {
        return this.includeDependencies;
    } //-- boolean isIncludeDependencies() 

    /**
     * Get 
     *             If set to true, this property will unpack all
     * module packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     *           
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack() 

    /**
     * Set 
     *             If set to true, the plugin will include the
     * direct and transitive dependencies of
     *             of the project modules included here. 
     * Otherwise, it will only include the module
     *             packages only. Default value is false.
     *           
     * 
     * @param includeDependencies
     */
    public void setIncludeDependencies(boolean includeDependencies)
    {
        this.includeDependencies = includeDependencies;
    } //-- void setIncludeDependencies(boolean) 

    /**
     * Set 
     *             Specify the mapping pattern for all dependencies
     * included
     *             in this assembly.
     *             Default is
     * ${artifactId}-${version}.${extension}.
     *           
     * 
     * @param outputFileNameMapping
     */
    public void setOutputFileNameMapping(String outputFileNameMapping)
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping(String) 

    /**
     * Set 
     *             If set to true, this property will unpack all
     * module packages
     *             into the specified output directory. When set to
     * false
     *             module packages will be included as archives
     * (jars).
     *             Default value is true.
     *           
     * 
     * @param unpack
     */
    public void setUnpack(boolean unpack)
    {
        this.unpack = unpack;
    } //-- void setUnpack(boolean) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
