/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Allows individual file copy with option to change
 * destination
 *         file name not supported by fileSet
 *       
 * 
 * @version $Revision$ $Date$
 */
public class FileItem implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field source
     */
    private String source;

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field destName
     */
    private String destName;

    /**
     * Field fileMode
     */
    private String fileMode = "0644";

    /**
     * Field lineEnding
     */
    private String lineEnding;

    /**
     * Field filtered
     */
    private boolean filtered = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Destination file name in outputDirectory.
     *             Default is the same name as the source's file.
     *           
     */
    public String getDestName()
    {
        return this.destName;
    } //-- String getDestName() 

    /**
     * Get 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other 
     *             read-only. 
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode() 

    /**
     * Get 
     *             
     *             Controls the line-endings of files in this
     * fileSet.
     *             Valid values are: 
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding() 

    /**
     * Get 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Get 
     *             Absolute or relative from the module's
     * directory.
     *           
     */
    public String getSource()
    {
        return this.source;
    } //-- String getSource() 

    /**
     * Get 
     *             Flag used to determine if the file is filtered.
     *           
     */
    public boolean isFiltered()
    {
        return this.filtered;
    } //-- boolean isFiltered() 

    /**
     * Set 
     *             Destination file name in outputDirectory.
     *             Default is the same name as the source's file.
     *           
     * 
     * @param destName
     */
    public void setDestName(String destName)
    {
        this.destName = destName;
    } //-- void setDestName(String) 

    /**
     * Set 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other 
     *             read-only. 
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     * 
     * @param fileMode
     */
    public void setFileMode(String fileMode)
    {
        this.fileMode = fileMode;
    } //-- void setFileMode(String) 

    /**
     * Set 
     *             Flag used to determine if the file is filtered.
     *           
     * 
     * @param filtered
     */
    public void setFiltered(boolean filtered)
    {
        this.filtered = filtered;
    } //-- void setFiltered(boolean) 

    /**
     * Set 
     *             
     *             Controls the line-endings of files in this
     * fileSet.
     *             Valid values are: 
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     * 
     * @param lineEnding
     */
    public void setLineEnding(String lineEnding)
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding(String) 

    /**
     * Set 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

    /**
     * Set 
     *             Absolute or relative from the module's
     * directory.
     *           
     * 
     * @param source
     */
    public void setSource(String source)
    {
        this.source = source;
    } //-- void setSource(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
