/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Defines a dependency set
 * 
 * @version $Revision$ $Date$
 */
public class DependencySet extends SetBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputFileNameMapping
     */
    private String outputFileNameMapping = "${artifactId}-${version}.${extension}";

    /**
     * Field unpack
     */
    private boolean unpack = false;

    /**
     * Field scope
     */
    private String scope = "runtime";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Specify the mapping pattern for all dependencies
     * included
     *             in this assembly.
     *             Default is
     * ${artifactId}-${version}.${extension}.
     *           
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping() 

    /**
     * Get 
     *             Specifies the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Get 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack() 

    /**
     * Set 
     *             Specify the mapping pattern for all dependencies
     * included
     *             in this assembly.
     *             Default is
     * ${artifactId}-${version}.${extension}.
     *           
     * 
     * @param outputFileNameMapping
     */
    public void setOutputFileNameMapping(String outputFileNameMapping)
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping(String) 

    /**
     * Set 
     *             Specifies the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Set 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false
     *             dependencies will be includes as archives
     * (jars).
     *             Default value is false.
     *           
     * 
     * @param unpack
     */
    public void setUnpack(boolean unpack)
    {
        this.unpack = unpack;
    } //-- void setUnpack(boolean) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
