/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.model.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.SetBase;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class AssemblyXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, Assembly assembly) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.serializer.startDocument(assembly.getModelEncoding(), null);
        this.writeAssembly(assembly, "assembly", this.serializer);
        this.serializer.endDocument();
    }

    private void writeAssembly(Assembly assembly, String tagName, XmlSerializer serializer) throws IOException {
        if (assembly != null) {
            SetBase o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (assembly.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(assembly.getId()).endTag(this.NAMESPACE, "id");
            }
            if (assembly.getFormats() != null && assembly.getFormats().size() > 0) {
                serializer.startTag(this.NAMESPACE, "formats");
                iter = assembly.getFormats().iterator();
                while (iter.hasNext()) {
                    String format = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "format").text(format).endTag(this.NAMESPACE, "format");
                }
                serializer.endTag(this.NAMESPACE, "formats");
            }
            if (!assembly.isIncludeBaseDirectory()) {
                serializer.startTag(this.NAMESPACE, "includeBaseDirectory").text(String.valueOf(assembly.isIncludeBaseDirectory())).endTag(this.NAMESPACE, "includeBaseDirectory");
            }
            if (assembly.isIncludeSiteDirectory()) {
                serializer.startTag(this.NAMESPACE, "includeSiteDirectory").text(String.valueOf(assembly.isIncludeSiteDirectory())).endTag(this.NAMESPACE, "includeSiteDirectory");
            }
            if (assembly.getFileSets() != null && assembly.getFileSets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "fileSets");
                iter = assembly.getFileSets().iterator();
                while (iter.hasNext()) {
                    o = (FileSet)iter.next();
                    this.writeFileSet((FileSet)o, "fileSet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "fileSets");
            }
            if (assembly.getDependencySets() != null && assembly.getDependencySets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencySets");
                iter = assembly.getDependencySets().iterator();
                while (iter.hasNext()) {
                    o = (DependencySet)iter.next();
                    this.writeDependencySet((DependencySet)o, "dependencySet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencySets");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer) throws IOException {
        if (dependencySet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals("${artifactId}-${version}.${extension}")) {
                serializer.startTag(this.NAMESPACE, "outputFileNameMapping").text(dependencySet.getOutputFileNameMapping()).endTag(this.NAMESPACE, "outputFileNameMapping");
            }
            if (dependencySet.isUnpack()) {
                serializer.startTag(this.NAMESPACE, "unpack").text(String.valueOf(dependencySet.isUnpack())).endTag(this.NAMESPACE, "unpack");
            }
            if (dependencySet.getScope() != null && !dependencySet.getScope().equals("runtime")) {
                serializer.startTag(this.NAMESPACE, "scope").text(dependencySet.getScope()).endTag(this.NAMESPACE, "scope");
            }
            if (dependencySet.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(dependencySet.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = dependencySet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = dependencySet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (dependencySet.getFileMode() != null && !dependencySet.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(dependencySet.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (dependencySet.getDirectoryMode() != null && !dependencySet.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(dependencySet.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileSet.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (fileSet.getLineEnding() != null) {
                serializer.startTag(this.NAMESPACE, "lineEnding").text(fileSet.getLineEnding()).endTag(this.NAMESPACE, "lineEnding");
            }
            if (fileSet.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(fileSet.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (fileSet.getFileMode() != null && !fileSet.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(fileSet.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(fileSet.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer) throws IOException {
        if (setBase != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (setBase.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(setBase.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (setBase.getIncludes() != null && setBase.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = setBase.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (setBase.getExcludes() != null && setBase.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = setBase.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (setBase.getFileMode() != null && !setBase.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(setBase.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(setBase.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

