/*
 * $Id$
 */

package org.apache.maven.plugins.assembly.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.SetBase;
import org.codehaus.plexus.util.xml.pull.*;

/**
 * Class AssemblyXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class AssemblyXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field serializer
     */
    private org.codehaus.plexus.util.xml.pull.XmlSerializer serializer;

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param assembly
     */
    public void write(Writer writer, Assembly assembly)
        throws java.io.IOException
    {
        serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( assembly.getModelEncoding(), null );
        writeAssembly( assembly, "assembly", serializer );
        serializer.endDocument();
    } //-- void write(Writer, Assembly) 

    /**
     * Method writeAssembly
     * 
     * @param assembly
     * @param serializer
     * @param tagName
     */
    private void writeAssembly(Assembly assembly, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( assembly != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( assembly.getId() != null )
            {
                serializer.startTag( NAMESPACE, "id" ).text( assembly.getId() ).endTag( NAMESPACE, "id" );
            }
            if ( assembly.getFormats() != null && assembly.getFormats().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "formats" );
                for ( Iterator iter = assembly.getFormats().iterator(); iter.hasNext(); )
                {
                    String format = (String) iter.next();
                    serializer.startTag( NAMESPACE, "format" ).text( format ).endTag( NAMESPACE, "format" );
                }
                serializer.endTag( NAMESPACE, "formats" );
            }
            if ( assembly.isIncludeBaseDirectory() != true )
            {
                serializer.startTag( NAMESPACE, "includeBaseDirectory" ).text( String.valueOf( assembly.isIncludeBaseDirectory() ) ).endTag( NAMESPACE, "includeBaseDirectory" );
            }
            if ( assembly.isIncludeSiteDirectory() != false )
            {
                serializer.startTag( NAMESPACE, "includeSiteDirectory" ).text( String.valueOf( assembly.isIncludeSiteDirectory() ) ).endTag( NAMESPACE, "includeSiteDirectory" );
            }
            if ( assembly.getFileSets() != null && assembly.getFileSets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "fileSets" );
                for ( Iterator iter = assembly.getFileSets().iterator(); iter.hasNext(); )
                {
                    FileSet o = (FileSet) iter.next();
                    writeFileSet( o, "fileSet", serializer );
                }
                serializer.endTag( NAMESPACE, "fileSets" );
            }
            if ( assembly.getDependencySets() != null && assembly.getDependencySets().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "dependencySets" );
                for ( Iterator iter = assembly.getDependencySets().iterator(); iter.hasNext(); )
                {
                    DependencySet o = (DependencySet) iter.next();
                    writeDependencySet( o, "dependencySet", serializer );
                }
                serializer.endTag( NAMESPACE, "dependencySets" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeAssembly(Assembly, String, XmlSerializer) 

    /**
     * Method writeDependencySet
     * 
     * @param dependencySet
     * @param serializer
     * @param tagName
     */
    private void writeDependencySet(DependencySet dependencySet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( dependencySet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( dependencySet.getOutputFileNameMapping() != null && !dependencySet.getOutputFileNameMapping().equals( "${artifactId}-${version}.${extension}" ) )
            {
                serializer.startTag( NAMESPACE, "outputFileNameMapping" ).text( dependencySet.getOutputFileNameMapping() ).endTag( NAMESPACE, "outputFileNameMapping" );
            }
            if ( dependencySet.isUnpack() != false )
            {
                serializer.startTag( NAMESPACE, "unpack" ).text( String.valueOf( dependencySet.isUnpack() ) ).endTag( NAMESPACE, "unpack" );
            }
            if ( dependencySet.getScope() != null && !dependencySet.getScope().equals( "runtime" ) )
            {
                serializer.startTag( NAMESPACE, "scope" ).text( dependencySet.getScope() ).endTag( NAMESPACE, "scope" );
            }
            if ( dependencySet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( dependencySet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( dependencySet.getIncludes() != null && dependencySet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = dependencySet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( dependencySet.getExcludes() != null && dependencySet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = dependencySet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( dependencySet.getFileMode() != null && !dependencySet.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( dependencySet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( dependencySet.getDirectoryMode() != null && !dependencySet.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( dependencySet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDependencySet(DependencySet, String, XmlSerializer) 

    /**
     * Method writeFileSet
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     */
    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "directory" ).text( fileSet.getDirectory() ).endTag( NAMESPACE, "directory" );
            }
            if ( fileSet.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            if ( fileSet.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( fileSet.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( fileSet.getFileMode() != null && !fileSet.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( fileSet.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( fileSet.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet(FileSet, String, XmlSerializer) 

    /**
     * Method writeSetBase
     * 
     * @param setBase
     * @param serializer
     * @param tagName
     */
    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( setBase != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( setBase.getOutputDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "outputDirectory" ).text( setBase.getOutputDirectory() ).endTag( NAMESPACE, "outputDirectory" );
            }
            if ( setBase.getIncludes() != null && setBase.getIncludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = setBase.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( setBase.getExcludes() != null && setBase.getExcludes().size() > 0 )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = setBase.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( setBase.getFileMode() != null && !setBase.getFileMode().equals( "0644" ) )
            {
                serializer.startTag( NAMESPACE, "fileMode" ).text( setBase.getFileMode() ).endTag( NAMESPACE, "fileMode" );
            }
            if ( setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals( "0755" ) )
            {
                serializer.startTag( NAMESPACE, "directoryMode" ).text( setBase.getDirectoryMode() ).endTag( NAMESPACE, "directoryMode" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSetBase(SetBase, String, XmlSerializer) 

}
