/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.AbstractUnpackingMojo;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AssemblyMojo
extends AbstractUnpackingMojo {
    protected String descriptorId;
    protected File descriptor;
    private String basedir;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File tempRoot;

    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating assembly", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() throws ArchiverException, IOException, MojoExecutionException, XmlPullParserException {
        InputStreamReader r = null;
        if (this.descriptor != null) {
            r = new FileReader(this.descriptor);
        } else if (this.descriptorId != null) {
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/assemblies/" + this.descriptorId + ".xml");
            if (resourceAsStream == null) {
                throw new MojoExecutionException("Descriptor with ID '" + this.descriptorId + "' not found");
            }
            r = new InputStreamReader(resourceAsStream);
        } else {
            throw new MojoExecutionException("You must specify descriptor or descriptorId");
        }
        try {
            AssemblyXpp3Reader reader = new AssemblyXpp3Reader();
            Assembly assembly = reader.read(r);
            String fullName = this.finalName + "-" + assembly.getId();
            Iterator i = assembly.getFormats().iterator();
            while (i.hasNext()) {
                String format = (String)i.next();
                String filename = fullName + "." + format;
                Archiver archiver = AssemblyMojo.createArchiver(format);
                this.processFileSets(archiver, assembly.getFileSets(), assembly.isIncludeBaseDirectory());
                this.processDependencySets(archiver, assembly.getDependencySets(), assembly.isIncludeBaseDirectory());
                File destFile = new File(this.outputDirectory, filename);
                archiver.setDestFile(destFile);
                archiver.createArchive();
                this.projectHelper.attachArtifact(this.project, format, format + "-assembly", destFile);
            }
        }
        finally {
            IOUtil.close((Reader)r);
        }
    }

    private void processDependencySets(Archiver archiver, List dependencySets, boolean includeBaseDirectory) throws ArchiverException, IOException, MojoExecutionException {
        Iterator i = dependencySets.iterator();
        while (i.hasNext()) {
            DependencySet dependencySet = (DependencySet)i.next();
            String output = dependencySet.getOutputDirectory();
            output = this.getOutputDirectory(output, includeBaseDirectory);
            archiver.setDefaultDirectoryMode(Integer.parseInt(dependencySet.getDirectoryMode(), 8));
            archiver.setDefaultFileMode(Integer.parseInt(dependencySet.getFileMode(), 8));
            this.getLog().debug((CharSequence)("DependencySet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8)));
            AndArtifactFilter filter = new AndArtifactFilter();
            filter.add((ArtifactFilter)new ScopeArtifactFilter(dependencySet.getScope()));
            if (!dependencySet.getIncludes().isEmpty()) {
                filter.add((ArtifactFilter)new IncludesArtifactFilter(dependencySet.getIncludes()));
            }
            if (!dependencySet.getExcludes().isEmpty()) {
                filter.add((ArtifactFilter)new ExcludesArtifactFilter(dependencySet.getExcludes()));
            }
            Iterator j = this.dependencies.iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                if (!filter.include(artifact)) continue;
                String name = artifact.getFile().getName();
                if (dependencySet.isUnpack()) {
                    File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
                    boolean process = false;
                    if (!tempLocation.exists()) {
                        tempLocation.mkdirs();
                        process = true;
                    } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                        process = true;
                    }
                    if (process) {
                        this.unpack(artifact.getFile(), tempLocation);
                    }
                    archiver.addDirectory(tempLocation, null, AssemblyMojo.getJarExcludes().toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY));
                    continue;
                }
                archiver.addFile(artifact.getFile(), output + AssemblyMojo.evaluateFileNameMapping(dependencySet.getOutputFileNameMapping(), artifact));
            }
        }
    }

    private void processFileSets(Archiver archiver, List fileSets, boolean includeBaseDirecetory) throws ArchiverException {
        Iterator i = fileSets.iterator();
        while (i.hasNext()) {
            FileSet fileSet = (FileSet)i.next();
            String directory = fileSet.getDirectory();
            String output = fileSet.getOutputDirectory();
            String lineEnding = AssemblyMojo.getLineEndingCharacters(fileSet.getLineEnding());
            File tmpDir = null;
            if (lineEnding != null) {
                tmpDir = FileUtils.createTempFile((String)"", (String)"", (File)this.tempRoot);
                tmpDir.mkdirs();
            }
            archiver.setDefaultDirectoryMode(Integer.parseInt(fileSet.getDirectoryMode(), 8));
            archiver.setDefaultFileMode(Integer.parseInt(fileSet.getFileMode(), 8));
            this.getLog().debug((CharSequence)("FileSet[" + output + "]" + " dir perms: " + Integer.toString(archiver.getDefaultDirectoryMode(), 8) + " file perms: " + Integer.toString(archiver.getDefaultFileMode(), 8) + (fileSet.getLineEnding() == null ? "" : " lineEndings: " + fileSet.getLineEnding())));
            if (directory == null) {
                directory = this.basedir;
                if (output == null) {
                    output = "";
                }
            } else if (output == null) {
                output = directory;
            }
            output = this.getOutputDirectory(output, includeBaseDirecetory);
            String[] includes = fileSet.getIncludes().toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY);
            if (includes.length == 0) {
                includes = null;
            }
            List excludesList = fileSet.getExcludes();
            excludesList.addAll(AssemblyMojo.getDefaultExcludes());
            String[] excludes = excludesList.toArray(AbstractUnpackingMojo.EMPTY_STRING_ARRAY);
            File archiveBaseDir = new File(directory);
            if (lineEnding != null) {
                this.copySetReplacingLineEndings(archiveBaseDir, tmpDir, includes, excludes, lineEnding);
                archiveBaseDir = tmpDir;
            }
            archiver.addDirectory(archiveBaseDir, output, includes, excludes);
        }
    }

    private static String evaluateFileNameMapping(String expression, Artifact artifact) throws MojoExecutionException {
        Pattern pat = Pattern.compile("^(.*)\\$\\{([^\\}]+)\\}(.*)$");
        Matcher mat = pat.matcher(expression);
        if (mat.matches()) {
            Object middle;
            String left = AssemblyMojo.evaluateFileNameMapping(mat.group(1), artifact);
            try {
                middle = ReflectionValueExtractor.evaluate((String)("dep." + mat.group(2)), (Object)artifact);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot evaluate filenameMapping", e);
            }
            String right = mat.group(3);
            if (middle == null) {
                if (mat.group(2).trim().equals("extension")) {
                    ArtifactHandler artifactHandler = artifact.getArtifactHandler();
                    middle = artifactHandler.getExtension();
                } else {
                    middle = "${" + mat.group(2) + "}";
                }
            }
            return left + middle + right;
        }
        return expression;
    }

    private static List getJarExcludes() {
        ArrayList<String> l = new ArrayList<String>(AssemblyMojo.getDefaultExcludes());
        l.add("META-INF/**");
        return l;
    }

    private String getOutputDirectory(String output, boolean includeBaseDirectory) {
        if (output == null) {
            output = "";
        }
        if (!output.endsWith("/") && !output.endsWith("\\")) {
            output = output + '/';
        }
        if (includeBaseDirectory) {
            output = output.startsWith("/") ? this.finalName + output : this.finalName + "/" + output;
        } else if (output.startsWith("/")) {
            output = output.substring(1);
        }
        return output;
    }

    private static Archiver createArchiver(String format) throws ArchiverException {
        TarArchiver archiver;
        if (format.startsWith("tar")) {
            TarArchiver tarArchiver;
            archiver = tarArchiver = new TarArchiver();
            int index = format.indexOf(46);
            if (index >= 0) {
                TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
                String compression = format.substring(index + 1);
                if (compression.equals("gz")) {
                    tarCompressionMethod.setValue("gzip");
                } else if (compression.equals("bz2")) {
                    tarCompressionMethod.setValue("bzip2");
                } else {
                    throw new IllegalArgumentException("Unknown compression format: " + compression);
                }
                tarArchiver.setCompression(tarCompressionMethod);
            }
        } else if (format.startsWith("zip")) {
            archiver = new ZipArchiver();
        } else if (format.startsWith("jar")) {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setCompress(true);
            archiver = jarArchiver;
        } else {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        return archiver;
    }

    public static List getDefaultExcludes() {
        ArrayList<String> defaultExcludes = new ArrayList<String>();
        defaultExcludes.add("**/*~");
        defaultExcludes.add("**/#*#");
        defaultExcludes.add("**/.#*");
        defaultExcludes.add("**/%*%");
        defaultExcludes.add("**/._*");
        defaultExcludes.add("**/CVS");
        defaultExcludes.add("**/CVS/**");
        defaultExcludes.add("**/.cvsignore");
        defaultExcludes.add("**/SCCS");
        defaultExcludes.add("**/SCCS/**");
        defaultExcludes.add("**/vssver.scc");
        defaultExcludes.add("**/.svn");
        defaultExcludes.add("**/.svn/**");
        defaultExcludes.add("**/.DS_Store");
        return defaultExcludes;
    }

    private void copyReplacingLineEndings(File source, File dest, String lineEndings) throws IOException {
        String line;
        this.getLog().debug((CharSequence)("Copying while replacing line endings: " + source + " to " + dest));
        BufferedReader in = new BufferedReader(new FileReader(source));
        BufferedWriter out = new BufferedWriter(new FileWriter(dest));
        while ((line = in.readLine()) != null) {
            out.write(line);
            out.write(lineEndings);
        }
        out.flush();
        out.close();
    }

    private void copySetReplacingLineEndings(File archiveBaseDir, File tmpDir, String[] includes, String[] excludes, String lineEnding) throws ArchiverException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(archiveBaseDir.getAbsolutePath());
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            new File(this.tempRoot, dirs[j]).mkdirs();
        }
        String[] files = scanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            File targetFile = new File(tmpDir, files[j]);
            try {
                targetFile.getParentFile().mkdirs();
                this.copyReplacingLineEndings(new File(archiveBaseDir, files[j]), targetFile, lineEnding);
                continue;
            }
            catch (IOException e) {
                throw new ArchiverException("Error copying file '" + files[j] + "' to '" + targetFile + "'", (Throwable)e);
            }
        }
    }

    private static String getLineEndingCharacters(String lineEnding) throws ArchiverException {
        if (lineEnding != null) {
            if (lineEnding.equals("keep")) {
                lineEnding = null;
            } else if (lineEnding.equals("dos") || lineEnding.equals("crlf")) {
                lineEnding = "\r\n";
            } else if (lineEnding.equals("unix") || lineEnding.equals("lf")) {
                lineEnding = "\n";
            } else {
                throw new ArchiverException("Illlegal lineEnding specified: '" + lineEnding + "'");
            }
        }
        return lineEnding;
    }
}

