/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractUnpackingMojo
extends AbstractMojo {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected File outputDirectory;
    protected String finalName;
    protected Set dependencies;
    protected File workDirectory;

    protected void unpack(File file, File location) throws IOException {
        String fileName = file.getAbsolutePath().toLowerCase().trim();
        if (fileName.endsWith("jar")) {
            this.unpackJar(file, location);
        } else if (fileName.endsWith("zip")) {
            this.unpackZip(file, location);
        }
    }

    private void unpackJar(File file, File tempLocation) throws IOException {
        if (!file.getAbsolutePath().toLowerCase().trim().endsWith("jar")) {
            this.getLog().warn((CharSequence)("Trying to unpack a non-jar file " + file.getAbsolutePath() + " - IGNORING"));
            return;
        }
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            File outFile = new File(tempLocation, entry.getName());
            outFile.getParentFile().mkdirs();
            IOUtil.copy((InputStream)jar.getInputStream(entry), (OutputStream)new FileOutputStream(outFile));
        }
    }

    private void unpackZip(File file, File tempLocation) throws IOException {
        if (!file.getAbsolutePath().toLowerCase().trim().endsWith("zip")) {
            this.getLog().warn((CharSequence)("Trying to unpack a non-zip file " + file.getAbsolutePath() + " - IGNORING"));
            return;
        }
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            File outFile = new File(tempLocation, entry.getName());
            outFile.getParentFile().mkdirs();
            IOUtil.copy((InputStream)zip.getInputStream(entry), (OutputStream)new FileOutputStream(outFile));
        }
    }
}

